/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.gss;

import org.apache.sshd.common.SshException;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.auth.AbstractUserAuth;
import org.apache.sshd.server.auth.gss.GSSAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public class UserAuthGSS
extends AbstractUserAuth {
    public static final Oid KRB5_MECH = UserAuthGSS.createOID("1.2.840.113554.1.2.2");
    public static final Oid KRB5_NT_PRINCIPAL = UserAuthGSS.createOID("1.2.840.113554.1.2.2.1");
    private GSSContext context;
    private String identity;

    @Override
    protected Boolean doAuth(Buffer buffer, boolean initial) throws Exception {
        GSSAuthenticator auth = this.getAuthenticator(this.session);
        if (initial) {
            int num = buffer.getInt();
            for (int i = 0; i < num; ++i) {
                Oid oid = new Oid(buffer.getBytes());
                if (!oid.equals(KRB5_MECH)) continue;
                this.log.debug("UserAuthGSS: found Kerberos 5");
                if (!auth.validateInitialUser(this.session, this.username)) {
                    return Boolean.FALSE;
                }
                GSSManager mgr = auth.getGSSManager();
                GSSCredential creds = auth.getGSSCredential(mgr);
                if (creds == null) {
                    return Boolean.FALSE;
                }
                this.context = mgr.createContext(creds);
                Buffer b = this.session.createBuffer((byte)60);
                byte[] out = oid.getDER();
                b.putBytes(out);
                this.session.writePacket(b);
                return null;
            }
            return Boolean.FALSE;
        }
        int msg = buffer.getUByte();
        if (!(msg == 61 || msg == 66 && this.context.isEstablished())) {
            throw new SshException(2, "Packet not supported by user authentication method: " + msg);
        }
        this.log.debug("In krb5.next: msg = " + msg);
        if (this.context.isEstablished()) {
            if (msg != 66) {
                return Boolean.FALSE;
            }
            ByteArrayBuffer msgbuf = new ByteArrayBuffer();
            msgbuf.putBytes(ValidateUtils.checkNotNullAndNotEmpty(this.session.getSessionId(), "No current session ID", new Object[0]));
            ((Buffer)msgbuf).putByte((byte)50);
            msgbuf.putString(this.username);
            msgbuf.putString(this.service);
            msgbuf.putString("gssapi-with-mic");
            byte[] msgbytes = msgbuf.getCompactData();
            byte[] inmic = buffer.getBytes();
            try {
                this.context.verifyMIC(inmic, 0, inmic.length, msgbytes, 0, msgbytes.length, new MessageProp(false));
                this.log.debug("MIC verified");
                return Boolean.TRUE;
            }
            catch (GSSException e) {
                this.log.info("GSS verification error: {}", (Object)e.toString());
                return Boolean.FALSE;
            }
        }
        byte[] tok = buffer.getBytes();
        byte[] out = this.context.acceptSecContext(tok, 0, tok.length);
        boolean established = this.context.isEstablished();
        if (established && this.identity == null) {
            this.identity = this.context.getSrcName().toString();
            this.log.info("GSS identity is {}", (Object)this.identity);
            if (!auth.validateIdentity(this.session, this.identity)) {
                return Boolean.FALSE;
            }
        }
        if (out != null && out.length > 0) {
            Buffer b = this.session.createBuffer((byte)61);
            b.putBytes(out);
            this.session.writePacket(b);
            return null;
        }
        return established;
    }

    @Override
    public String getUserName() {
        return this.identity != null ? this.identity : this.username;
    }

    @Override
    public void destroy() {
        if (this.context != null) {
            try {
                this.context.dispose();
            }
            catch (GSSException gSSException) {
            }
            finally {
                this.context = null;
            }
        }
    }

    protected GSSAuthenticator getAuthenticator(ServerSession session) throws Exception {
        ServerFactoryManager manager = session.getFactoryManager();
        return ValidateUtils.checkNotNull(manager.getGSSAuthenticator(), "No GSSAuthenticator configured");
    }

    private static Oid createOID(String rep) {
        try {
            return new Oid(rep);
        }
        catch (GSSException e) {
            return null;
        }
    }
}

