/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth;

import java.security.PublicKey;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.auth.AbstractUserAuth;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;

public class UserAuthPublicKey
extends AbstractUserAuth {
    @Override
    public Boolean doAuth(Buffer buffer, boolean init) throws Exception {
        ValidateUtils.checkTrue(init, "Instance not initialized");
        boolean hasSig = buffer.getBoolean();
        String alg = buffer.getString();
        int oldLim = buffer.wpos();
        int oldPos = buffer.rpos();
        int len = buffer.getInt();
        buffer.wpos(buffer.rpos() + len);
        PublicKey key = buffer.getRawPublicKey();
        ServerFactoryManager manager = this.session.getFactoryManager();
        Signature verif = ValidateUtils.checkNotNull(NamedFactory.Utils.create(manager.getSignatureFactories(), alg), "No verifier located for algorithm=%s", (Object)alg);
        verif.initVerifier(key);
        buffer.wpos(oldLim);
        byte[] sig = hasSig ? buffer.getBytes() : null;
        PublickeyAuthenticator authenticator = ValidateUtils.checkNotNull(manager.getPublickeyAuthenticator(), "No PublickeyAuthenticator configured");
        if (!authenticator.authenticate(this.username, key, this.session)) {
            return Boolean.FALSE;
        }
        if (!hasSig) {
            Buffer buf = this.session.createBuffer((byte)60);
            buf.putString(alg);
            buf.putRawBytes(buffer.array(), oldPos, 4 + len);
            this.session.writePacket(buf);
            return null;
        }
        ByteArrayBuffer buf = new ByteArrayBuffer();
        buf.putBytes(this.session.getKex().getH());
        ((Buffer)buf).putByte((byte)50);
        buf.putString(this.username);
        buf.putString(this.service);
        buf.putString("publickey");
        buf.putBoolean(true);
        buf.putString(alg);
        buffer.rpos(oldPos);
        buffer.wpos(oldPos + 4 + len);
        buf.putBuffer(buffer);
        verif.update(((Buffer)buf).array(), ((Buffer)buf).rpos(), buf.available());
        if (!verif.verify(sig)) {
            throw new Exception("Key verification failed");
        }
        return Boolean.TRUE;
    }
}

