/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.sshd.client.auth.UserAuth;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class UserAuthPassword
extends AbstractLoggingBean
implements UserAuth {
    private ClientSession session;
    private String service;
    private Iterator<String> passwords;
    private String current;

    @Override
    public void init(ClientSession session, String service, Collection<?> identities) throws Exception {
        this.session = session;
        this.service = service;
        ArrayList<String> pwds = new ArrayList<String>();
        for (Object o : identities) {
            if (!(o instanceof String)) continue;
            pwds.add((String)o);
        }
        this.passwords = pwds.iterator();
    }

    @Override
    public boolean process(Buffer buffer) throws Exception {
        if (buffer == null) {
            if (this.passwords.hasNext()) {
                this.current = this.passwords.next();
                this.log.debug("Send SSH_MSG_USERAUTH_REQUEST for password");
                buffer = this.session.createBuffer((byte)50);
                buffer.putString(this.session.getUsername());
                buffer.putString(this.service);
                buffer.putString("password");
                buffer.putBoolean(false);
                buffer.putString(this.current);
                this.session.writePacket(buffer);
                return true;
            }
            return false;
        }
        int cmd = buffer.getUByte();
        if (cmd == 60) {
            String prompt = buffer.getString();
            String lang = buffer.getString();
            this.log.warn(prompt + " - Password change requested, but not supported for lang=" + lang);
            return false;
        }
        throw new IllegalStateException("Received unknown packet");
    }

    @Override
    public void destroy() {
    }
}

