/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.ServerKeyVerifier;
import org.apache.sshd.client.SessionFactory;
import org.apache.sshd.client.auth.UserAuth;
import org.apache.sshd.client.auth.UserAuthKeyboardInteractiveFactory;
import org.apache.sshd.client.auth.UserAuthPasswordFactory;
import org.apache.sshd.client.auth.UserAuthPublicKeyFactory;
import org.apache.sshd.client.auth.UserInteraction;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.config.keys.ClientIdentity;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.future.DefaultConnectFuture;
import org.apache.sshd.client.session.ClientConnectionServiceFactory;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientUserAuthServiceFactory;
import org.apache.sshd.common.AbstractFactoryManager;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.ServiceFactory;
import org.apache.sshd.common.SshdSocketAddress;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.keyprovider.AbstractFileKeyPairProvider;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.NoCloseInputStream;
import org.apache.sshd.common.util.io.NoCloseOutputStream;

public class SshClient
extends AbstractFactoryManager
implements ClientFactoryManager,
Closeable {
    public static final Factory<SshClient> DEFAULT_SSH_CLIENT_FACTORY = new Factory<SshClient>(){

        @Override
        public SshClient create() {
            return new SshClient();
        }
    };
    public static final List<NamedFactory<UserAuth>> DEFAULT_USER_AUTH_FACTORIES = Collections.unmodifiableList(Arrays.asList(UserAuthPublicKeyFactory.INSTANCE, UserAuthKeyboardInteractiveFactory.INSTANCE, UserAuthPasswordFactory.INSTANCE));
    public static final List<ServiceFactory> DEFAULT_SERVICE_FACTORIES = Collections.unmodifiableList(Arrays.asList(ClientUserAuthServiceFactory.INSTANCE, ClientConnectionServiceFactory.INSTANCE));
    protected IoConnector connector;
    protected SessionFactory sessionFactory;
    protected UserInteraction userInteraction;
    protected List<NamedFactory<UserAuth>> userAuthFactories;
    private ServerKeyVerifier serverKeyVerifier;

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public ServerKeyVerifier getServerKeyVerifier() {
        return this.serverKeyVerifier;
    }

    public void setServerKeyVerifier(ServerKeyVerifier serverKeyVerifier) {
        this.serverKeyVerifier = serverKeyVerifier;
    }

    @Override
    public UserInteraction getUserInteraction() {
        return this.userInteraction;
    }

    public void setUserInteraction(UserInteraction userInteraction) {
        this.userInteraction = userInteraction;
    }

    @Override
    public List<NamedFactory<UserAuth>> getUserAuthFactories() {
        return this.userAuthFactories;
    }

    public void setUserAuthFactories(List<NamedFactory<UserAuth>> userAuthFactories) {
        this.userAuthFactories = userAuthFactories;
    }

    @Override
    protected void checkConfig() {
        super.checkConfig();
        ValidateUtils.checkNotNull(this.getTcpipForwarderFactory(), "TcpipForwarderFactory not set");
        ValidateUtils.checkNotNull(this.getServerKeyVerifier(), "ServerKeyVerifier not set");
        SshAgentFactory agentFactory = this.getAgentFactory();
        if (agentFactory != null) {
            List<NamedFactory<Channel>> factories = this.getChannelFactories();
            factories = GenericUtils.isEmpty(factories) ? new ArrayList<NamedFactory<Channel>>() : new ArrayList<NamedFactory<Channel>>(factories);
            factories.add(ValidateUtils.checkNotNull(agentFactory.getChannelForwardingFactory(), "No agent channel forwarding factory for %s", (Object)agentFactory));
            this.setChannelFactories(factories);
        }
        if (GenericUtils.isEmpty(this.getServiceFactories())) {
            this.setServiceFactories(DEFAULT_SERVICE_FACTORIES);
        }
        if (GenericUtils.isEmpty(this.getUserAuthFactories())) {
            this.setUserAuthFactories(DEFAULT_USER_AUTH_FACTORIES);
        }
    }

    public void start() {
        this.checkConfig();
        if (this.sessionFactory == null) {
            this.sessionFactory = this.createSessionFactory();
        }
        this.setupSessionTimeout(this.sessionFactory);
        this.sessionFactory.setClient(this);
        this.connector = this.createConnector();
    }

    public void stop() {
        try {
            this.close(true).await();
        }
        catch (IOException e) {
            this.log.debug("Exception caught while stopping client", (Throwable)e);
        }
    }

    public void open() throws IOException {
        this.start();
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().run(new Runnable(){

            @Override
            public void run() {
                SshClient.this.removeSessionTimeout(SshClient.this.sessionFactory);
            }
        }).sequential(this.connector, this.ioServiceFactory).run(new Runnable(){

            @Override
            public void run() {
                SshClient.this.connector = null;
                SshClient.this.ioServiceFactory = null;
                if (SshClient.this.shutdownExecutor && SshClient.this.executor != null && !SshClient.this.executor.isShutdown()) {
                    try {
                        SshClient.this.executor.shutdownNow();
                    }
                    finally {
                        SshClient.this.executor = null;
                    }
                }
            }
        }).build();
    }

    public ConnectFuture connect(String username, String host, int port) throws IOException {
        assert (host != null);
        assert (port >= 0);
        if (this.connector == null) {
            throw new IllegalStateException("SshClient not started. Please call start() method before connecting to a server");
        }
        InetSocketAddress address = new InetSocketAddress(host, port);
        return this.connect(username, address);
    }

    public ConnectFuture connect(final String username, SocketAddress address) {
        assert (address != null);
        if (this.connector == null) {
            throw new IllegalStateException("SshClient not started. Please call start() method before connecting to a server");
        }
        final DefaultConnectFuture connectFuture = new DefaultConnectFuture((Object)null);
        this.connector.connect(address).addListener(new SshFutureListener<IoConnectFuture>(){

            @Override
            public void operationComplete(IoConnectFuture future) {
                if (future.isCanceled()) {
                    connectFuture.cancel();
                } else if (future.getException() != null) {
                    connectFuture.setException(future.getException());
                } else {
                    ClientSession session = (ClientSession)((Object)AbstractSession.getSession(future.getSession()));
                    session.setUsername(username);
                    connectFuture.setSession(session);
                }
            }
        });
        return connectFuture;
    }

    protected IoConnector createConnector() {
        return this.getIoServiceFactory().createConnector(this.getSessionFactory());
    }

    protected SessionFactory createSessionFactory() {
        return new SessionFactory();
    }

    public String toString() {
        return "SshClient[" + Integer.toHexString(this.hashCode()) + "]";
    }

    public static SshClient setUpDefaultClient() {
        return (SshClient)ClientBuilder.builder().build();
    }

    public static ClientSession setupClientSession(String portOption, final BufferedReader stdin, final PrintStream stdout, PrintStream stderr, String ... args) throws Exception {
        int port = -1;
        String host = null;
        String login = null;
        boolean error = false;
        ArrayList<File> identities = new ArrayList<File>();
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        int numArgs = GenericUtils.length(args);
        for (int i = 0; i < numArgs; ++i) {
            int pos;
            String argName = args[i];
            if (portOption.equals(argName)) {
                if (i + 1 >= numArgs) {
                    stderr.println("option requires an argument: " + argName);
                    error = true;
                    break;
                }
                if (port > 0) {
                    stderr.println(argName + " option value re-specified: " + port);
                    error = true;
                    break;
                }
                if ((port = Integer.parseInt(args[++i])) > 0) continue;
                stderr.println("Bad option value for " + argName + ": " + port);
                error = true;
                break;
            }
            if ("-i".equals(argName)) {
                if (i + 1 >= numArgs) {
                    stderr.println("option requires and argument: " + argName);
                    error = true;
                    break;
                }
                File f = new File(args[++i]);
                identities.add(f);
                continue;
            }
            if ("-o".equals(argName)) {
                String opt;
                int idx;
                if (i + 1 >= numArgs) {
                    stderr.println("option requires and argument: " + argName);
                    error = true;
                    break;
                }
                if ((idx = (opt = args[++i]).indexOf(61)) <= 0) {
                    stderr.println("bad syntax for option: " + opt);
                    error = true;
                    break;
                }
                options.put(opt.substring(0, idx), opt.substring(idx + 1));
                continue;
            }
            if ("-l".equals(argName)) {
                if (i + 1 >= numArgs) {
                    stderr.println("option requires an argument: " + argName);
                    error = true;
                    break;
                }
                if (login != null) {
                    stderr.println(argName + " option value re-specified: " + port);
                    error = true;
                    break;
                }
                login = args[++i];
                continue;
            }
            if (argName.charAt(0) == '-') continue;
            host = argName;
            if (login != null || (pos = host.indexOf(64)) <= 0) continue;
            login = host.substring(0, pos);
            host = host.substring(pos + 1);
        }
        if (!error && GenericUtils.isEmpty(host)) {
            stderr.println("Hostname not specified");
            error = true;
        }
        if (login == null) {
            login = System.getProperty("user.name");
        }
        if (port <= 0) {
            port = 22;
        }
        if (error) {
            return null;
        }
        SshClient client = SshClient.setUpDefaultClient();
        try {
            if (SecurityUtils.isBouncyCastleRegistered()) {
                try {
                    if (GenericUtils.isEmpty(identities)) {
                        ClientIdentity.setKeyPairProvider(client, false, true, new FilePasswordProvider(){

                            @Override
                            public String getPassword(String file) throws IOException {
                                stdout.print("Enter password for private key file=" + file + ": ");
                                return stdin.readLine();
                            }
                        }, new LinkOption[0]);
                    } else {
                        AbstractFileKeyPairProvider provider = SecurityUtils.createFileKeyPairProvider();
                        provider.setFiles(identities);
                        client.setKeyPairProvider(provider);
                    }
                }
                catch (Throwable t) {
                    stderr.println("Error loading user keys: " + t.getMessage());
                }
            }
            Map<String, Object> props = client.getProperties();
            props.putAll(options);
            client.start();
            client.setUserInteraction(new UserInteraction(){

                @Override
                public void welcome(String banner) {
                    stdout.println(banner);
                }

                @Override
                public String[] interactive(String destination, String name, String instruction, String lang, String[] prompt, boolean[] echo) {
                    int numPropmts = GenericUtils.length(prompt);
                    String[] answers = new String[numPropmts];
                    try {
                        for (int i = 0; i < numPropmts; ++i) {
                            stdout.print(prompt[i] + " ");
                            answers[i] = stdin.readLine();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return answers;
                }
            });
            ClientSession session = ((ConnectFuture)client.connect(login, host, port).await()).getSession();
            try {
                session.auth().verify();
                return session;
            }
            catch (Exception e) {
                session.close(true);
                throw e;
            }
        }
        catch (Exception e) {
            client.close();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        block60: {
            ConsoleHandler fh = new ConsoleHandler();
            fh.setLevel(Level.FINEST);
            fh.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    String message = this.formatMessage(record);
                    String throwable = "";
                    if (record.getThrown() != null) {
                        StringWriter sw = new StringWriter();
                        try (PrintWriter pw = new PrintWriter(sw);){
                            pw.println();
                            record.getThrown().printStackTrace(pw);
                        }
                        throwable = sw.toString();
                    }
                    return String.format("%1$tY-%1$tm-%1$td: %2$-7.7s: %3$-32.32s: %4$s%5$s%n", new Date(record.getMillis()), record.getLevel().getName(), record.getLoggerName(), message, throwable);
                }
            });
            Logger root = Logger.getLogger("");
            for (Handler handler : root.getHandlers()) {
                root.removeHandler(handler);
            }
            root.addHandler(fh);
            PrintStream stdout = System.out;
            PrintStream stderr = System.err;
            boolean agentForward = false;
            ArrayList<String> command = null;
            int logLevel = 0;
            int socksPort = -1;
            int numArgs = GenericUtils.length(args);
            boolean error = false;
            String target = null;
            for (int i = 0; i < numArgs; ++i) {
                String argName = args[i];
                if (command == null && "-D".equals(argName)) {
                    if (i + 1 >= numArgs) {
                        System.err.println("option requires an argument: " + argName);
                        error = true;
                        break;
                    }
                    if (socksPort > 0) {
                        stderr.println(argName + " option value re-specified: " + socksPort);
                        error = true;
                        break;
                    }
                    if ((socksPort = Integer.parseInt(args[++i])) > 0) continue;
                    stderr.println("Bad option value for " + argName + ": " + socksPort);
                    error = true;
                    break;
                }
                if (command == null && "-v".equals(argName)) {
                    ++logLevel;
                    continue;
                }
                if (command == null && "-vv".equals(argName)) {
                    logLevel += 2;
                    continue;
                }
                if (command == null && "-vvv".equals(argName)) {
                    logLevel += 3;
                    continue;
                }
                if (command == null && "-A".equals(argName)) {
                    agentForward = true;
                    continue;
                }
                if (command == null && "-a".equals(argName)) {
                    agentForward = false;
                    continue;
                }
                if (command == null && target == null) {
                    target = argName;
                    continue;
                }
                if (command == null) {
                    command = new ArrayList<String>();
                }
                command.add(argName);
            }
            if (logLevel <= 0) {
                root.setLevel(Level.WARNING);
            } else if (logLevel == 1) {
                root.setLevel(Level.INFO);
            } else if (logLevel == 2) {
                root.setLevel(Level.FINE);
            } else {
                root.setLevel(Level.FINEST);
            }
            ClientSession session = null;
            try (BufferedReader stdin = new BufferedReader(new InputStreamReader(new NoCloseInputStream(System.in)));){
                if (!error && (session = SshClient.setupClientSession("-p", stdin, stdout, stderr, args)) == null) {
                    error = true;
                }
                if (error) {
                    System.err.println("usage: ssh [-A|-a] [-v[v][v]] [-D socksPort] [-l login] [-p port] [-o option=value] hostname/user@host [command]");
                    System.exit(-1);
                    return;
                }
                try (SshClient client = (SshClient)session.getFactoryManager();){
                    try {
                        ClientChannel channel;
                        if (socksPort >= 0) {
                            session.startDynamicPortForwarding(new SshdSocketAddress("localhost", socksPort));
                            Thread.sleep(Long.MAX_VALUE);
                            break block60;
                        }
                        if (command == null) {
                            channel = session.createChannel("shell");
                            ((ChannelShell)channel).setAgentForwarding(agentForward);
                            channel.setIn(new NoCloseInputStream(System.in));
                        } else {
                            StringWriter w = new StringWriter();
                            for (String cmd : command) {
                                w.append(cmd).append(" ");
                            }
                            w.close();
                            channel = session.createChannel("exec", w.toString());
                        }
                        try {
                            channel.setOut(new NoCloseOutputStream(System.out));
                            channel.setErr(new NoCloseOutputStream(System.err));
                            channel.open().await();
                            channel.waitFor(2, 0L);
                        }
                        finally {
                            channel.close();
                        }
                        session.close(false);
                    }
                    finally {
                        client.stop();
                    }
                }
                finally {
                    session.close();
                }
            }
        }
    }
}

