/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.signature;

import org.apache.sshd.common.signature.AbstractSignature;
import org.apache.sshd.common.util.Pair;
import org.apache.sshd.common.util.ValidateUtils;

public class SignatureRSA
extends AbstractSignature {
    public SignatureRSA() {
        super("SHA1withRSA");
    }

    @Override
    public byte[] sign() throws Exception {
        return this.signature.sign();
    }

    @Override
    public boolean verify(byte[] sig) throws Exception {
        byte[] data = sig;
        Pair<String, byte[]> encoding = this.extractEncodedSignature(data);
        if (encoding != null) {
            String keyType = encoding.getFirst();
            ValidateUtils.checkTrue("ssh-rsa".equals(keyType), "Mismatched key type: %s", (Object)keyType);
            data = encoding.getSecond();
        }
        return this.signature.verify(data);
    }
}

