/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.listener;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.ftpserver.DataConnectionConfiguration;
import org.apache.ftpserver.DataConnectionConfigurationFactory;
import org.apache.ftpserver.FtpServerConfigurationException;
import org.apache.ftpserver.ipfilter.IpFilter;
import org.apache.ftpserver.listener.Listener;
import org.apache.ftpserver.listener.nio.NioListener;
import org.apache.ftpserver.ssl.SslConfiguration;
import org.apache.mina.filter.firewall.Subnet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerFactory {
    private String serverAddress;
    private int port = 21;
    private SslConfiguration ssl;
    private boolean implicitSsl = false;
    private DataConnectionConfiguration dataConnectionConfig = new DataConnectionConfigurationFactory().createDataConnectionConfiguration();
    private int idleTimeout = 300;
    private List<InetAddress> blockedAddresses;
    private List<Subnet> blockedSubnets;
    private IpFilter ipFilter = null;

    public ListenerFactory() {
    }

    public ListenerFactory(Listener listener) {
        this.serverAddress = listener.getServerAddress();
        this.port = listener.getPort();
        this.ssl = listener.getSslConfiguration();
        this.implicitSsl = listener.isImplicitSsl();
        this.dataConnectionConfig = listener.getDataConnectionConfiguration();
        this.idleTimeout = listener.getIdleTimeout();
        this.blockedAddresses = listener.getBlockedAddresses();
        this.blockedSubnets = listener.getBlockedSubnets();
        this.ipFilter = listener.getIpFilter();
    }

    public Listener createListener() {
        try {
            InetAddress.getByName(this.serverAddress);
        }
        catch (UnknownHostException e) {
            throw new FtpServerConfigurationException("Unknown host", e);
        }
        if (this.ipFilter != null && (this.blockedAddresses != null || this.blockedSubnets != null)) {
            throw new IllegalStateException("Usage of IPFilter in combination with blockedAddesses/subnets is not supported. ");
        }
        if (this.blockedAddresses != null || this.blockedSubnets != null) {
            return new NioListener(this.serverAddress, this.port, this.implicitSsl, this.ssl, this.dataConnectionConfig, this.idleTimeout, this.blockedAddresses, this.blockedSubnets);
        }
        return new NioListener(this.serverAddress, this.port, this.implicitSsl, this.ssl, this.dataConnectionConfig, this.idleTimeout, this.ipFilter);
    }

    public boolean isImplicitSsl() {
        return this.implicitSsl;
    }

    public void setImplicitSsl(boolean implicitSsl) {
        this.implicitSsl = implicitSsl;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public SslConfiguration getSslConfiguration() {
        return this.ssl;
    }

    public void setSslConfiguration(SslConfiguration ssl) {
        this.ssl = ssl;
    }

    public DataConnectionConfiguration getDataConnectionConfiguration() {
        return this.dataConnectionConfig;
    }

    public void setDataConnectionConfiguration(DataConnectionConfiguration dataConnectionConfig) {
        this.dataConnectionConfig = dataConnectionConfig;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    @Deprecated
    public List<InetAddress> getBlockedAddresses() {
        return this.blockedAddresses;
    }

    @Deprecated
    public void setBlockedAddresses(List<InetAddress> blockedAddresses) {
        this.blockedAddresses = blockedAddresses;
    }

    @Deprecated
    public List<Subnet> getBlockedSubnets() {
        return this.blockedSubnets;
    }

    @Deprecated
    public void setBlockedSubnets(List<Subnet> blockedSubnets) {
        this.blockedSubnets = blockedSubnets;
    }

    public IpFilter getIpFilter() {
        return this.ipFilter;
    }

    public void setIpFilter(IpFilter ipFilter) {
        this.ipFilter = ipFilter;
    }
}

