/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.AbstractChannel;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelAsyncInputStream;
import org.apache.sshd.common.channel.ChannelAsyncOutputStream;
import org.apache.sshd.common.channel.ChannelRequestHandler;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.io.IoInputStream;
import org.apache.sshd.common.io.IoOutputStream;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.io.IoUtils;

public abstract class AbstractClientChannel
extends AbstractChannel
implements ClientChannel {
    protected final AtomicBoolean opened = new AtomicBoolean();
    protected final String type;
    protected ClientChannel.Streaming streaming;
    protected ChannelAsyncOutputStream asyncIn;
    protected ChannelAsyncInputStream asyncOut;
    protected ChannelAsyncInputStream asyncErr;
    protected InputStream in;
    protected OutputStream invertedIn;
    protected OutputStream out;
    protected InputStream invertedOut;
    protected OutputStream err;
    protected InputStream invertedErr;
    protected Integer exitStatus;
    protected String exitSignal;
    protected int openFailureReason;
    protected String openFailureMsg;
    protected OpenFuture openFuture;

    protected AbstractClientChannel(String type) {
        this.type = type;
        this.streaming = ClientChannel.Streaming.Sync;
        this.addRequestHandler(new ExitStatusChannelRequestHandler());
        this.addRequestHandler(new ExitSignalChannelRequestHandler());
    }

    @Override
    public ClientChannel.Streaming getStreaming() {
        return this.streaming;
    }

    @Override
    public void setStreaming(ClientChannel.Streaming streaming) {
        this.streaming = streaming;
    }

    @Override
    public IoOutputStream getAsyncIn() {
        return this.asyncIn;
    }

    @Override
    public IoInputStream getAsyncOut() {
        return this.asyncOut;
    }

    @Override
    public IoInputStream getAsyncErr() {
        return this.asyncErr;
    }

    @Override
    public OutputStream getInvertedIn() {
        return this.invertedIn;
    }

    public InputStream getIn() {
        return this.in;
    }

    @Override
    public void setIn(InputStream in) {
        this.in = in;
    }

    @Override
    public InputStream getInvertedOut() {
        return this.invertedOut;
    }

    public OutputStream getOut() {
        return this.out;
    }

    @Override
    public void setOut(OutputStream out) {
        this.out = out;
    }

    @Override
    public InputStream getInvertedErr() {
        return this.invertedErr;
    }

    public OutputStream getErr() {
        return this.err;
    }

    @Override
    public void setErr(OutputStream err) {
        this.err = err;
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().when(this.openFuture).run(new Runnable(){

            @Override
            public void run() {
                if (AbstractClientChannel.this.openFuture == null) {
                    AbstractClientChannel.this.gracefulFuture.setClosed();
                }
                IoUtils.closeQuietly(AbstractClientChannel.this.in, AbstractClientChannel.this.out, AbstractClientChannel.this.err);
                IoUtils.closeQuietly(AbstractClientChannel.this.invertedIn, AbstractClientChannel.this.invertedOut, AbstractClientChannel.this.invertedErr);
            }
        }).parallel(this.asyncIn, this.asyncOut, this.asyncErr).close(new AbstractChannel.GracefulChannelCloseable(this)).build();
    }

    @Override
    public int waitFor(int mask, long timeout) {
        long t = 0L;
        Object object = this.lock;
        synchronized (object) {
            block5: while (true) {
                while (true) {
                    int cond = 0;
                    if (this.openFuture != null && this.openFuture.isOpened()) {
                        cond |= 0x80;
                    }
                    if (this.closeFuture.isClosed()) {
                        cond |= 0x12;
                    }
                    if (this.isEofSignalled()) {
                        cond |= 0x10;
                    }
                    if (this.exitStatus != null) {
                        cond |= 0x20;
                    }
                    if (this.exitSignal != null) {
                        cond |= 0x40;
                    }
                    if ((cond & mask) != 0) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("WaitFor call returning on channel {}, mask={}, cond={}", new Object[]{this, mask, cond});
                        }
                        return cond;
                    }
                    if (timeout > 0L) {
                        if (t == 0L) {
                            t = System.currentTimeMillis() + timeout;
                        } else {
                            timeout = t - System.currentTimeMillis();
                            if (timeout <= 0L) {
                                return cond |= 1;
                            }
                        }
                    }
                    try {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("Waiting for lock on channel {}, mask={}, cond={}", new Object[]{this, mask, cond});
                        }
                        if (timeout > 0L) {
                            this.lock.wait(timeout);
                        } else {
                            this.lock.wait();
                        }
                        this.log.trace("Lock notified on channel {}", (Object)this);
                        continue block5;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    @Override
    public synchronized OpenFuture open() throws IOException {
        if (this.isClosing()) {
            throw new SshException("Session has been closed");
        }
        this.openFuture = new DefaultOpenFuture(this.lock);
        this.log.debug("Send SSH_MSG_CHANNEL_OPEN on channel {}", (Object)this);
        Buffer buffer = this.session.createBuffer((byte)90);
        buffer.putString(this.type);
        buffer.putInt(this.id);
        buffer.putInt(this.localWindow.getSize());
        buffer.putInt(this.localWindow.getPacketSize());
        this.writePacket(buffer);
        return this.openFuture;
    }

    @Override
    public OpenFuture open(int recipient, int rwSize, int packetSize, Buffer buffer) {
        throw new UnsupportedOperationException("open(" + recipient + "," + rwSize + "," + packetSize + ") N/A");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleOpenSuccess(int recipient, int rwSize, int packetSize, Buffer buffer) {
        this.recipient = recipient;
        this.remoteWindow.init(rwSize, packetSize, this.session.getFactoryManager().getProperties());
        try {
            this.doOpen();
            this.opened.set(true);
            this.openFuture.setOpened();
        }
        catch (Exception e) {
            this.openFuture.setException(e);
            this.closeFuture.setClosed();
            this.doCloseImmediately();
        }
        finally {
            this.notifyStateChanged();
        }
    }

    protected abstract void doOpen() throws IOException;

    @Override
    public void handleOpenFailure(Buffer buffer) {
        int reason = buffer.getInt();
        String msg = buffer.getString();
        this.openFailureReason = reason;
        this.openFailureMsg = msg;
        this.openFuture.setException(new SshException(msg));
        this.closeFuture.setClosed();
        this.doCloseImmediately();
        this.notifyStateChanged();
    }

    @Override
    protected void doWriteData(byte[] data, int off, int len) throws IOException {
        if (this.isClosing()) {
            return;
        }
        if (this.asyncOut != null) {
            this.asyncOut.write(new ByteArrayBuffer(data, off, len));
        } else if (this.out != null) {
            this.out.write(data, off, len);
            this.out.flush();
            if (this.invertedOut == null) {
                this.localWindow.consumeAndCheck(len);
            }
        } else {
            throw new IllegalStateException("No output stream for channel");
        }
    }

    @Override
    protected void doWriteExtendedData(byte[] data, int off, int len) throws IOException {
        if (this.isClosing()) {
            return;
        }
        if (this.asyncErr != null) {
            this.asyncErr.write(new ByteArrayBuffer(data, off, len));
        } else if (this.err != null) {
            this.err.write(data, off, len);
            this.err.flush();
            if (this.invertedErr == null) {
                this.localWindow.consumeAndCheck(len);
            }
        } else {
            throw new IllegalStateException("No error stream for channel");
        }
    }

    @Override
    public void handleWindowAdjust(Buffer buffer) throws IOException {
        super.handleWindowAdjust(buffer);
        if (this.asyncIn != null) {
            this.asyncIn.onWindowExpanded();
        }
    }

    @Override
    public Integer getExitStatus() {
        return this.exitStatus;
    }

    private class ExitSignalChannelRequestHandler
    implements ChannelRequestHandler {
        @Override
        public RequestHandler.Result process(Channel channel, String request, boolean wantReply, Buffer buffer) throws Exception {
            if ("exit-signal".equals(request)) {
                AbstractClientChannel.this.exitSignal = buffer.getString();
                AbstractClientChannel.this.notifyStateChanged();
                return RequestHandler.Result.ReplySuccess;
            }
            return RequestHandler.Result.Unsupported;
        }
    }

    private class ExitStatusChannelRequestHandler
    implements ChannelRequestHandler {
        @Override
        public RequestHandler.Result process(Channel channel, String request, boolean wantReply, Buffer buffer) throws Exception {
            if ("exit-status".equals(request)) {
                AbstractClientChannel.this.exitStatus = buffer.getInt();
                AbstractClientChannel.this.notifyStateChanged();
                return RequestHandler.Result.ReplySuccess;
            }
            return RequestHandler.Result.Unsupported;
        }
    }
}

