/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex.dh;

import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.kex.KeyExchange;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public abstract class AbstractDHKeyExchange
extends AbstractLoggingBean
implements KeyExchange {
    protected AbstractSession session;
    protected byte[] v_s;
    protected byte[] v_c;
    protected byte[] i_s;
    protected byte[] i_c;
    protected Digest hash;
    protected byte[] e;
    protected byte[] f;
    protected byte[] k;
    protected byte[] h;

    protected AbstractDHKeyExchange() {
    }

    @Override
    public void init(AbstractSession s, byte[] v_s, byte[] v_c, byte[] i_s, byte[] i_c) throws Exception {
        this.session = ValidateUtils.checkNotNull(s, "No session");
        this.v_s = ValidateUtils.checkNotNullAndNotEmpty(v_s, "No v_s value", new Object[0]);
        this.v_c = ValidateUtils.checkNotNullAndNotEmpty(v_c, "No v_c value", new Object[0]);
        this.i_s = ValidateUtils.checkNotNullAndNotEmpty(i_s, "No i_s value", new Object[0]);
        this.i_c = ValidateUtils.checkNotNullAndNotEmpty(i_c, "No i_c value", new Object[0]);
    }

    public AbstractSession getSession() {
        return this.session;
    }

    @Override
    public Digest getHash() {
        return this.hash;
    }

    @Override
    public byte[] getH() {
        return this.h;
    }

    @Override
    public byte[] getK() {
        return this.k;
    }
}

