/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Int2IntFunction;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.io.IoUtils;

public final class BufferUtils {
    public static final char DEFAULT_HEX_SEPARATOR = ' ';
    public static final char EMPTY_HEX_SEPARATOR = '\u0000';
    public static final String HEX_DIGITS = "0123456789abcdef";
    public static final Int2IntFunction DEFAULT_BUFFER_GROWTH_FACTOR = new Int2IntFunction(){

        @Override
        public int apply(int value) {
            return BufferUtils.getNextPowerOf2(value);
        }
    };

    private BufferUtils() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static String printHex(byte ... array) {
        return BufferUtils.printHex(array, 0, GenericUtils.length(array));
    }

    public static String printHex(char sep, byte ... array) {
        return BufferUtils.printHex(array, 0, GenericUtils.length(array), sep);
    }

    public static String printHex(byte[] array, int offset, int len) {
        return BufferUtils.printHex(array, offset, len, ' ');
    }

    public static String printHex(byte[] array, int offset, int len, char sep) {
        if (len <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(len * 3);
        int maxOffset = offset + len;
        for (int curOffset = offset; curOffset < maxOffset; ++curOffset) {
            byte b = array[curOffset];
            if (sb.length() > 0 && sep != '\u0000') {
                sb.append(sep);
            }
            sb.append(HEX_DIGITS.charAt(b >> 4 & 0xF));
            sb.append(HEX_DIGITS.charAt(b & 0xF));
        }
        return sb.toString();
    }

    public static int readInt(InputStream input, byte[] buf) throws IOException {
        return BufferUtils.readInt(input, buf, 0, GenericUtils.length(buf));
    }

    public static int readInt(InputStream input, byte[] buf, int offset, int len) throws IOException {
        return (int)BufferUtils.readUInt(input, buf, offset, len);
    }

    public static long readUInt(InputStream input, byte[] buf) throws IOException {
        return BufferUtils.readUInt(input, buf, 0, GenericUtils.length(buf));
    }

    public static long readUInt(InputStream input, byte[] buf, int offset, int len) throws IOException {
        try {
            if (len < 4) {
                throw new IllegalArgumentException("Not enough data for a UINT: required=4, available=" + len);
            }
            IoUtils.readFully(input, buf, offset, 4);
            return BufferUtils.getUInt(buf, offset, len);
        }
        catch (IllegalArgumentException e) {
            throw new StreamCorruptedException(e.getMessage());
        }
    }

    public static long getUInt(byte ... buf) {
        return BufferUtils.getUInt(buf, 0, GenericUtils.length(buf));
    }

    public static long getUInt(byte[] buf, int off, int len) {
        if (len < 4) {
            throw new IllegalArgumentException("Not enough data for a UINT: required=4, available=" + len);
        }
        long l = (long)(buf[off] << 24) & 0xFF000000L;
        l |= (long)(buf[off + 1] << 16) & 0xFF0000L;
        l |= (long)(buf[off + 2] << 8) & 0xFF00L;
        return l |= (long)buf[off + 3] & 0xFFL;
    }

    public static void writeInt(OutputStream output, int value, byte[] buf) throws IOException {
        BufferUtils.writeUInt(output, value, buf, 0, GenericUtils.length(buf));
    }

    public static void writeInt(OutputStream output, int value, byte[] buf, int off, int len) throws IOException {
        BufferUtils.writeUInt(output, (long)value & 0xFFFFFFFFL, buf, off, len);
    }

    public static void writeUInt(OutputStream output, long value, byte[] buf) throws IOException {
        BufferUtils.writeUInt(output, value, buf, 0, GenericUtils.length(buf));
    }

    public static void writeUInt(OutputStream output, long value, byte[] buf, int off, int len) throws IOException {
        try {
            int writeLen = BufferUtils.putUInt(value, buf, off, len);
            output.write(buf, off, writeLen);
        }
        catch (IllegalArgumentException e) {
            throw new StreamCorruptedException(e.getMessage());
        }
    }

    public static int putUInt(long value, byte[] buf) {
        return BufferUtils.putUInt(value, buf, 0, GenericUtils.length(buf));
    }

    public static int putUInt(long value, byte[] buf, int off, int len) {
        if (len < 4) {
            throw new IllegalArgumentException("Not enough data for a UINT: required=4, available=" + len);
        }
        buf[off] = (byte)(value >> 24 & 0xFFL);
        buf[off + 1] = (byte)(value >> 16 & 0xFFL);
        buf[off + 2] = (byte)(value >> 8 & 0xFFL);
        buf[off + 3] = (byte)(value & 0xFFL);
        return 4;
    }

    public static boolean equals(byte[] a1, byte[] a2) {
        int len2;
        int len1 = GenericUtils.length(a1);
        if (len1 != (len2 = GenericUtils.length(a2))) {
            return false;
        }
        return BufferUtils.equals(a1, 0, a2, 0, len1);
    }

    public static boolean equals(byte[] a1, int a1Offset, byte[] a2, int a2Offset, int length) {
        int len1 = GenericUtils.length(a1);
        int len2 = GenericUtils.length(a2);
        if (len1 < a1Offset + length || len2 < a2Offset + length) {
            return false;
        }
        while (length-- > 0) {
            if (a1[a1Offset++] == a2[a2Offset++]) continue;
            return false;
        }
        return true;
    }

    public static int getNextPowerOf2(int i) {
        int j;
        for (j = 1; j < i; j <<= 1) {
        }
        return j;
    }

    public static int updateLengthPlaceholder(Buffer buffer, int lenPos) {
        int startPos = lenPos + 4;
        int endPos = buffer.wpos();
        int dataLength = endPos - startPos;
        buffer.wpos(lenPos);
        buffer.putInt(dataLength);
        buffer.wpos(endPos);
        return dataLength;
    }

    public static void updateLengthPlaceholder(Buffer buffer, int lenPos, int dataLength) {
        int curPos = buffer.wpos();
        buffer.wpos(lenPos);
        buffer.putInt(dataLength);
        buffer.wpos(curPos);
    }

    public static <B extends Buffer> B clear(B buffer) {
        if (buffer != null) {
            buffer.clear();
        }
        return buffer;
    }
}

