/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.subsystem.sftp;

import java.io.IOException;
import java.util.Collection;
import org.apache.sshd.client.subsystem.sftp.SftpClient;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.InputStreamWithChannel;

public class SftpInputStreamWithChannel
extends InputStreamWithChannel {
    private final SftpClient client;
    private final String path;
    private byte[] bb;
    private byte[] buffer;
    private int index;
    private int available;
    private SftpClient.CloseableHandle handle;
    private long offset;

    public SftpInputStreamWithChannel(SftpClient client, int bufferSize, String path, Collection<SftpClient.OpenMode> mode) throws IOException {
        this.client = ValidateUtils.checkNotNull(client, "No SFTP client instance");
        this.path = path;
        this.bb = new byte[1];
        this.buffer = new byte[bufferSize];
        this.handle = client.open(path, mode);
    }

    public final SftpClient getClient() {
        return this.client;
    }

    public final String getPath() {
        return this.path;
    }

    @Override
    public boolean isOpen() {
        return this.handle != null && this.handle.isOpen();
    }

    @Override
    public int read() throws IOException {
        int read = this.read(this.bb, 0, 1);
        if (read > 0) {
            return this.bb[0];
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("read(" + this.getPath() + ") stream closed");
        }
        int idx = off;
        while (len > 0) {
            if (this.index >= this.available) {
                this.available = this.client.read(this.handle, this.offset, this.buffer, 0, this.buffer.length);
                if (this.available < 0) {
                    if (idx != off) break;
                    return -1;
                }
                this.offset += (long)this.available;
                this.index = 0;
            }
            if (this.index >= this.available) break;
            int nb = Math.min(len, this.available - this.index);
            System.arraycopy(this.buffer, this.index, b, idx, nb);
            this.index += nb;
            idx += nb;
            len -= nb;
        }
        return idx - off;
    }

    @Override
    public void close() throws IOException {
        if (this.isOpen()) {
            try {
                this.handle.close();
            }
            finally {
                this.handle = null;
            }
        }
    }
}

