/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.config.keys;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collection;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.server.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.server.config.keys.AuthorizedKeysAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class DefaultAuthorizedKeysAuthenticator
extends AuthorizedKeysAuthenticator {
    public static final DefaultAuthorizedKeysAuthenticator INSTANCE = new DefaultAuthorizedKeysAuthenticator(true);
    private final boolean strict;
    private final String user;

    public DefaultAuthorizedKeysAuthenticator(boolean strict) {
        this(System.getProperty("user.name"), strict);
    }

    public DefaultAuthorizedKeysAuthenticator(String user, boolean strict) {
        this(user, AuthorizedKeyEntry.getDefaultAuthorizedKeysFile(), strict);
    }

    public DefaultAuthorizedKeysAuthenticator(File file, boolean strict) {
        this(ValidateUtils.checkNotNull(file, "No file provided").toPath(), strict, IoUtils.getLinkOptions(false));
    }

    public DefaultAuthorizedKeysAuthenticator(String user, File file, boolean strict) {
        this(user, ValidateUtils.checkNotNull(file, "No file provided").toPath(), strict, IoUtils.getLinkOptions(false));
    }

    public DefaultAuthorizedKeysAuthenticator(Path path, boolean strict, LinkOption ... options) {
        this(System.getProperty("user.name"), path, strict, options);
    }

    public DefaultAuthorizedKeysAuthenticator(String user, Path path, boolean strict, LinkOption ... options) {
        super(path, options);
        this.user = ValidateUtils.checkNotNullAndNotEmpty(user, "No username provided");
        this.strict = strict;
    }

    public final String getUsername() {
        return this.user;
    }

    public final boolean isStrict() {
        return this.strict;
    }

    @Override
    protected boolean isValidUsername(String username, ServerSession session) {
        if (!super.isValidUsername(username, session)) {
            return false;
        }
        String expected = this.getUsername();
        return username.equals(expected);
    }

    @Override
    protected Collection<AuthorizedKeyEntry> reloadAuthorizedKeys(Path path, String username, ServerSession session) throws IOException {
        if (this.isStrict()) {
            if (this.log.isDebugEnabled()) {
                this.log.info("reloadAuthorizedKeys(" + username + ")[" + session + "] check permissions of " + path);
            }
            KeyUtils.validateStrictKeyFilePermissions(path, new LinkOption[0]);
        }
        return super.reloadAuthorizedKeys(path, username, session);
    }

    protected Path validateFilePath(Path path, Collection<PosixFilePermission> perms, Collection<PosixFilePermission> excluded) throws IOException {
        PosixFilePermission p = IoUtils.validateExcludedPermissions(perms, excluded);
        if (p != null) {
            String filePath = path.toString();
            throw new FileSystemException(filePath, filePath, "File not allowed to have " + (Object)((Object)p) + " permission: " + filePath);
        }
        return path;
    }
}

