/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.subsystem.sftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.client.subsystem.sftp.DefaultCloseableHandle;
import org.apache.sshd.client.subsystem.sftp.RawSftpClient;
import org.apache.sshd.client.subsystem.sftp.SftpClient;
import org.apache.sshd.client.subsystem.sftp.SftpException;
import org.apache.sshd.client.subsystem.sftp.SftpInputStreamWithChannel;
import org.apache.sshd.client.subsystem.sftp.SftpIterableDirEntry;
import org.apache.sshd.client.subsystem.sftp.SftpOutputStreamWithChannel;
import org.apache.sshd.client.subsystem.sftp.extensions.BuiltinSftpClientExtensions;
import org.apache.sshd.client.subsystem.sftp.extensions.SftpClientExtension;
import org.apache.sshd.client.subsystem.sftp.extensions.SftpClientExtensionFactory;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.subsystem.sftp.extensions.ParserUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public abstract class AbstractSftpClient
extends AbstractLoggingBean
implements SftpClient,
RawSftpClient {
    private final AtomicReference<Map<String, Object>> parsedExtensionsHolder = new AtomicReference<Object>(null);

    protected AbstractSftpClient() {
    }

    @Override
    public String getName() {
        return "sftp";
    }

    @Override
    public SftpClient.CloseableHandle open(String path) throws IOException {
        return this.open(path, Collections.emptySet());
    }

    @Override
    public SftpClient.CloseableHandle open(String path, SftpClient.OpenMode ... options) throws IOException {
        return this.open(path, GenericUtils.of((Enum[])options));
    }

    @Override
    public void rename(String oldPath, String newPath) throws IOException {
        this.rename(oldPath, newPath, Collections.emptySet());
    }

    @Override
    public void rename(String oldPath, String newPath, SftpClient.CopyMode ... options) throws IOException {
        this.rename(oldPath, newPath, GenericUtils.of((Enum[])options));
    }

    @Override
    public InputStream read(String path) throws IOException {
        return this.read(path, 32768);
    }

    @Override
    public InputStream read(String path, int bufferSize) throws IOException {
        return this.read(path, bufferSize, EnumSet.of(SftpClient.OpenMode.Read));
    }

    @Override
    public InputStream read(String path, SftpClient.OpenMode ... mode) throws IOException {
        return this.read(path, 32768, mode);
    }

    @Override
    public InputStream read(String path, int bufferSize, SftpClient.OpenMode ... mode) throws IOException {
        return this.read(path, bufferSize, GenericUtils.of((Enum[])mode));
    }

    @Override
    public InputStream read(String path, Collection<SftpClient.OpenMode> mode) throws IOException {
        return this.read(path, 32768, mode);
    }

    @Override
    public int read(SftpClient.Handle handle, long fileOffset, byte[] dst) throws IOException {
        return this.read(handle, fileOffset, dst, 0, dst.length);
    }

    @Override
    public OutputStream write(String path) throws IOException {
        return this.write(path, 32768);
    }

    @Override
    public OutputStream write(String path, int bufferSize) throws IOException {
        return this.write(path, bufferSize, EnumSet.of(SftpClient.OpenMode.Write, SftpClient.OpenMode.Create, SftpClient.OpenMode.Truncate));
    }

    @Override
    public OutputStream write(String path, SftpClient.OpenMode ... mode) throws IOException {
        return this.write(path, 32768, mode);
    }

    @Override
    public OutputStream write(String path, Collection<SftpClient.OpenMode> mode) throws IOException {
        return this.write(path, 32768, mode);
    }

    @Override
    public OutputStream write(String path, int bufferSize, SftpClient.OpenMode ... mode) throws IOException {
        return this.write(path, bufferSize, GenericUtils.of((Enum[])mode));
    }

    @Override
    public void write(SftpClient.Handle handle, long fileOffset, byte[] src) throws IOException {
        this.write(handle, fileOffset, src, 0, src.length);
    }

    @Override
    public void symLink(String linkPath, String targetPath) throws IOException {
        this.link(linkPath, targetPath, true);
    }

    @Override
    public <E extends SftpClientExtension> E getExtension(Class<? extends E> extensionType) {
        SftpClientExtension instance = this.getExtension(BuiltinSftpClientExtensions.fromType(extensionType));
        if (instance == null) {
            return null;
        }
        return (E)((SftpClientExtension)extensionType.cast(instance));
    }

    @Override
    public SftpClientExtension getExtension(String extensionName) {
        return this.getExtension(BuiltinSftpClientExtensions.fromName(extensionName));
    }

    protected SftpClientExtension getExtension(SftpClientExtensionFactory factory) {
        if (factory == null) {
            return null;
        }
        Map<String, byte[]> extensions = this.getServerExtensions();
        Map<String, Object> parsed = this.getParsedServerExtensions(extensions);
        return factory.create(this, this, extensions, parsed);
    }

    protected Map<String, Object> getParsedServerExtensions() {
        return this.getParsedServerExtensions(this.getServerExtensions());
    }

    protected Map<String, Object> getParsedServerExtensions(Map<String, byte[]> extensions) {
        Map<String, Object> parsed = this.parsedExtensionsHolder.get();
        if (parsed == null) {
            parsed = ParserUtils.parse(extensions);
            if (parsed == null) {
                parsed = Collections.emptyMap();
            }
            this.parsedExtensionsHolder.set(parsed);
        }
        return parsed;
    }

    protected void checkStatus(int cmd, Buffer request) throws IOException {
        int reqId = this.send(cmd, request);
        Buffer response = this.receive(reqId);
        this.checkStatus(response);
    }

    protected void checkStatus(Buffer buffer) throws IOException {
        int length = buffer.getInt();
        int type = buffer.getUByte();
        int id = buffer.getInt();
        if (type != 101) {
            throw new SshException("Unexpected SFTP packet received: type=" + type + ", id=" + id + ", length=" + length);
        }
        int substatus = buffer.getInt();
        String msg = buffer.getString();
        String lang = buffer.getString();
        this.checkStatus(id, substatus, msg, lang);
    }

    protected void checkStatus(int id, int substatus, String msg, String lang) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("checkStatus(id=" + id + ") status: " + substatus + " [" + lang + "]" + msg);
        }
        if (substatus != 0) {
            this.throwStatusException(id, substatus, msg, lang);
        }
    }

    protected void throwStatusException(int id, int substatus, String msg, String lang) throws IOException {
        throw new SftpException(substatus, msg);
    }

    protected byte[] checkHandle(int cmd, Buffer request) throws IOException {
        int reqId = this.send(cmd, request);
        Buffer response = this.receive(reqId);
        return this.checkHandle(response);
    }

    protected byte[] checkHandle(Buffer buffer) throws IOException {
        int length = buffer.getInt();
        int type = buffer.getUByte();
        int id = buffer.getInt();
        if (type == 102) {
            return ValidateUtils.checkNotNullAndNotEmpty(buffer.getBytes(), "Null/empty handle in buffer", GenericUtils.EMPTY_OBJECT_ARRAY);
        }
        if (type == 101) {
            int substatus = buffer.getInt();
            String msg = buffer.getString();
            String lang = buffer.getString();
            if (this.log.isTraceEnabled()) {
                this.log.trace("checkHandle(id={}) - status: {} [{}] {}", new Object[]{id, substatus, lang, msg});
            }
            this.throwStatusException(id, substatus, msg, lang);
        }
        throw new SshException("Unexpected SFTP packet received: type=" + type + ", id=" + id + ", length=" + length);
    }

    protected SftpClient.Attributes checkAttributes(int cmd, Buffer request) throws IOException {
        int reqId = this.send(cmd, request);
        Buffer response = this.receive(reqId);
        return this.checkAttributes(response);
    }

    protected SftpClient.Attributes checkAttributes(Buffer buffer) throws IOException {
        int length = buffer.getInt();
        int type = buffer.getUByte();
        int id = buffer.getInt();
        if (type == 105) {
            return this.readAttributes(buffer);
        }
        if (type == 101) {
            int substatus = buffer.getInt();
            String msg = buffer.getString();
            String lang = buffer.getString();
            if (this.log.isTraceEnabled()) {
                this.log.trace("checkAttributes(id={}) - status: {} [{}] {}", new Object[]{id, substatus, lang, msg});
            }
            this.throwStatusException(id, substatus, msg, lang);
        }
        throw new SshException("Unexpected SFTP packet received: type=" + type + ", id=" + id + ", length=" + length);
    }

    protected String checkOneName(int cmd, Buffer request) throws IOException {
        int reqId = this.send(cmd, request);
        Buffer response = this.receive(reqId);
        return this.checkOneName(response);
    }

    protected String checkOneName(Buffer buffer) throws IOException {
        int length = buffer.getInt();
        int type = buffer.getUByte();
        int id = buffer.getInt();
        if (type == 104) {
            int len = buffer.getInt();
            if (len != 1) {
                throw new SshException("SFTP error: received " + len + " names instead of 1");
            }
            String name = buffer.getString();
            String longName = null;
            int version = this.getVersion();
            if (version == 3) {
                longName = buffer.getString();
            }
            SftpClient.Attributes attrs = this.readAttributes(buffer);
            if (this.log.isTraceEnabled()) {
                this.log.trace("checkOneName(id={}) ({})[{}]: {}", new Object[]{id, name, longName, attrs});
            }
            return name;
        }
        if (type == 101) {
            int substatus = buffer.getInt();
            String msg = buffer.getString();
            String lang = buffer.getString();
            if (this.log.isTraceEnabled()) {
                this.log.trace("checkOneName(id={}) - status: {} [{}] {}", new Object[]{id, substatus, lang, msg});
            }
            this.throwStatusException(id, substatus, msg, lang);
        }
        throw new SshException("Unexpected SFTP packet received: type=" + type + ", id=" + id + ", length=" + length);
    }

    protected SftpClient.Attributes readAttributes(Buffer buffer) throws IOException {
        SftpClient.Attributes attrs = new SftpClient.Attributes();
        int flags = buffer.getInt();
        int version = this.getVersion();
        if (version == 3) {
            if ((flags & 1) != 0) {
                attrs.flags.add(SftpClient.Attribute.Size);
                attrs.size = buffer.getLong();
            }
            if ((flags & 2) != 0) {
                attrs.flags.add(SftpClient.Attribute.UidGid);
                attrs.uid = buffer.getInt();
                attrs.gid = buffer.getInt();
            }
            if ((flags & 4) != 0) {
                attrs.flags.add(SftpClient.Attribute.Perms);
                attrs.perms = buffer.getInt();
            }
            if ((flags & 8) != 0) {
                attrs.flags.add(SftpClient.Attribute.AcModTime);
                attrs.atime = buffer.getInt();
                attrs.mtime = buffer.getInt();
            }
        } else if (version >= 4) {
            attrs.type = buffer.getUByte();
            if ((flags & 1) != 0) {
                attrs.flags.add(SftpClient.Attribute.Size);
                attrs.size = buffer.getLong();
            }
            if ((flags & 0x80) != 0) {
                attrs.flags.add(SftpClient.Attribute.OwnerGroup);
                attrs.owner = buffer.getString();
                attrs.group = buffer.getString();
            }
            if ((flags & 4) != 0) {
                attrs.flags.add(SftpClient.Attribute.Perms);
                attrs.perms = buffer.getInt();
            }
            switch (attrs.type) {
                case 1: {
                    attrs.perms |= 0x8000;
                    break;
                }
                case 2: {
                    attrs.perms |= 0x4000;
                    break;
                }
                case 3: {
                    attrs.perms |= 0xA000;
                    break;
                }
            }
            if ((flags & 8) != 0) {
                attrs.flags.add(SftpClient.Attribute.AccessTime);
                attrs.accessTime = this.readTime(buffer, flags);
                attrs.atime = (int)attrs.accessTime.to(TimeUnit.SECONDS);
            }
            if ((flags & 0x10) != 0) {
                attrs.flags.add(SftpClient.Attribute.CreateTime);
                attrs.createTime = this.readTime(buffer, flags);
                attrs.ctime = (int)attrs.createTime.to(TimeUnit.SECONDS);
            }
            if ((flags & 0x20) != 0) {
                attrs.flags.add(SftpClient.Attribute.ModifyTime);
                attrs.modifyTime = this.readTime(buffer, flags);
                attrs.mtime = (int)attrs.modifyTime.to(TimeUnit.SECONDS);
            }
        } else {
            throw new IllegalStateException("readAttributes - unsupported version: " + version);
        }
        return attrs;
    }

    protected FileTime readTime(Buffer buffer, int flags) {
        long secs = buffer.getLong();
        long millis = secs * 1000L;
        if ((flags & 0x100) != 0) {
            millis += (long)buffer.getInt() / 1000000L;
        }
        return FileTime.from(millis, TimeUnit.MILLISECONDS);
    }

    protected void writeAttributes(Buffer buffer, SftpClient.Attributes attributes) throws IOException {
        int version = this.getVersion();
        if (version == 3) {
            int flags = 0;
            for (SftpClient.Attribute a : attributes.flags) {
                switch (a) {
                    case Size: {
                        flags |= 1;
                        break;
                    }
                    case UidGid: {
                        flags |= 2;
                        break;
                    }
                    case Perms: {
                        flags |= 4;
                        break;
                    }
                    case AcModTime: {
                        flags |= 8;
                        break;
                    }
                }
            }
            buffer.putInt(flags);
            if ((flags & 1) != 0) {
                buffer.putLong(attributes.size);
            }
            if ((flags & 2) != 0) {
                buffer.putInt(attributes.uid);
                buffer.putInt(attributes.gid);
            }
            if ((flags & 4) != 0) {
                buffer.putInt(attributes.perms);
            }
            if ((flags & 8) != 0) {
                buffer.putInt(attributes.atime);
                buffer.putInt(attributes.mtime);
            }
        } else if (version >= 4) {
            int flags = 0;
            for (SftpClient.Attribute a : attributes.flags) {
                switch (a) {
                    case Size: {
                        flags |= 1;
                        break;
                    }
                    case OwnerGroup: {
                        flags |= 0x80;
                        break;
                    }
                    case Perms: {
                        flags |= 4;
                        break;
                    }
                    case AccessTime: {
                        flags |= 8;
                        break;
                    }
                    case ModifyTime: {
                        flags |= 0x20;
                        break;
                    }
                    case CreateTime: {
                        flags |= 0x10;
                        break;
                    }
                }
            }
            buffer.putInt(flags);
            buffer.putByte((byte)attributes.type);
            if ((flags & 1) != 0) {
                buffer.putLong(attributes.size);
            }
            if ((flags & 0x80) != 0) {
                buffer.putString(attributes.owner != null ? attributes.owner : "OWNER@");
                buffer.putString(attributes.group != null ? attributes.group : "GROUP@");
            }
            if ((flags & 4) != 0) {
                buffer.putInt(attributes.perms);
            }
            if ((flags & 8) != 0) {
                buffer.putLong(attributes.accessTime.to(TimeUnit.SECONDS));
                if ((flags & 0x100) != 0) {
                    long nanos = attributes.accessTime.to(TimeUnit.NANOSECONDS);
                    buffer.putInt((int)(nanos %= TimeUnit.SECONDS.toNanos(1L)));
                }
                buffer.putInt(attributes.atime);
            }
            if ((flags & 0x10) != 0) {
                buffer.putLong(attributes.createTime.to(TimeUnit.SECONDS));
                if ((flags & 0x100) != 0) {
                    long nanos = attributes.createTime.to(TimeUnit.NANOSECONDS);
                    buffer.putInt((int)(nanos %= TimeUnit.SECONDS.toNanos(1L)));
                }
                buffer.putInt(attributes.atime);
            }
            if ((flags & 0x20) != 0) {
                buffer.putLong(attributes.modifyTime.to(TimeUnit.SECONDS));
                if ((flags & 0x100) != 0) {
                    long nanos = attributes.modifyTime.to(TimeUnit.NANOSECONDS);
                    buffer.putInt((int)(nanos %= TimeUnit.SECONDS.toNanos(1L)));
                }
                buffer.putInt(attributes.atime);
            }
        } else {
            throw new UnsupportedOperationException("writeAttributes(" + attributes + ") unsupported version: " + version);
        }
    }

    @Override
    public SftpClient.CloseableHandle open(String path, Collection<SftpClient.OpenMode> options) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("open(" + path + ")[" + options + "] client is closed");
        }
        if (GenericUtils.isEmpty(options)) {
            options = EnumSet.of(SftpClient.OpenMode.Read);
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64);
        buffer.putString(path);
        int version = this.getVersion();
        int mode = 0;
        if (version == 3) {
            for (SftpClient.OpenMode m : options) {
                switch (m) {
                    case Read: {
                        mode |= 1;
                        break;
                    }
                    case Write: {
                        mode |= 2;
                        break;
                    }
                    case Append: {
                        mode |= 4;
                        break;
                    }
                    case Create: {
                        mode |= 8;
                        break;
                    }
                    case Truncate: {
                        mode |= 0x10;
                        break;
                    }
                    case Exclusive: {
                        mode |= 0x20;
                        break;
                    }
                }
            }
        } else {
            if (version >= 5) {
                int access = 0;
                if (options.contains((Object)SftpClient.OpenMode.Read)) {
                    access |= 0x81;
                }
                if (options.contains((Object)SftpClient.OpenMode.Write)) {
                    access |= 0x102;
                }
                if (options.contains((Object)SftpClient.OpenMode.Append)) {
                    access |= 4;
                }
                buffer.putInt(access);
            }
            mode = options.contains((Object)SftpClient.OpenMode.Create) && options.contains((Object)SftpClient.OpenMode.Exclusive) ? (mode |= 0) : (options.contains((Object)SftpClient.OpenMode.Create) && options.contains((Object)SftpClient.OpenMode.Truncate) ? (mode |= 1) : (options.contains((Object)SftpClient.OpenMode.Create) ? (mode |= 3) : (options.contains((Object)SftpClient.OpenMode.Truncate) ? (mode |= 4) : (mode |= 2))));
        }
        buffer.putInt(mode);
        this.writeAttributes(buffer, new SftpClient.Attributes());
        return new DefaultCloseableHandle(this, this.checkHandle(3, buffer));
    }

    @Override
    public void close(SftpClient.Handle handle) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("close(" + handle + ") client is closed");
        }
        byte[] id = handle.getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 64);
        buffer.putBytes(id);
        this.checkStatus(4, buffer);
    }

    @Override
    public void remove(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("remove(" + path + ") client is closed");
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64);
        buffer.putString(path);
        this.checkStatus(13, buffer);
    }

    @Override
    public void rename(String oldPath, String newPath, Collection<SftpClient.CopyMode> options) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("rename(" + oldPath + " => " + newPath + ")[" + options + "] client is closed");
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(oldPath.length() + newPath.length() + 64);
        buffer.putString(oldPath);
        buffer.putString(newPath);
        int numOptions = GenericUtils.size(options);
        int version = this.getVersion();
        if (version >= 5) {
            int opts = 0;
            if (numOptions > 0) {
                for (SftpClient.CopyMode opt : options) {
                    switch (opt) {
                        case Atomic: {
                            opts |= 2;
                            break;
                        }
                        case Overwrite: {
                            opts |= 1;
                            break;
                        }
                    }
                }
            }
            buffer.putInt(opts);
        } else if (numOptions > 0) {
            throw new UnsupportedOperationException("rename(" + oldPath + " => " + newPath + ")" + " - copy options can not be used with this SFTP version: " + options);
        }
        this.checkStatus(18, buffer);
    }

    @Override
    public int read(SftpClient.Handle handle, long fileOffset, byte[] dst, int dstOffset, int len) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("read(" + handle + "/" + fileOffset + ")[" + dstOffset + "/" + len + "] client is closed");
        }
        byte[] id = handle.getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 64);
        buffer.putBytes(id);
        buffer.putLong(fileOffset);
        buffer.putInt(len);
        return this.checkData(5, buffer, dstOffset, dst);
    }

    protected int checkData(int cmd, Buffer request, int dstOffset, byte[] dst) throws IOException {
        int reqId = this.send(cmd, request);
        Buffer response = this.receive(reqId);
        return this.checkData(response, dstOffset, dst);
    }

    protected int checkData(Buffer buffer, int dstoff, byte[] dst) throws IOException {
        int length = buffer.getInt();
        int type = buffer.getUByte();
        int id = buffer.getInt();
        if (type == 103) {
            int len = buffer.getInt();
            buffer.getRawBytes(dst, dstoff, len);
            return len;
        }
        if (type == 101) {
            int substatus = buffer.getInt();
            String msg = buffer.getString();
            String lang = buffer.getString();
            if (this.log.isTraceEnabled()) {
                this.log.trace("checkData(id={}) - status: {} [{}] {}", new Object[]{id, substatus, lang, msg});
            }
            if (substatus == 1) {
                return -1;
            }
            this.throwStatusException(id, substatus, msg, lang);
        }
        throw new SshException("Unexpected SFTP packet received: type=" + type + ", id=" + id + ", length=" + length);
    }

    @Override
    public void write(SftpClient.Handle handle, long fileOffset, byte[] src, int srcOffset, int len) throws IOException {
        if (fileOffset < 0L || srcOffset < 0 || len < 0) {
            throw new IllegalArgumentException("write(" + handle + ") please ensure all parameters " + " are non-negative values: file-offset=" + fileOffset + ", src-offset=" + srcOffset + ", len=" + len);
        }
        if (srcOffset + len > src.length) {
            throw new IllegalArgumentException("write(" + handle + ")" + " cannot read bytes " + srcOffset + " to " + (srcOffset + len) + " when array is only of length " + src.length);
        }
        if (!this.isOpen()) {
            throw new IOException("write(" + handle + "/" + fileOffset + ")[" + srcOffset + "/" + len + "] client is closed");
        }
        byte[] id = handle.getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + len + 64);
        buffer.putBytes(id);
        buffer.putLong(fileOffset);
        buffer.putBytes(src, srcOffset, len);
        this.checkStatus(6, buffer);
    }

    @Override
    public void mkdir(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("mkdir(" + path + ") client is closed");
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64);
        buffer.putString(path);
        buffer.putInt(0L);
        int version = this.getVersion();
        if (version != 3) {
            ((Buffer)buffer).putByte((byte)0);
        }
        this.checkStatus(14, buffer);
    }

    @Override
    public void rmdir(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("rmdir(" + path + ") client is closed");
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64);
        buffer.putString(path);
        this.checkStatus(15, buffer);
    }

    @Override
    public SftpClient.CloseableHandle openDir(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("openDir(" + path + ") client is closed");
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64);
        buffer.putString(path);
        return new DefaultCloseableHandle(this, this.checkHandle(11, buffer));
    }

    @Override
    public List<SftpClient.DirEntry> readDir(SftpClient.Handle handle) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("readDir(" + handle + ") client is closed");
        }
        byte[] id = handle.getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 8);
        buffer.putBytes(id);
        return this.checkDir(this.receive(this.send(12, buffer)));
    }

    protected List<SftpClient.DirEntry> checkDir(Buffer buffer) throws IOException {
        int length = buffer.getInt();
        int type = buffer.getUByte();
        int id = buffer.getInt();
        if (type == 104) {
            int len = buffer.getInt();
            ArrayList<SftpClient.DirEntry> entries = new ArrayList<SftpClient.DirEntry>(len);
            for (int i = 0; i < len; ++i) {
                String name = buffer.getString();
                int version = this.getVersion();
                String longName = version == 3 ? buffer.getString() : null;
                SftpClient.Attributes attrs = this.readAttributes(buffer);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("checkDir(id={})[{}] ({})[{}]: {}", new Object[]{id, i, name, longName, attrs});
                }
                entries.add(new SftpClient.DirEntry(name, longName, attrs));
            }
            return entries;
        }
        if (type == 101) {
            int substatus = buffer.getInt();
            String msg = buffer.getString();
            String lang = buffer.getString();
            if (this.log.isTraceEnabled()) {
                this.log.trace("checkDir(id={}) - status: {} [{}] {}", new Object[]{id, substatus, lang, msg});
            }
            if (substatus == 1) {
                return null;
            }
            this.throwStatusException(id, substatus, msg, lang);
        }
        throw new SshException("Unexpected SFTP packet received: type=" + type + ", id=" + id + ", length=" + length);
    }

    @Override
    public String canonicalPath(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("canonicalPath(" + path + ") client is closed");
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer();
        buffer.putString(path);
        return this.checkOneName(16, buffer);
    }

    @Override
    public SftpClient.Attributes stat(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("stat(" + path + ") client is closed");
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer();
        buffer.putString(path);
        int version = this.getVersion();
        if (version >= 4) {
            buffer.putInt(65535L);
        }
        return this.checkAttributes(17, buffer);
    }

    @Override
    public SftpClient.Attributes lstat(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("lstat(" + path + ") client is closed");
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer();
        buffer.putString(path);
        int version = this.getVersion();
        if (version >= 4) {
            buffer.putInt(65535L);
        }
        return this.checkAttributes(7, buffer);
    }

    @Override
    public SftpClient.Attributes stat(SftpClient.Handle handle) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("stat(" + handle + ") client is closed");
        }
        byte[] id = handle.getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 8);
        buffer.putBytes(id);
        int version = this.getVersion();
        if (version >= 4) {
            buffer.putInt(65535L);
        }
        return this.checkAttributes(8, buffer);
    }

    @Override
    public void setStat(String path, SftpClient.Attributes attributes) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("setStat(" + path + ")[" + attributes + "] client is closed");
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer();
        buffer.putString(path);
        this.writeAttributes(buffer, attributes);
        this.checkStatus(9, buffer);
    }

    @Override
    public void setStat(SftpClient.Handle handle, SftpClient.Attributes attributes) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("setStat(" + handle + ")[" + attributes + "] client is closed");
        }
        byte[] id = handle.getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 128);
        buffer.putBytes(id);
        this.writeAttributes(buffer, attributes);
        this.checkStatus(10, buffer);
    }

    @Override
    public String readLink(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("readLink(" + path + ") client is closed");
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64);
        buffer.putString(path);
        return this.checkOneName(19, buffer);
    }

    @Override
    public void link(String linkPath, String targetPath, boolean symbolic) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("link(" + linkPath + " => " + targetPath + ")[symbolic=" + symbolic + "] client is closed");
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(linkPath.length() + targetPath.length() + 64);
        int version = this.getVersion();
        if (version < 6) {
            if (!symbolic) {
                throw new UnsupportedOperationException("Hard links are not supported in sftp v" + version);
            }
            buffer.putString(targetPath);
            buffer.putString(linkPath);
            this.checkStatus(20, buffer);
        } else {
            buffer.putString(targetPath);
            buffer.putString(linkPath);
            buffer.putBoolean(symbolic);
            this.checkStatus(21, buffer);
        }
    }

    @Override
    public void lock(SftpClient.Handle handle, long offset, long length, int mask) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("lock(" + handle + ")[offset=" + offset + ", length=" + length + ", mask=0x" + Integer.toHexString(mask) + "] client is closed");
        }
        byte[] id = handle.getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 64);
        buffer.putBytes(id);
        buffer.putLong(offset);
        buffer.putLong(length);
        buffer.putInt(mask);
        this.checkStatus(22, buffer);
    }

    @Override
    public void unlock(SftpClient.Handle handle, long offset, long length) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("unlock" + handle + ")[offset=" + offset + ", length=" + length + "] client is closed");
        }
        byte[] id = handle.getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 64);
        buffer.putBytes(id);
        buffer.putLong(offset);
        buffer.putLong(length);
        this.checkStatus(23, buffer);
    }

    @Override
    public Iterable<SftpClient.DirEntry> readDir(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("readDir(" + path + ") client is closed");
        }
        return new SftpIterableDirEntry(this, path);
    }

    @Override
    public InputStream read(String path, int bufferSize, Collection<SftpClient.OpenMode> mode) throws IOException {
        if (bufferSize < 127) {
            throw new IllegalArgumentException("Insufficient read buffer size: " + bufferSize + ", min.=" + 127);
        }
        if (!this.isOpen()) {
            throw new IOException("read(" + path + ")[" + mode + "] size=" + bufferSize + ": client is closed");
        }
        return new SftpInputStreamWithChannel(this, bufferSize, path, mode);
    }

    @Override
    public OutputStream write(String path, int bufferSize, Collection<SftpClient.OpenMode> mode) throws IOException {
        if (bufferSize < 127) {
            throw new IllegalArgumentException("Insufficient write buffer size: " + bufferSize + ", min.=" + 127);
        }
        if (!this.isOpen()) {
            throw new IOException("write(" + path + ")[" + mode + "] size=" + bufferSize + ": client is closed");
        }
        return new SftpOutputStreamWithChannel(this, bufferSize, path, mode);
    }
}

