/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit;

import org.apache.commons.lang.StringUtils;
import org.apache.ftpserver.ConnectionConfig;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.listener.ListenerFactory;
import org.mule.munit.MockUserManagerAuthenticator;
import org.mule.munit.Server;

public class FTPServer
extends Server {
    private FtpServer server;

    public static Server instance(int port, String username, String password, boolean anonymous, String homeDir) {
        FTPServer ftpServer = new FTPServer();
        ftpServer.initialize(port, username, password, anonymous, homeDir);
        return ftpServer;
    }

    @Override
    void initialize(int port, String username, String password, boolean anonymous, String homeDir) {
        FtpServerFactory serverFactory = new FtpServerFactory();
        ListenerFactory factory = new ListenerFactory();
        factory.setPort(port);
        serverFactory.setConnectionConfig((ConnectionConfig)new MockConnectionConfig(anonymous));
        serverFactory.setUserManager((UserManager)new MockUserManagerAuthenticator(username, password, anonymous, this.getAdaptedPath(homeDir)));
        serverFactory.addListener("default", factory.createListener());
        this.server = serverFactory.createServer();
    }

    private String getAdaptedPath(String homeDir) {
        return StringUtils.isBlank((String)homeDir) ? "/" : homeDir;
    }

    @Override
    void start() {
        try {
            this.server.start();
        }
        catch (FtpException e) {
            throw new RuntimeException("Could not start FTP server", e);
        }
    }

    @Override
    void stop() {
        this.server.stop();
    }

    private class MockConnectionConfig
    implements ConnectionConfig {
        private boolean anonymous;

        public MockConnectionConfig(boolean anonymous) {
            this.anonymous = anonymous;
        }

        public int getMaxThreads() {
            return 0;
        }

        public int getMaxLoginFailures() {
            return 0;
        }

        public int getLoginFailureDelay() {
            return 0;
        }

        public int getMaxAnonymousLogins() {
            return 100;
        }

        public int getMaxLogins() {
            return 0;
        }

        public boolean isAnonymousLoginEnabled() {
            return this.anonymous;
        }
    }
}

