/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.digest;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;

public final class DigestUtils {
    private DigestUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static String getFingerPrint(Factory<? extends Digest> f, String s) throws Exception {
        return DigestUtils.getFingerPrint(f, s, StandardCharsets.UTF_8);
    }

    public static String getFingerPrint(Factory<? extends Digest> f, String s, Charset charset) throws Exception {
        return DigestUtils.getFingerPrint(f.create(), s, charset);
    }

    public static String getFingerPrint(Digest d, String s) throws Exception {
        return DigestUtils.getFingerPrint(d, s, StandardCharsets.UTF_8);
    }

    public static String getFingerPrint(Digest d, String s, Charset charset) throws Exception {
        if (GenericUtils.isEmpty(s)) {
            return null;
        }
        return DigestUtils.getFingerPrint(d, s.getBytes(charset));
    }

    public static String getFingerPrint(Factory<? extends Digest> f, byte ... buf) throws Exception {
        return DigestUtils.getFingerPrint(f, buf, 0, GenericUtils.length(buf));
    }

    public static String getFingerPrint(Factory<? extends Digest> f, byte[] buf, int offset, int len) throws Exception {
        return DigestUtils.getFingerPrint(f.create(), buf, offset, len);
    }

    public static String getFingerPrint(Digest d, byte ... buf) throws Exception {
        return DigestUtils.getFingerPrint(d, buf, 0, GenericUtils.length(buf));
    }

    public static String getFingerPrint(Digest d, byte[] buf, int offset, int len) throws Exception {
        if (len <= 0) {
            return null;
        }
        d.init();
        d.update(buf, offset, len);
        byte[] data = d.digest();
        return BufferUtils.printHex(data, 0, data.length, ':');
    }
}

