/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.command.impl.listing.DirectoryLister;
import org.apache.ftpserver.command.impl.listing.ListArgument;
import org.apache.ftpserver.command.impl.listing.ListArgumentParser;
import org.apache.ftpserver.command.impl.listing.MLSTFileFormater;
import org.apache.ftpserver.ftplet.DataConnection;
import org.apache.ftpserver.ftplet.DefaultFtpReply;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.impl.IODataConnectionFactory;
import org.apache.ftpserver.impl.LocalizedFtpReply;
import org.apache.ftpserver.impl.ServerDataConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLSD
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(MLSD.class);
    private DirectoryLister directoryLister = new DirectoryLister();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        try {
            DataConnection dataConnection;
            InetAddress address;
            session.resetState();
            ServerDataConnectionFactory connFactory = session.getDataConnection();
            if (connFactory instanceof IODataConnectionFactory && (address = ((IODataConnectionFactory)connFactory).getInetAddress()) == null) {
                session.write(new DefaultFtpReply(503, "PORT or PASV must be issued first"));
                return;
            }
            session.write(LocalizedFtpReply.translate(session, request, context, 150, "MLSD", null));
            try {
                dataConnection = session.getDataConnection().openConnection();
            }
            catch (Exception e) {
                this.LOG.debug("Exception getting the output data stream", (Throwable)e);
                session.write(LocalizedFtpReply.translate(session, request, context, 425, "MLSD", null));
                session.getDataConnection().closeDataConnection();
                return;
            }
            boolean failure = false;
            try {
                ListArgument parsedArg = ListArgumentParser.parse(request.getArgument());
                MLSTFileFormater formater = new MLSTFileFormater((String[])session.getAttribute("MLST.types"));
                dataConnection.transferToClient(session.getFtpletSession(), this.directoryLister.listFiles(parsedArg, session.getFileSystemView(), formater));
            }
            catch (SocketException ex) {
                this.LOG.debug("Socket exception during data transfer", (Throwable)ex);
                failure = true;
                session.write(LocalizedFtpReply.translate(session, request, context, 426, "MLSD", null));
            }
            catch (IOException ex) {
                this.LOG.debug("IOException during data transfer", (Throwable)ex);
                failure = true;
                session.write(LocalizedFtpReply.translate(session, request, context, 551, "MLSD", null));
            }
            catch (IllegalArgumentException e) {
                this.LOG.debug("Illegal listing syntax: " + request.getArgument(), (Throwable)e);
                session.write(LocalizedFtpReply.translate(session, request, context, 501, "MLSD", null));
            }
            if (!failure) {
                session.write(LocalizedFtpReply.translate(session, request, context, 226, "MLSD", null));
            }
        }
        finally {
            session.getDataConnection().closeDataConnection();
        }
    }
}

