/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.subsystem.sftp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.channels.Channel;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.subsystem.sftp.SftpClient;
import org.apache.sshd.client.subsystem.sftp.SftpFileSystemProvider;
import org.apache.sshd.client.subsystem.sftp.extensions.openssh.OpenSSHStatExtensionInfo;
import org.apache.sshd.client.subsystem.sftp.extensions.openssh.OpenSSHStatPathExtension;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.subsystem.sftp.extensions.ParserUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.io.NoCloseInputStream;

public class SftpCommand
implements Channel {
    private final SftpClient client;
    private final Map<String, CommandExecutor> commandsMap;
    private String cwdRemote;

    public SftpCommand(SftpClient client) {
        this.client = ValidateUtils.checkNotNull(client, "No client");
        TreeMap<String, CommandExecutor> map = new TreeMap<String, CommandExecutor>();
        for (CommandExecutor e : Arrays.asList(new ExitCommandExecutor(), new PwdCommandExecutor(), new InfoCommandExecutor(), new VersionCommandExecutor(), new CdCommandExecutor(), new MkdirCommandExecutor(), new LsCommandExecutor(), new RmCommandExecutor(), new RmdirCommandExecutor(), new RenameCommandExecutor(), new StatVfsCommandExecutor(), new HelpCommandExecutor())) {
            map.put(e.getName(), e);
        }
        this.commandsMap = Collections.unmodifiableMap(map);
    }

    public final SftpClient getClient() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInteractive(BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
        SftpClient sftp = this.getClient();
        this.setCurrentRemoteDirectory(sftp.canonicalPath("."));
        while (true) {
            String args;
            String cmd;
            stdout.append(this.getCurrentRemoteDirectory()).append(" > ").flush();
            String line = stdin.readLine();
            if (line == null) break;
            if (GenericUtils.isEmpty(line = line.trim())) continue;
            int pos = line.indexOf(32);
            if (pos > 0) {
                cmd = line.substring(0, pos);
                args = line.substring(pos + 1).trim();
            } else {
                cmd = line;
                args = "";
            }
            CommandExecutor exec = this.commandsMap.get(cmd);
            try {
                if (exec == null) {
                    stderr.append("Unknown command: ").println(line);
                    continue;
                }
                try {
                    if (!exec.executeCommand(args, stdin, stdout, stderr)) continue;
                }
                catch (Exception e) {
                    stderr.append(e.getClass().getSimpleName()).append(": ").println(e.getMessage());
                    continue;
                }
                finally {
                    stdout.flush();
                    continue;
                }
            }
            finally {
                stderr.flush();
                continue;
            }
            break;
        }
    }

    protected String resolveRemotePath(String pathArg) {
        String cwd = this.getCurrentRemoteDirectory();
        if (GenericUtils.isEmpty(pathArg)) {
            return cwd;
        }
        if (pathArg.charAt(0) == '/') {
            return pathArg;
        }
        return cwd + "/" + pathArg;
    }

    public String getCurrentRemoteDirectory() {
        return this.cwdRemote;
    }

    public void setCurrentRemoteDirectory(String path) {
        this.cwdRemote = path;
    }

    @Override
    public boolean isOpen() {
        return this.client.isOpen();
    }

    @Override
    public void close() throws IOException {
        if (this.isOpen()) {
            this.client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        PrintStream stdout = System.out;
        PrintStream stderr = System.err;
        try (BufferedReader stdin = new BufferedReader(new InputStreamReader(new NoCloseInputStream(System.in)));){
            ClientSession session = SshClient.setupClientSession("-P", stdin, stdout, stderr, args);
            if (session == null) {
                System.err.println("usage: sftp [-l login] [-P port] [-o option=value] hostname/user@host");
                System.exit(-1);
                return;
            }
            try (SftpCommand sftp = new SftpCommand(session.createSftpClient());){
                sftp.doInteractive(stdin, stdout, stderr);
            }
            finally {
                session.close();
            }
        }
    }

    private class HelpCommandExecutor
    implements CommandExecutor {
        private HelpCommandExecutor() {
        }

        @Override
        public String getName() {
            return "help";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            ValidateUtils.checkTrue(GenericUtils.isEmpty(args), "Unexpected arguments: %s", (Object)args);
            for (String cmd : SftpCommand.this.commandsMap.keySet()) {
                stdout.append('\t').println(cmd);
            }
            return false;
        }
    }

    private class StatVfsCommandExecutor
    implements CommandExecutor {
        private StatVfsCommandExecutor() {
        }

        @Override
        public String getName() {
            return "statvfs@openssh.com";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            Field[] fields;
            String[] comps = GenericUtils.split(args, ' ');
            ValidateUtils.checkTrue(GenericUtils.length(comps) == 1, "Invalid number of arguments: %s", (Object)args);
            SftpClient sftp = SftpCommand.this.getClient();
            OpenSSHStatPathExtension ext = sftp.getExtension(OpenSSHStatPathExtension.class);
            ValidateUtils.checkTrue(ext.isSupported(), "Extension not supported by server: %s", (Object)ext.getName());
            OpenSSHStatExtensionInfo info = ext.stat(GenericUtils.trimToEmpty(comps[0]));
            for (Field f : fields = info.getClass().getFields()) {
                String name = f.getName();
                int mod = f.getModifiers();
                if (Modifier.isStatic(mod)) continue;
                Object value = f.get(info);
                stdout.append('\t').append(name).append(": ").println(value);
            }
            return false;
        }
    }

    private class RenameCommandExecutor
    implements CommandExecutor {
        private RenameCommandExecutor() {
        }

        @Override
        public String getName() {
            return "rename";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            String[] comps = GenericUtils.split(args, ' ');
            ValidateUtils.checkTrue(GenericUtils.length(comps) == 2, "Invalid number of arguments: %s", (Object)args);
            String oldPath = SftpCommand.this.resolveRemotePath(GenericUtils.trimToEmpty(comps[0]));
            String newPath = SftpCommand.this.resolveRemotePath(GenericUtils.trimToEmpty(comps[1]));
            SftpClient sftp = SftpCommand.this.getClient();
            sftp.rename(oldPath, newPath);
            return false;
        }
    }

    private class RmdirCommandExecutor
    implements CommandExecutor {
        private RmdirCommandExecutor() {
        }

        @Override
        public String getName() {
            return "rmdir";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            ValidateUtils.checkNotNullAndNotEmpty(args, "No remote directory specified", (Object)args);
            String path = SftpCommand.this.resolveRemotePath(args);
            SftpClient sftp = SftpCommand.this.getClient();
            sftp.rmdir(path);
            return false;
        }
    }

    private class RmCommandExecutor
    implements CommandExecutor {
        private RmCommandExecutor() {
        }

        @Override
        public String getName() {
            return "rm";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            ValidateUtils.checkNotNullAndNotEmpty(args, "No remote directory specified", (Object)args);
            String path = SftpCommand.this.resolveRemotePath(args);
            SftpClient sftp = SftpCommand.this.getClient();
            sftp.remove(path);
            return false;
        }
    }

    private class LsCommandExecutor
    implements CommandExecutor {
        private LsCommandExecutor() {
        }

        @Override
        public String getName() {
            return "ls";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            String[] comps = GenericUtils.split(args, ' ');
            String pathArg = GenericUtils.isEmpty(comps) ? null : GenericUtils.trimToEmpty(comps[comps.length - 1]);
            String cwd = SftpCommand.this.getCurrentRemoteDirectory();
            if (GenericUtils.isEmpty(pathArg) || pathArg.charAt(0) == '-') {
                pathArg = cwd;
            }
            String path = SftpCommand.this.resolveRemotePath(pathArg);
            SftpClient sftp = SftpCommand.this.getClient();
            for (SftpClient.DirEntry entry : sftp.readDir(path)) {
                SftpClient.Attributes attrs = entry.attributes;
                stdout.append('\t').append(entry.filename).append('\t').append(Long.toString(attrs.size)).append('\t').println(SftpFileSystemProvider.getRWXPermissions(attrs.perms));
            }
            return false;
        }
    }

    private class MkdirCommandExecutor
    implements CommandExecutor {
        private MkdirCommandExecutor() {
        }

        @Override
        public String getName() {
            return "mkdir";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            ValidateUtils.checkNotNullAndNotEmpty(args, "No remote directory specified", (Object)args);
            String path = SftpCommand.this.resolveRemotePath(args);
            SftpClient sftp = SftpCommand.this.getClient();
            sftp.mkdir(path);
            return false;
        }
    }

    private class CdCommandExecutor
    implements CommandExecutor {
        private CdCommandExecutor() {
        }

        @Override
        public String getName() {
            return "cd";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            ValidateUtils.checkNotNullAndNotEmpty(args, "No remote directory specified", (Object)args);
            String newPath = SftpCommand.this.resolveRemotePath(args);
            SftpClient sftp = SftpCommand.this.getClient();
            SftpCommand.this.setCurrentRemoteDirectory(sftp.canonicalPath(newPath));
            return false;
        }
    }

    private class VersionCommandExecutor
    implements CommandExecutor {
        private VersionCommandExecutor() {
        }

        @Override
        public String getName() {
            return "version";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            ValidateUtils.checkTrue(GenericUtils.isEmpty(args), "Unexpected arguments: %s", (Object)args);
            SftpClient sftp = SftpCommand.this.getClient();
            stdout.append('\t').println(sftp.getVersion());
            return false;
        }
    }

    private class InfoCommandExecutor
    implements CommandExecutor {
        private InfoCommandExecutor() {
        }

        @Override
        public String getName() {
            return "info";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            ValidateUtils.checkTrue(GenericUtils.isEmpty(args), "Unexpected arguments: %s", (Object)args);
            SftpClient sftp = SftpCommand.this.getClient();
            Map<String, byte[]> extensions = sftp.getServerExtensions();
            Map<String, Object> parsed = ParserUtils.parse(extensions);
            for (Map.Entry<String, byte[]> ee : extensions.entrySet()) {
                String name = ee.getKey();
                byte[] value = ee.getValue();
                Object info = parsed.get(name);
                stdout.append('\t').append(name).append(": ");
                if (info == null) {
                    stdout.println(BufferUtils.printHex(value));
                    continue;
                }
                stdout.println(info);
            }
            return false;
        }
    }

    private class PwdCommandExecutor
    implements CommandExecutor {
        private PwdCommandExecutor() {
        }

        @Override
        public String getName() {
            return "pwd";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            ValidateUtils.checkTrue(GenericUtils.isEmpty(args), "Unexpected arguments: %s", (Object)args);
            stdout.append('\t').println(SftpCommand.this.getCurrentRemoteDirectory());
            return false;
        }
    }

    private static class ExitCommandExecutor
    implements CommandExecutor {
        private ExitCommandExecutor() {
        }

        @Override
        public String getName() {
            return "exit";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            ValidateUtils.checkTrue(GenericUtils.isEmpty(args), "Unexpected arguments: %s", (Object)args);
            stdout.println("Exiting");
            return true;
        }
    }

    public static interface CommandExecutor
    extends NamedResource {
        public boolean executeCommand(String var1, BufferedReader var2, PrintStream var3, PrintStream var4) throws Exception;
    }
}

