/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.channels.Channel;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.AbstractChannel;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.channel.WindowClosedException;
import org.apache.sshd.common.util.buffer.Buffer;
import org.slf4j.Logger;

public class ChannelOutputStream
extends OutputStream
implements Channel {
    private final AbstractChannel channel;
    private final Window remoteWindow;
    private final Logger log;
    private final byte cmd;
    private final byte[] b = new byte[1];
    private Buffer buffer;
    private boolean closed;
    private int bufferLength;
    private int lastSize;
    private boolean noDelay;

    public ChannelOutputStream(AbstractChannel channel, Window remoteWindow, Logger log, byte cmd) {
        this.channel = channel;
        this.remoteWindow = remoteWindow;
        this.log = log;
        this.cmd = cmd;
        this.newBuffer(0);
    }

    public void setNoDelay(boolean noDelay) {
        this.noDelay = noDelay;
    }

    public boolean isNoDelay() {
        return this.noDelay;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public synchronized void write(int w) throws IOException {
        this.b[0] = (byte)w;
        this.write(this.b, 0, 1);
    }

    @Override
    public synchronized void write(byte[] buf, int s, int l) throws IOException {
        if (!this.isOpen()) {
            throw new SshException("write(len=" + l + ") channel already closed");
        }
        while (l > 0) {
            int l2 = Math.min(l, Math.min(this.remoteWindow.getSize() + this.lastSize, this.remoteWindow.getPacketSize()) - this.bufferLength);
            if (l2 <= 0) {
                if (this.bufferLength > 0) {
                    this.flush();
                    continue;
                }
                try {
                    this.remoteWindow.waitForSpace();
                    continue;
                }
                catch (WindowClosedException e) {
                    this.closed = true;
                    throw e;
                }
                catch (InterruptedException e) {
                    throw (IOException)new InterruptedIOException("Interrupted while waiting for remote space").initCause(e);
                }
            }
            this.buffer.putRawBytes(buf, s, l2);
            this.bufferLength += l2;
            s += l2;
            l -= l2;
        }
        if (this.noDelay) {
            this.flush();
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (!this.isOpen()) {
            throw new SshException("flush(length=" + this.bufferLength + ") - stream is already closed");
        }
        try {
            while (this.bufferLength > 0) {
                Buffer buf = this.buffer;
                int total = this.bufferLength;
                int length = Math.min(Math.min(this.remoteWindow.waitForSpace(), total), this.remoteWindow.getPacketSize());
                int pos = buf.wpos();
                buf.wpos(this.cmd == 95 ? 14 : 10);
                buf.putInt(length);
                buf.wpos(buf.wpos() + length);
                if (total == length) {
                    this.newBuffer(length);
                } else {
                    int leftover = total - length;
                    this.newBuffer(Math.max(leftover, length));
                    this.buffer.putRawBytes(buf.array(), pos - leftover, leftover);
                    this.bufferLength = leftover;
                }
                this.lastSize = length;
                this.remoteWindow.waitAndConsume(length);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Send {} on channel {}", (Object)(this.cmd == 94 ? "SSH_MSG_CHANNEL_DATA" : "SSH_MSG_CHANNEL_EXTENDED_DATA"), (Object)this.channel.getId());
                }
                this.channel.writePacket(buf);
            }
        }
        catch (WindowClosedException e) {
            this.closed = true;
            throw e;
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new SshException(e);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isOpen()) {
            try {
                this.flush();
            }
            finally {
                this.closed = true;
            }
        }
    }

    private void newBuffer(int size) {
        this.buffer = this.channel.getSession().createBuffer(this.cmd, size <= 0 ? 0 : 12 + size);
        this.buffer.putInt(this.channel.getRecipient());
        if (this.cmd == 95) {
            this.buffer.putInt(1L);
        }
        this.buffer.putInt(0L);
        this.bufferLength = 0;
    }
}

