/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.config.keys.DSSPublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.ECDSAPublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.PublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.RSAPublicKeyDecoder;
import org.apache.sshd.common.digest.BuiltinDigests;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.digest.DigestUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.io.IoUtils;

public final class KeyUtils {
    public static final Set<PosixFilePermission> STRICTLY_PROHIBITED_FILE_PERMISSION = Collections.unmodifiableSet(EnumSet.of(PosixFilePermission.GROUP_READ, new PosixFilePermission[]{PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_WRITE, PosixFilePermission.OTHERS_EXECUTE}));
    public static final Factory<Digest> DEFAULT_FINGERPRINT_DIGEST_FACTORY = BuiltinDigests.md5;
    private static final AtomicReference<Factory<? extends Digest>> DEFAULT_DIGEST_HOLDER = new AtomicReference<Factory<Digest>>(DEFAULT_FINGERPRINT_DIGEST_FACTORY);
    private static final Map<String, PublicKeyEntryDecoder<?, ?>> BY_KEY_TYPE_DECODERS_MAP = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private static final Map<Class<?>, PublicKeyEntryDecoder<?, ?>> BY_KEY_CLASS_DECODERS_MAP = new HashMap();

    private KeyUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static PosixFilePermission validateStrictKeyFilePermissions(Path path, LinkOption ... options) throws IOException {
        if (path == null || !Files.exists(path, options)) {
            return null;
        }
        Set<PosixFilePermission> perms = IoUtils.getPermissions(path, options);
        if (GenericUtils.isEmpty(perms)) {
            return null;
        }
        if (perms.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
            return PosixFilePermission.OTHERS_EXECUTE;
        }
        if (OsUtils.isUNIX()) {
            Path parent;
            PosixFilePermission p = IoUtils.validateExcludedPermissions(perms, STRICTLY_PROHIBITED_FILE_PERMISSION);
            if (p != null) {
                return p;
            }
            if (Files.isRegularFile(path, options) && (p = IoUtils.validateExcludedPermissions(IoUtils.getPermissions(parent = path.getParent(), options), STRICTLY_PROHIBITED_FILE_PERMISSION)) != null) {
                return p;
            }
        }
        return null;
    }

    public static KeyPair generateKeyPair(String keyType, int keySize) throws GeneralSecurityException {
        PublicKeyEntryDecoder<?, ?> decoder = KeyUtils.getPublicKeyEntryDecoder(keyType);
        if (decoder == null) {
            throw new InvalidKeySpecException("No decoder for key type=" + keyType);
        }
        return decoder.generateKeyPair(keySize);
    }

    public static KeyPair cloneKeyPair(String keyType, KeyPair kp) throws GeneralSecurityException {
        PublicKeyEntryDecoder<?, ?> decoder = KeyUtils.getPublicKeyEntryDecoder(keyType);
        if (decoder == null) {
            throw new InvalidKeySpecException("No decoder for key type=" + keyType);
        }
        return decoder.cloneKeyPair(kp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerPublicKeyEntryDecoder(PublicKeyEntryDecoder<?, ?> decoder) {
        ValidateUtils.checkNotNull(decoder, "No decoder specified");
        Class<?> pubType = ValidateUtils.checkNotNull(decoder.getPublicKeyType(), "No public key type declared");
        Class<?> prvType = ValidateUtils.checkNotNull(decoder.getPrivateKeyType(), "No private key type declared");
        Map<Class<?>, PublicKeyEntryDecoder<?, ?>> map = BY_KEY_CLASS_DECODERS_MAP;
        synchronized (map) {
            BY_KEY_CLASS_DECODERS_MAP.put(pubType, decoder);
            BY_KEY_CLASS_DECODERS_MAP.put(prvType, decoder);
        }
        Collection<String> names = ValidateUtils.checkNotNullAndNotEmpty(decoder.getSupportedTypeNames(), "No supported key type", new Object[0]);
        Map<String, PublicKeyEntryDecoder<?, ?>> map2 = BY_KEY_TYPE_DECODERS_MAP;
        synchronized (map2) {
            for (String n : names) {
                PublicKeyEntryDecoder<?, ?> prev = BY_KEY_TYPE_DECODERS_MAP.put(n, decoder);
                if (prev == null) continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublicKeyEntryDecoder<?, ?> getPublicKeyEntryDecoder(String keyType) {
        if (GenericUtils.isEmpty(keyType)) {
            return null;
        }
        Map<String, PublicKeyEntryDecoder<?, ?>> map = BY_KEY_TYPE_DECODERS_MAP;
        synchronized (map) {
            return BY_KEY_TYPE_DECODERS_MAP.get(keyType);
        }
    }

    public static PublicKeyEntryDecoder<?, ?> getPublicKeyEntryDecoder(KeyPair kp) {
        PublicKeyEntryDecoder<?, ?> d2;
        if (kp == null) {
            return null;
        }
        PublicKeyEntryDecoder<?, ?> d1 = KeyUtils.getPublicKeyEntryDecoder(kp.getPublic());
        if (d1 == (d2 = KeyUtils.getPublicKeyEntryDecoder(kp.getPrivate()))) {
            return d1;
        }
        return null;
    }

    public static PublicKeyEntryDecoder<?, ?> getPublicKeyEntryDecoder(Key key) {
        if (key == null) {
            return null;
        }
        return KeyUtils.getPublicKeyEntryDecoder(key.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublicKeyEntryDecoder<?, ?> getPublicKeyEntryDecoder(Class<?> keyType) {
        if (keyType == null || !Key.class.isAssignableFrom(keyType)) {
            return null;
        }
        Map<String, PublicKeyEntryDecoder<?, ?>> map = BY_KEY_TYPE_DECODERS_MAP;
        synchronized (map) {
            PublicKeyEntryDecoder<?, ?> decoder = BY_KEY_CLASS_DECODERS_MAP.get(keyType);
            if (decoder != null) {
                return decoder;
            }
            for (PublicKeyEntryDecoder<?, ?> dec : BY_KEY_CLASS_DECODERS_MAP.values()) {
                Class<?> pubType = dec.getPublicKeyType();
                Class<?> prvType = dec.getPrivateKeyType();
                if (!pubType.isAssignableFrom(keyType) && !prvType.isAssignableFrom(keyType)) continue;
                return dec;
            }
        }
        return null;
    }

    public static Factory<? extends Digest> getDefaultFingerPrintFactory() {
        return DEFAULT_DIGEST_HOLDER.get();
    }

    public static void setDefaultFingerPrintFactory(Factory<? extends Digest> f) {
        DEFAULT_DIGEST_HOLDER.set(ValidateUtils.checkNotNull(f, "No digest factory"));
    }

    public static String getFingerPrint(PublicKey key) {
        return KeyUtils.getFingerPrint(KeyUtils.getDefaultFingerPrintFactory(), key);
    }

    public static String getFingerPrint(String password) {
        return KeyUtils.getFingerPrint(password, StandardCharsets.UTF_8);
    }

    public static String getFingerPrint(String password, Charset charset) {
        return KeyUtils.getFingerPrint(KeyUtils.getDefaultFingerPrintFactory(), password, charset);
    }

    public static String getFingerPrint(Factory<? extends Digest> f, PublicKey key) {
        return KeyUtils.getFingerPrint(f.create(), key);
    }

    public static String getFingerPrint(Digest d, PublicKey key) {
        if (key == null) {
            return null;
        }
        try {
            ByteArrayBuffer buffer = new ByteArrayBuffer();
            buffer.putRawPublicKey(key);
            return DigestUtils.getFingerPrint(d, ((Buffer)buffer).array(), 0, ((Buffer)buffer).wpos());
        }
        catch (Exception e) {
            return e.getClass().getSimpleName();
        }
    }

    public static String getFingerPrint(Factory<? extends Digest> f, String s) {
        return KeyUtils.getFingerPrint(f, s, StandardCharsets.UTF_8);
    }

    public static String getFingerPrint(Factory<? extends Digest> f, String s, Charset charset) {
        return KeyUtils.getFingerPrint(f.create(), s, charset);
    }

    public static String getFingerPrint(Digest d, String s) {
        return KeyUtils.getFingerPrint(d, s, StandardCharsets.UTF_8);
    }

    public static String getFingerPrint(Digest d, String s, Charset charset) {
        if (GenericUtils.isEmpty(s)) {
            return null;
        }
        try {
            return DigestUtils.getFingerPrint(d, s, charset);
        }
        catch (Exception e) {
            return e.getClass().getSimpleName();
        }
    }

    public static String getKeyType(KeyPair kp) {
        if (kp == null) {
            return null;
        }
        PrivateKey key = kp.getPrivate();
        if (key != null) {
            return KeyUtils.getKeyType(key);
        }
        return KeyUtils.getKeyType(kp.getPublic());
    }

    public static String getKeyType(Key key) {
        if (key instanceof DSAKey) {
            return "ssh-dss";
        }
        if (key instanceof RSAKey) {
            return "ssh-rsa";
        }
        if (key instanceof ECKey) {
            ECKey ecKey = (ECKey)((Object)key);
            ECParameterSpec ecSpec = ecKey.getParams();
            ECCurves curve = ECCurves.fromCurveParameters(ecSpec);
            if (curve == null) {
                return null;
            }
            return curve.getKeyType();
        }
        return null;
    }

    public static PublicKey findMatchingKey(PublicKey key, PublicKey ... keySet) {
        if (key == null || GenericUtils.isEmpty(keySet)) {
            return null;
        }
        return KeyUtils.findMatchingKey(key, Arrays.asList(keySet));
    }

    public static PublicKey findMatchingKey(PublicKey key, Collection<? extends PublicKey> keySet) {
        if (key == null || GenericUtils.isEmpty(keySet)) {
            return null;
        }
        for (PublicKey publicKey : keySet) {
            if (!KeyUtils.compareKeys(key, publicKey)) continue;
            return publicKey;
        }
        return null;
    }

    public static boolean compareKeyPairs(KeyPair k1, KeyPair k2) {
        if (Objects.equals(k1, k2)) {
            return true;
        }
        if (k1 == null || k2 == null) {
            return false;
        }
        return KeyUtils.compareKeys(k1.getPublic(), k2.getPublic()) && KeyUtils.compareKeys(k1.getPrivate(), k2.getPrivate());
    }

    public static boolean compareKeys(PrivateKey k1, PrivateKey k2) {
        if (k1 instanceof RSAPrivateKey && k2 instanceof RSAPrivateKey) {
            return KeyUtils.compareRSAKeys((RSAPrivateKey)RSAPrivateKey.class.cast(k1), (RSAPrivateKey)RSAPrivateKey.class.cast(k2));
        }
        if (k1 instanceof DSAPrivateKey && k2 instanceof DSAPrivateKey) {
            return KeyUtils.compareDSAKeys((DSAPrivateKey)DSAPrivateKey.class.cast(k1), (DSAPrivateKey)DSAPrivateKey.class.cast(k2));
        }
        if (k1 instanceof ECPrivateKey && k2 instanceof ECPrivateKey) {
            return KeyUtils.compareECKeys((ECPrivateKey)ECPrivateKey.class.cast(k1), (ECPrivateKey)ECPrivateKey.class.cast(k2));
        }
        return false;
    }

    public static boolean compareRSAKeys(RSAPrivateKey k1, RSAPrivateKey k2) {
        if (Objects.equals(k1, k2)) {
            return true;
        }
        if (k1 == null || k2 == null) {
            return false;
        }
        return Objects.equals(k1.getModulus(), k2.getModulus()) && Objects.equals(k1.getPrivateExponent(), k2.getPrivateExponent());
    }

    public static boolean compareDSAKeys(DSAPrivateKey k1, DSAPrivateKey k2) {
        if (Objects.equals(k1, k2)) {
            return true;
        }
        if (k1 == null || k2 == null) {
            return false;
        }
        return Objects.equals(k1.getX(), k2.getX()) && KeyUtils.compareDSAParams(k1.getParams(), k2.getParams());
    }

    public static boolean compareECKeys(ECPrivateKey k1, ECPrivateKey k2) {
        if (Objects.equals(k1, k2)) {
            return true;
        }
        if (k1 == null || k2 == null) {
            return false;
        }
        return Objects.equals(k1.getS(), k2.getS()) && KeyUtils.compareECParams(k1.getParams(), k2.getParams());
    }

    public static boolean compareKeys(PublicKey k1, PublicKey k2) {
        if (k1 instanceof RSAPublicKey && k2 instanceof RSAPublicKey) {
            return KeyUtils.compareRSAKeys((RSAPublicKey)RSAPublicKey.class.cast(k1), (RSAPublicKey)RSAPublicKey.class.cast(k2));
        }
        if (k1 instanceof DSAPublicKey && k2 instanceof DSAPublicKey) {
            return KeyUtils.compareDSAKeys((DSAPublicKey)DSAPublicKey.class.cast(k1), (DSAPublicKey)DSAPublicKey.class.cast(k2));
        }
        if (k1 instanceof ECPublicKey && k2 instanceof ECPublicKey) {
            return KeyUtils.compareECKeys((ECPublicKey)ECPublicKey.class.cast(k1), (ECPublicKey)ECPublicKey.class.cast(k2));
        }
        return false;
    }

    public static boolean compareRSAKeys(RSAPublicKey k1, RSAPublicKey k2) {
        if (Objects.equals(k1, k2)) {
            return true;
        }
        if (k1 == null || k2 == null) {
            return false;
        }
        return Objects.equals(k1.getPublicExponent(), k2.getPublicExponent()) && Objects.equals(k1.getModulus(), k2.getModulus());
    }

    public static boolean compareDSAKeys(DSAPublicKey k1, DSAPublicKey k2) {
        if (Objects.equals(k1, k2)) {
            return true;
        }
        if (k1 == null || k2 == null) {
            return false;
        }
        return Objects.equals(k1.getY(), k2.getY()) && KeyUtils.compareDSAParams(k1.getParams(), k2.getParams());
    }

    public static boolean compareDSAParams(DSAParams p1, DSAParams p2) {
        if (Objects.equals(p1, p2)) {
            return true;
        }
        if (p1 == null || p2 == null) {
            return false;
        }
        return Objects.equals(p1.getG(), p2.getG()) && Objects.equals(p1.getP(), p2.getP()) && Objects.equals(p1.getQ(), p2.getQ());
    }

    public static boolean compareECKeys(ECPublicKey k1, ECPublicKey k2) {
        if (Objects.equals(k1, k2)) {
            return true;
        }
        if (k1 == null || k2 == null) {
            return false;
        }
        return Objects.equals(k1.getW(), k2.getW()) && KeyUtils.compareECParams(k1.getParams(), k2.getParams());
    }

    public static boolean compareECParams(ECParameterSpec s1, ECParameterSpec s2) {
        if (Objects.equals(s1, s2)) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return Objects.equals(s1.getOrder(), s2.getOrder()) && s1.getCofactor() == s2.getCofactor() && Objects.equals(s1.getGenerator(), s2.getGenerator()) && Objects.equals(s1.getCurve(), s2.getCurve());
    }

    static {
        KeyUtils.registerPublicKeyEntryDecoder(RSAPublicKeyDecoder.INSTANCE);
        KeyUtils.registerPublicKeyEntryDecoder(DSSPublicKeyEntryDecoder.INSTANCE);
        KeyUtils.registerPublicKeyEntryDecoder(ECDSAPublicKeyEntryDecoder.INSTANCE);
    }
}

