/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.signature;

import java.io.IOException;
import java.math.BigInteger;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.signature.AbstractSignature;
import org.apache.sshd.common.util.Pair;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.io.DERParser;
import org.apache.sshd.common.util.io.DERWriter;

public class SignatureECDSA
extends AbstractSignature {
    protected SignatureECDSA(String algo) {
        super(algo);
    }

    @Override
    public byte[] sign() throws Exception {
        byte[] sig = this.signature.sign();
        try (DERParser parser = new DERParser(sig);){
            int type = parser.read();
            if (type != 48) {
                throw new IOException("Invalid signature format - not a DER SEQUENCE: 0x" + Integer.toHexString(type));
            }
            int remainLen = parser.readLength();
            if (remainLen < 6) {
                throw new IOException("Invalid signature format - not enough encoded data length: " + remainLen);
            }
            BigInteger r = parser.readBigInteger();
            BigInteger s = parser.readBigInteger();
            ByteArrayBuffer rsBuf = new ByteArrayBuffer();
            rsBuf.putMPInt(r);
            rsBuf.putMPInt(s);
            byte[] byArray = rsBuf.getCompactData();
            return byArray;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean verify(byte[] sig) throws Exception {
        byte[] encoded;
        void var6_8;
        byte[] data = sig;
        Pair<String, byte[]> encoding = this.extractEncodedSignature(data);
        if (encoding != null) {
            String keyType = encoding.getFirst();
            ECCurves curve = ECCurves.fromKeyType(keyType);
            ValidateUtils.checkNotNull(curve, "Unknown curve type: %s", (Object)keyType);
            data = encoding.getSecond();
        }
        ByteArrayBuffer rsBuf = new ByteArrayBuffer(data);
        byte[] rArray = rsBuf.getMPIntAsBytes();
        try (DERWriter w = new DERWriter(rArray.length + 4);){
            w.writeBigInteger(rArray);
            byte[] rEncoding = w.toByteArray();
        }
        byte[] sArray = rsBuf.getMPIntAsBytes();
        try (DERWriter w = new DERWriter(sArray.length + 4);){
            w.writeBigInteger(sArray);
            byte[] sEncoding = w.toByteArray();
        }
        int remaining = rsBuf.available();
        if (remaining != 0) {
            throw new IOException("Signature had padding - remaining=" + remaining);
        }
        int length = ((void)var6_8).length + ((Throwable)var8_7).length;
        try (DERWriter w = new DERWriter(1 + length + 4);){
            w.write(48);
            w.writeLength(length);
            w.write((byte[])var6_8);
            w.write((byte[])var8_7);
            encoded = w.toByteArray();
        }
        return this.signature.verify(encoded);
    }
}

