/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.charset.StandardCharsets;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.FactoryManagerUtils;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.compression.Compression;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.KexState;
import org.apache.sshd.common.kex.KeyExchange;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.session.PendingWriteFuture;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.common.util.CloseableUtils;
import org.apache.sshd.common.util.EventListenerUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;

public abstract class AbstractSession
extends CloseableUtils.AbstractInnerCloseable
implements Session {
    public static final String DEFAULT_SSH_VERSION_PREFIX = "SSH-2.0-";
    public static final String SESSION = "org.apache.sshd.session";
    protected final boolean isServer;
    protected final FactoryManager factoryManager;
    protected final IoSession ioSession;
    protected final Random random;
    protected boolean authed;
    protected String username;
    protected final List<SessionListener> listeners = new CopyOnWriteArrayList<SessionListener>();
    protected final SessionListener sessionListenerProxy;
    protected byte[] sessionId;
    protected String serverVersion;
    protected String clientVersion;
    protected final Map<KexProposalOption, String> serverProposal = new EnumMap<KexProposalOption, String>(KexProposalOption.class);
    protected final Map<KexProposalOption, String> clientProposal = new EnumMap<KexProposalOption, String>(KexProposalOption.class);
    protected final Map<KexProposalOption, String> negotiationResult = new EnumMap<KexProposalOption, String>(KexProposalOption.class);
    protected byte[] i_c;
    protected byte[] i_s;
    protected KeyExchange kex;
    protected final AtomicReference<KexState> kexState = new AtomicReference<KexState>(KexState.UNKNOWN);
    protected DefaultSshFuture reexchangeFuture;
    protected Cipher outCipher;
    protected Cipher inCipher;
    protected int outCipherSize = 8;
    protected int inCipherSize = 8;
    protected Mac outMac;
    protected Mac inMac;
    protected byte[] inMacResult;
    protected Compression outCompression;
    protected Compression inCompression;
    protected long seqi;
    protected long seqo;
    protected Buffer decoderBuffer = new ByteArrayBuffer();
    protected Buffer uncompressBuffer;
    protected int decoderState;
    protected int decoderLength;
    protected final Object encodeLock = new Object();
    protected final Object decodeLock = new Object();
    protected final Object requestLock = new Object();
    protected final AtomicReference<Buffer> requestResult = new AtomicReference();
    protected final Map<Session.AttributeKey<?>, Object> attributes = new ConcurrentHashMap();
    protected long authTimeoutTimestamp;
    protected long idleTimeoutTimestamp;
    protected long authTimeoutMs = TimeUnit.MINUTES.toMillis(2L);
    protected long idleTimeoutMs = TimeUnit.MINUTES.toMillis(10L);
    protected long disconnectTimeoutMs = TimeUnit.SECONDS.toMillis(10L);
    protected final AtomicReference<Session.TimeoutStatus> timeoutStatus = new AtomicReference<Session.TimeoutStatus>(Session.TimeoutStatus.NoTimeout);
    protected final AtomicLong inPacketsCount = new AtomicLong(0L);
    protected final AtomicLong outPacketsCount = new AtomicLong(0L);
    protected final AtomicLong inBytesCount = new AtomicLong(0L);
    protected final AtomicLong outBytesCount = new AtomicLong(0L);
    protected final AtomicLong lastKeyTimeValue = new AtomicLong(0L);
    protected final Queue<PendingWriteFuture> pendingPackets = new LinkedList<PendingWriteFuture>();
    protected Service currentService;

    public AbstractSession(boolean isServer, FactoryManager factoryManager, IoSession ioSession) {
        this.isServer = isServer;
        this.factoryManager = ValidateUtils.checkNotNull(factoryManager, "No factory manager provided", GenericUtils.EMPTY_OBJECT_ARRAY);
        this.ioSession = ioSession;
        this.sessionListenerProxy = EventListenerUtils.proxyWrapper(SessionListener.class, this.getClass().getClassLoader(), this.listeners);
        this.random = factoryManager.getRandomFactory().create();
        this.authTimeoutMs = this.getLongProperty("auth-timeout", this.authTimeoutMs);
        this.authTimeoutTimestamp = System.currentTimeMillis() + this.authTimeoutMs;
        this.idleTimeoutMs = this.getLongProperty("idle-timeout", this.idleTimeoutMs);
        this.disconnectTimeoutMs = this.getLongProperty("disconnect-timeout", this.disconnectTimeoutMs);
    }

    public static AbstractSession getSession(IoSession ioSession) {
        return AbstractSession.getSession(ioSession, false);
    }

    public static AbstractSession getSession(IoSession ioSession, boolean allowNull) {
        AbstractSession session = (AbstractSession)ioSession.getAttribute(SESSION);
        if (session == null && !allowNull) {
            throw new IllegalStateException("No session available");
        }
        return session;
    }

    public static void attachSession(IoSession ioSession, AbstractSession session) {
        ioSession.setAttribute(SESSION, session);
    }

    @Override
    public String getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public String getClientVersion() {
        return this.clientVersion;
    }

    @Override
    public KeyExchange getKex() {
        return this.kex;
    }

    @Override
    public byte[] getSessionId() {
        return GenericUtils.isEmpty(this.sessionId) ? this.sessionId : (byte[])this.sessionId.clone();
    }

    @Override
    public IoSession getIoSession() {
        return this.ioSession;
    }

    @Override
    public FactoryManager getFactoryManager() {
        return this.factoryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNegotiatedKexParameter(KexProposalOption paramType) {
        if (paramType == null) {
            return null;
        }
        Map<KexProposalOption, String> map = this.negotiationResult;
        synchronized (map) {
            return this.negotiationResult.get((Object)paramType);
        }
    }

    @Override
    public boolean isAuthenticated() {
        return this.authed;
    }

    @Override
    public void setAuthenticated() throws IOException {
        this.authed = true;
        this.sendEvent(SessionListener.Event.Authenticated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(Readable buffer) throws Exception {
        Object object = this.decodeLock;
        synchronized (object) {
            this.decoderBuffer.putBuffer(buffer);
            if (this.clientVersion == null || this.serverVersion == null) {
                if (this.readIdentification(this.decoderBuffer)) {
                    this.decoderBuffer.compact();
                } else {
                    return;
                }
            }
            this.decode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMessage(Buffer buffer) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.doHandleMessage(buffer);
        }
    }

    protected void doHandleMessage(Buffer buffer) throws Exception {
        int cmd = buffer.getUByte();
        switch (cmd) {
            case 1: {
                this.handleDisconnect(buffer);
                break;
            }
            case 2: {
                this.log.debug("Received SSH_MSG_IGNORE");
                break;
            }
            case 3: {
                int code = buffer.getInt();
                if (!this.log.isDebugEnabled()) break;
                this.log.debug("Received SSH_MSG_UNIMPLEMENTED #{}", (Object)code);
                break;
            }
            case 4: {
                boolean display = buffer.getBoolean();
                String msg = buffer.getString();
                if (!this.log.isDebugEnabled()) break;
                this.log.debug("Received SSH_MSG_DEBUG (display={}) '{}'", (Object)display, (Object)msg);
                break;
            }
            case 5: {
                this.handleServiceRequest(buffer);
                break;
            }
            case 6: {
                this.handleServiceAccept();
                break;
            }
            case 20: {
                this.handleKexInit(buffer);
                break;
            }
            case 21: {
                this.handleNewKeys(cmd);
                break;
            }
            default: {
                if (cmd >= 30 && cmd <= 49) {
                    this.validateKexState(cmd, KexState.RUN);
                    buffer.rpos(buffer.rpos() - 1);
                    if (!this.kex.next(buffer)) break;
                    this.checkKeys();
                    this.sendNewKeys();
                    this.kexState.set(KexState.KEYS);
                    break;
                }
                if (this.currentService != null) {
                    this.currentService.process(cmd, buffer);
                    this.resetIdleTimeout();
                    break;
                }
                throw new IllegalStateException("Unsupported command " + cmd);
            }
        }
        this.checkRekey();
    }

    private void handleDisconnect(Buffer buffer) {
        int code = buffer.getInt();
        String msg = buffer.getString();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received SSH_MSG_DISCONNECT (reason={}, msg={})", (Object)code, (Object)msg);
        }
        this.close(true);
    }

    private void handleServiceRequest(Buffer buffer) throws IOException {
        String service = buffer.getString();
        this.log.debug("Received SSH_MSG_SERVICE_REQUEST '{}'", (Object)service);
        this.validateKexState(5, KexState.DONE);
        try {
            this.startService(service);
        }
        catch (Exception e) {
            this.log.debug("Service " + service + " rejected", (Throwable)e);
            this.disconnect(7, "Bad service request: " + service);
            return;
        }
        this.log.debug("Accepted service {}", (Object)service);
        Buffer response = this.createBuffer((byte)6);
        response.putString(service);
        this.writePacket(response);
    }

    private void handleServiceAccept() throws IOException {
        this.log.debug("Received SSH_MSG_SERVICE_ACCEPT");
        this.validateKexState(6, KexState.DONE);
        this.serviceAccept();
    }

    private void handleKexInit(Buffer buffer) throws Exception {
        this.log.debug("Received SSH_MSG_KEXINIT");
        this.receiveKexInit(buffer);
        if (this.kexState.compareAndSet(KexState.DONE, KexState.RUN)) {
            this.sendKexInit();
        } else if (!this.kexState.compareAndSet(KexState.INIT, KexState.RUN)) {
            throw new IllegalStateException("Received SSH_MSG_KEXINIT while key exchange is running");
        }
        Map<KexProposalOption, String> result = this.negotiate();
        String kexAlgorithm = result.get((Object)KexProposalOption.ALGORITHMS);
        this.kex = ValidateUtils.checkNotNull(NamedFactory.Utils.create(this.factoryManager.getKeyExchangeFactories(), kexAlgorithm), "Unknown negotiated KEX algorithm: %s", (Object)kexAlgorithm);
        this.kex.init(this, this.serverVersion.getBytes(StandardCharsets.UTF_8), this.clientVersion.getBytes(StandardCharsets.UTF_8), this.i_s, this.i_c);
        this.sendEvent(SessionListener.Event.KexCompleted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNewKeys(int cmd) throws Exception {
        this.log.debug("Received SSH_MSG_NEWKEYS");
        this.validateKexState(cmd, KexState.KEYS);
        this.receiveNewKeys();
        if (this.reexchangeFuture != null) {
            this.reexchangeFuture.setValue(Boolean.TRUE);
        }
        this.sendEvent(SessionListener.Event.KeyEstablished);
        Object object = this.pendingPackets;
        synchronized (object) {
            if (!this.pendingPackets.isEmpty()) {
                this.log.debug("Dequeing pending packets");
                Object object2 = this.encodeLock;
                synchronized (object2) {
                    PendingWriteFuture future;
                    while ((future = this.pendingPackets.poll()) != null) {
                        this.doWritePacket(future.getBuffer()).addListener(future);
                    }
                }
            }
            this.kexState.set(KexState.DONE);
        }
        object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    protected void validateKexState(int cmd, KexState expected) {
        KexState actual = this.kexState.get();
        if (!expected.equals((Object)actual)) {
            throw new IllegalStateException("Received KEX command=" + cmd + " while in state=" + (Object)((Object)actual) + " instead of " + (Object)((Object)expected));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exceptionCaught(Throwable t) {
        int code;
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosing()) {
                return;
            }
        }
        this.log.warn("Exception caught", t);
        if (t instanceof SshException && (code = ((SshException)t).getDisconnectCode()) > 0) {
            block7: {
                try {
                    this.disconnect(code, t.getMessage());
                }
                catch (Throwable t2) {
                    if (!this.log.isDebugEnabled()) break block7;
                    this.log.debug("Exception while disconnect with code=" + code, t2);
                }
            }
            return;
        }
        this.close(true);
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().parallel(this.getServices()).close(this.ioSession).build();
    }

    @Override
    protected void doCloseImmediately() {
        super.doCloseImmediately();
        this.sessionListenerProxy.sessionClosed(this);
    }

    protected Service[] getServices() {
        Service[] serviceArray;
        if (this.currentService != null) {
            Service[] serviceArray2 = new Service[1];
            serviceArray = serviceArray2;
            serviceArray2[0] = this.currentService;
        } else {
            serviceArray = new Service[]{};
        }
        return serviceArray;
    }

    @Override
    public <T extends Service> T getService(Class<T> clazz) {
        for (Service s : this.getServices()) {
            if (!clazz.isInstance(s)) continue;
            return (T)((Service)clazz.cast(s));
        }
        throw new IllegalStateException("Attempted to access unknown service " + clazz.getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoWriteFuture writePacket(Buffer buffer) throws IOException {
        byte cmd;
        if (!KexState.DONE.equals((Object)this.kexState.get()) && (cmd = buffer.array()[buffer.rpos()]) > 49) {
            Queue<PendingWriteFuture> queue = this.pendingPackets;
            synchronized (queue) {
                if (!KexState.DONE.equals((Object)this.kexState.get())) {
                    if (this.pendingPackets.isEmpty()) {
                        this.log.debug("Start flagging packets as pending until key exchange is done");
                    }
                    PendingWriteFuture future = new PendingWriteFuture(buffer);
                    this.pendingPackets.add(future);
                    return future;
                }
            }
        }
        try {
            IoWriteFuture ioWriteFuture = this.doWritePacket(buffer);
            return ioWriteFuture;
        }
        finally {
            this.resetIdleTimeout();
            this.checkRekey();
        }
    }

    @Override
    public IoWriteFuture writePacket(Buffer buffer, final long timeout, final TimeUnit unit) throws IOException {
        IoWriteFuture writeFuture = this.writePacket(buffer);
        final DefaultSshFuture future = (DefaultSshFuture)((Object)writeFuture);
        ScheduledExecutorService executor = this.factoryManager.getScheduledExecutorService();
        final ScheduledFuture<?> sched = executor.schedule(new Runnable(){

            @Override
            public void run() {
                TimeoutException t = new TimeoutException("Timeout writing packet: " + timeout + " " + (Object)((Object)unit));
                AbstractSession.this.log.info(t.getMessage());
                future.setValue(t);
            }
        }, timeout, unit);
        future.addListener(new SshFutureListener<IoWriteFuture>(){

            @Override
            public void operationComplete(IoWriteFuture future) {
                sched.cancel(false);
            }
        });
        return writeFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IoWriteFuture doWritePacket(Buffer buffer) throws IOException {
        Object object = this.encodeLock;
        synchronized (object) {
            this.encode(buffer);
            return this.ioSession.write(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer request(Buffer buffer) throws IOException {
        Object object = this.requestLock;
        synchronized (object) {
            try {
                AtomicReference<Buffer> atomicReference = this.requestResult;
                synchronized (atomicReference) {
                    this.writePacket(buffer);
                    this.requestResult.wait();
                    return this.requestResult.get();
                }
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException("Interrupted while waiting for request result").initCause(e);
            }
        }
    }

    @Override
    public Buffer createBuffer(byte cmd) {
        return this.createBuffer(cmd, 0);
    }

    @Override
    public Buffer createBuffer(byte cmd, int len) {
        ByteArrayBuffer buffer;
        if (len <= 0) {
            buffer = new ByteArrayBuffer();
        } else {
            int bsize = this.outCipherSize;
            int pad = -(len += 5) & bsize - 1;
            if (pad < bsize) {
                pad += bsize;
            }
            len = len + pad - 4;
            if (this.outMac != null) {
                len += this.outMac.getBlockSize();
            }
            buffer = new ByteArrayBuffer(new byte[Math.max(len, 256)], false);
        }
        ((Buffer)buffer).rpos(5);
        ((Buffer)buffer).wpos(5);
        ((Buffer)buffer).putByte(cmd);
        return buffer;
    }

    private void encode(Buffer buffer) throws IOException {
        try {
            if (buffer.rpos() < 5) {
                this.log.warn("Performance cost: when sending a packet, ensure that 5 bytes are available in front of the buffer");
                ByteArrayBuffer nb = new ByteArrayBuffer();
                ((Buffer)nb).wpos(5);
                nb.putBuffer(buffer);
                buffer = nb;
            }
            int len = buffer.available();
            int off = buffer.rpos() - 5;
            if (this.log.isTraceEnabled()) {
                this.log.trace("Sending packet #{}: {}", (Object)this.seqo, (Object)buffer.printHex());
            }
            if (this.outCompression != null && (this.authed || !this.outCompression.isDelayed())) {
                this.outCompression.compress(buffer);
                len = buffer.available();
            }
            int bsize = this.outCipherSize;
            int oldLen = len;
            int pad = -(len += 5) & bsize - 1;
            if (pad < bsize) {
                pad += bsize;
            }
            len = len + pad - 4;
            buffer.wpos(off);
            buffer.putInt(len);
            buffer.putByte((byte)pad);
            buffer.wpos(off + oldLen + 5 + pad);
            this.random.fill(buffer.array(), buffer.wpos() - pad, pad);
            if (this.outMac != null) {
                int macSize = this.outMac.getBlockSize();
                int l = buffer.wpos();
                buffer.wpos(l + macSize);
                this.outMac.updateUInt(this.seqo);
                this.outMac.update(buffer.array(), off, l);
                this.outMac.doFinal(buffer.array(), l);
            }
            if (this.outCipher != null) {
                this.outCipher.update(buffer.array(), off, len + 4);
            }
            this.seqo = this.seqo + 1L & 0xFFFFFFFFL;
            this.outPacketsCount.incrementAndGet();
            this.outBytesCount.addAndGet(len);
            buffer.rpos(off);
        }
        catch (SshException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SshException(e);
        }
    }

    protected void decode() throws Exception {
        while (true) {
            Buffer buf;
            int macSize;
            if (this.decoderState == 0) {
                assert (this.decoderBuffer.rpos() == 0);
                if (this.decoderBuffer.available() <= this.inCipherSize) break;
                if (this.inCipher != null) {
                    this.inCipher.update(this.decoderBuffer.array(), 0, this.inCipherSize);
                }
                this.decoderLength = this.decoderBuffer.getInt();
                if (this.decoderLength < 5 || this.decoderLength > 262144) {
                    this.log.warn("Error decoding packet (invalid length) {}", (Object)this.decoderBuffer.printHex());
                    throw new SshException(2, "Invalid packet length: " + this.decoderLength);
                }
                this.decoderState = 1;
                continue;
            }
            if (this.decoderState != 1) continue;
            assert (this.decoderBuffer.rpos() == 4);
            int n = macSize = this.inMac != null ? this.inMac.getBlockSize() : 0;
            if (this.decoderBuffer.available() < this.decoderLength + macSize) break;
            byte[] data = this.decoderBuffer.array();
            if (this.inCipher != null) {
                this.inCipher.update(data, this.inCipherSize, this.decoderLength + 4 - this.inCipherSize);
            }
            if (this.inMac != null) {
                this.inMac.updateUInt(this.seqi);
                this.inMac.update(data, 0, this.decoderLength + 4);
                this.inMac.doFinal(this.inMacResult, 0);
                if (!BufferUtils.equals(this.inMacResult, 0, data, this.decoderLength + 4, macSize)) {
                    throw new SshException(5, "MAC Error");
                }
            }
            this.seqi = this.seqi + 1L & 0xFFFFFFFFL;
            int pad = this.decoderBuffer.getUByte();
            int wpos = this.decoderBuffer.wpos();
            if (this.inCompression != null && (this.authed || !this.inCompression.isDelayed())) {
                if (this.uncompressBuffer == null) {
                    this.uncompressBuffer = new ByteArrayBuffer();
                } else {
                    this.uncompressBuffer.clear();
                }
                this.decoderBuffer.wpos(this.decoderBuffer.rpos() + this.decoderLength - 1 - pad);
                this.inCompression.uncompress(this.decoderBuffer, this.uncompressBuffer);
                buf = this.uncompressBuffer;
            } else {
                this.decoderBuffer.wpos(this.decoderLength + 4 - pad);
                buf = this.decoderBuffer;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Received packet #{}: {}", (Object)this.seqi, (Object)buf.printHex());
            }
            this.inPacketsCount.incrementAndGet();
            this.inBytesCount.addAndGet(buf.available());
            this.handleMessage(buf);
            this.decoderBuffer.rpos(this.decoderLength + 4 + macSize);
            this.decoderBuffer.wpos(wpos);
            this.decoderBuffer.compact();
            this.decoderState = 0;
        }
    }

    protected void sendIdentification(String ident) {
        this.log.debug("Send identification: {}", (Object)ident);
        byte[] data = (ident + "\r\n").getBytes(StandardCharsets.UTF_8);
        this.ioSession.write(new ByteArrayBuffer(data));
    }

    protected abstract boolean readIdentification(Buffer var1) throws IOException;

    protected String doReadIdentification(Buffer buffer, boolean server) {
        byte[] data = new byte[256];
        do {
            int rpos = buffer.rpos();
            int pos = 0;
            boolean needLf = false;
            while (true) {
                if (buffer.available() == 0) {
                    buffer.rpos(rpos);
                    return null;
                }
                byte b = buffer.getByte();
                if (b == 13) {
                    needLf = true;
                    continue;
                }
                if (b == 10) break;
                if (needLf) {
                    throw new IllegalStateException("Incorrect identification: bad line ending");
                }
                if (pos >= data.length) {
                    throw new IllegalStateException("Incorrect identification: line too long");
                }
                data[pos++] = b;
            }
            String str = new String(data, 0, pos);
            if (!server && !str.startsWith("SSH-")) continue;
            return str;
        } while (buffer.rpos() <= 16384);
        throw new IllegalStateException("Incorrect identification: too many header lines");
    }

    protected Map<KexProposalOption, String> createProposal(String hostKeyTypes) {
        EnumMap<KexProposalOption, String> proposal = new EnumMap<KexProposalOption, String>(KexProposalOption.class);
        proposal.put(KexProposalOption.ALGORITHMS, NamedResource.Utils.getNames(this.factoryManager.getKeyExchangeFactories()));
        proposal.put(KexProposalOption.SERVERKEYS, hostKeyTypes);
        String ciphers = NamedResource.Utils.getNames(this.factoryManager.getCipherFactories());
        proposal.put(KexProposalOption.S2CENC, ciphers);
        proposal.put(KexProposalOption.C2SENC, ciphers);
        String macs = NamedResource.Utils.getNames(this.factoryManager.getMacFactories());
        proposal.put(KexProposalOption.S2CMAC, macs);
        proposal.put(KexProposalOption.C2SMAC, macs);
        String compressions = NamedResource.Utils.getNames(this.factoryManager.getCompressionFactories());
        proposal.put(KexProposalOption.S2CCOMP, compressions);
        proposal.put(KexProposalOption.C2SCOMP, compressions);
        proposal.put(KexProposalOption.S2CLANG, "");
        proposal.put(KexProposalOption.C2SLANG, "");
        return proposal;
    }

    protected byte[] sendKexInit(Map<KexProposalOption, String> proposal) throws IOException {
        this.log.debug("Send SSH_MSG_KEXINIT");
        Buffer buffer = this.createBuffer((byte)20);
        int p = buffer.wpos();
        buffer.wpos(p + 16);
        this.random.fill(buffer.array(), p, 16);
        if (this.log.isTraceEnabled()) {
            this.log.trace("sendKexInit(" + this.toString() + ") cookie=" + BufferUtils.printHex(buffer.array(), p, 16, ':'));
        }
        for (KexProposalOption paramType : KexProposalOption.VALUES) {
            String s = proposal.get((Object)paramType);
            if (this.log.isTraceEnabled()) {
                this.log.trace("sendKexInit(" + this.toString() + ")[" + paramType.getDescription() + "] " + s);
            }
            buffer.putString(GenericUtils.trimToEmpty(s));
        }
        buffer.putBoolean(false);
        buffer.putInt(0L);
        byte[] data = buffer.getCompactData();
        this.writePacket(buffer);
        return data;
    }

    protected byte[] receiveKexInit(Buffer buffer, Map<KexProposalOption, String> proposal) {
        long reserved;
        byte[] d = buffer.array();
        byte[] data = new byte[buffer.available() + 1];
        data[0] = 20;
        int size = 6;
        int cookieStartPos = buffer.rpos();
        System.arraycopy(d, cookieStartPos, data, 1, data.length - 1);
        buffer.rpos(cookieStartPos + 16);
        size += 16;
        if (this.log.isTraceEnabled()) {
            this.log.trace("receiveKexInit(" + this.toString() + ") cookie=" + BufferUtils.printHex(d, cookieStartPos, 16, ':'));
        }
        for (KexProposalOption paramType : KexProposalOption.VALUES) {
            int lastPos = buffer.rpos();
            String value = buffer.getString();
            if (this.log.isTraceEnabled()) {
                this.log.trace("receiveKexInit(" + this.toString() + ")[" + paramType.getDescription() + "] " + value);
            }
            int curPos = buffer.rpos();
            int readLen = curPos - lastPos;
            proposal.put(paramType, value);
            size += readLen;
        }
        boolean firstKexPacketFollows = buffer.getBoolean();
        if (this.log.isTraceEnabled()) {
            this.log.trace("receiveKexInit(" + this.toString() + ") first kex packet follows: " + firstKexPacketFollows);
        }
        if ((reserved = buffer.getUInt()) != 0L && this.log.isTraceEnabled()) {
            this.log.trace("receiveKexInit(" + this.toString() + ") non-zero reserved value: " + reserved);
        }
        byte[] dataShrinked = new byte[size];
        System.arraycopy(data, 0, dataShrinked, 0, size);
        return dataShrinked;
    }

    protected void sendNewKeys() throws IOException {
        this.log.debug("Send SSH_MSG_NEWKEYS");
        Buffer buffer = this.createBuffer((byte)21);
        this.writePacket(buffer);
    }

    protected void receiveNewKeys() throws Exception {
        int j;
        byte[] k = this.kex.getK();
        byte[] h = this.kex.getH();
        Digest hash = this.kex.getHash();
        if (this.sessionId == null) {
            this.sessionId = new byte[h.length];
            System.arraycopy(h, 0, this.sessionId, 0, h.length);
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer();
        buffer.putMPInt(k);
        buffer.putRawBytes(h);
        ((Buffer)buffer).putByte((byte)65);
        buffer.putRawBytes(this.sessionId);
        int pos = buffer.available();
        byte[] buf = ((Buffer)buffer).array();
        hash.update(buf, 0, pos);
        byte[] iv_c2s = hash.digest();
        int n = j = pos - this.sessionId.length - 1;
        buf[n] = (byte)(buf[n] + 1);
        hash.update(buf, 0, pos);
        byte[] iv_s2c = hash.digest();
        int n2 = j;
        buf[n2] = (byte)(buf[n2] + 1);
        hash.update(buf, 0, pos);
        byte[] e_c2s = hash.digest();
        int n3 = j;
        buf[n3] = (byte)(buf[n3] + 1);
        hash.update(buf, 0, pos);
        byte[] e_s2c = hash.digest();
        int n4 = j;
        buf[n4] = (byte)(buf[n4] + 1);
        hash.update(buf, 0, pos);
        byte[] mac_c2s = hash.digest();
        int n5 = j;
        buf[n5] = (byte)(buf[n5] + 1);
        hash.update(buf, 0, pos);
        byte[] mac_s2c = hash.digest();
        String value = this.getNegotiatedKexParameter(KexProposalOption.S2CENC);
        Cipher s2ccipher = ValidateUtils.checkNotNull(NamedFactory.Utils.create(this.factoryManager.getCipherFactories(), value), "Unknown s2c cipher: %s", (Object)value);
        e_s2c = this.resizeKey(e_s2c, s2ccipher.getBlockSize(), hash, k, h);
        s2ccipher.init(this.isServer ? Cipher.Mode.Encrypt : Cipher.Mode.Decrypt, e_s2c, iv_s2c);
        value = this.getNegotiatedKexParameter(KexProposalOption.S2CMAC);
        Mac s2cmac = ValidateUtils.checkNotNull(NamedFactory.Utils.create(this.factoryManager.getMacFactories(), value), "Unknown s2c mac: %s", (Object)value);
        mac_s2c = this.resizeKey(mac_s2c, s2cmac.getBlockSize(), hash, k, h);
        s2cmac.init(mac_s2c);
        value = this.getNegotiatedKexParameter(KexProposalOption.S2CCOMP);
        Compression s2ccomp = NamedFactory.Utils.create(this.factoryManager.getCompressionFactories(), value);
        value = this.getNegotiatedKexParameter(KexProposalOption.C2SENC);
        Cipher c2scipher = ValidateUtils.checkNotNull(NamedFactory.Utils.create(this.factoryManager.getCipherFactories(), value), "Unknown c2s cipher: %s", (Object)value);
        e_c2s = this.resizeKey(e_c2s, c2scipher.getBlockSize(), hash, k, h);
        c2scipher.init(this.isServer ? Cipher.Mode.Decrypt : Cipher.Mode.Encrypt, e_c2s, iv_c2s);
        value = this.getNegotiatedKexParameter(KexProposalOption.C2SMAC);
        Mac c2smac = ValidateUtils.checkNotNull(NamedFactory.Utils.create(this.factoryManager.getMacFactories(), value), "Unknown c2s mac: %s", (Object)value);
        mac_c2s = this.resizeKey(mac_c2s, c2smac.getBlockSize(), hash, k, h);
        c2smac.init(mac_c2s);
        value = this.getNegotiatedKexParameter(KexProposalOption.C2SCOMP);
        Compression c2scomp = NamedFactory.Utils.create(this.factoryManager.getCompressionFactories(), value);
        if (this.isServer) {
            this.outCipher = s2ccipher;
            this.outMac = s2cmac;
            this.outCompression = s2ccomp;
            this.inCipher = c2scipher;
            this.inMac = c2smac;
            this.inCompression = c2scomp;
        } else {
            this.outCipher = c2scipher;
            this.outMac = c2smac;
            this.outCompression = c2scomp;
            this.inCipher = s2ccipher;
            this.inMac = s2cmac;
            this.inCompression = s2ccomp;
        }
        this.outCipherSize = this.outCipher.getIVSize();
        if (this.outCompression != null) {
            this.outCompression.init(Compression.Type.Deflater, -1);
        }
        this.inCipherSize = this.inCipher.getIVSize();
        this.inMacResult = new byte[this.inMac.getBlockSize()];
        if (this.inCompression != null) {
            this.inCompression.init(Compression.Type.Inflater, -1);
        }
        this.inBytesCount.set(0L);
        this.outBytesCount.set(0L);
        this.inPacketsCount.set(0L);
        this.outPacketsCount.set(0L);
        this.lastKeyTimeValue.set(System.currentTimeMillis());
    }

    private byte[] resizeKey(byte[] e, int blockSize, Digest hash, byte[] k, byte[] h) throws Exception {
        while (blockSize > e.length) {
            ByteArrayBuffer buffer = new ByteArrayBuffer();
            buffer.putMPInt(k);
            buffer.putRawBytes(h);
            buffer.putRawBytes(e);
            hash.update(((Buffer)buffer).array(), 0, buffer.available());
            byte[] foo = hash.digest();
            byte[] bar = new byte[e.length + foo.length];
            System.arraycopy(e, 0, bar, 0, e.length);
            System.arraycopy(foo, 0, bar, e.length, foo.length);
            e = bar;
        }
        return e;
    }

    @Override
    public void disconnect(int reason, String msg) throws IOException {
        this.log.info("Disconnecting: {} - {}", (Object)reason, (Object)msg);
        Buffer buffer = this.createBuffer((byte)1);
        buffer.putInt(reason);
        buffer.putString(msg);
        buffer.putString("");
        this.writePacket(buffer, this.disconnectTimeoutMs, TimeUnit.MILLISECONDS).addListener(new SshFutureListener<IoWriteFuture>(){

            @Override
            public void operationComplete(IoWriteFuture future) {
                AbstractSession.this.close(true);
            }
        });
    }

    protected void notImplemented() throws IOException {
        Buffer buffer = this.createBuffer((byte)3);
        buffer.putInt(this.seqi - 1L);
        this.writePacket(buffer);
    }

    protected Map<KexProposalOption, String> negotiate() {
        EnumMap<KexProposalOption, String> guess = new EnumMap<KexProposalOption, String>(KexProposalOption.class);
        for (KexProposalOption paramType : KexProposalOption.VALUES) {
            String value;
            String clientParamValue = this.clientProposal.get((Object)paramType);
            String serverParamValue = this.serverProposal.get((Object)paramType);
            String[] c = GenericUtils.split(clientParamValue, ',');
            String[] s = GenericUtils.split(serverParamValue, ',');
            for (String ci : c) {
                String value2;
                for (String si : s) {
                    if (!ci.equals(si)) continue;
                    guess.put(paramType, ci);
                    break;
                }
                if ((value2 = (String)guess.get((Object)paramType)) != null) break;
            }
            if ((value = (String)guess.get((Object)paramType)) == null) {
                String message = "Unable to negotiate key exchange for " + paramType.getDescription() + " (client: " + clientParamValue + " / server: " + serverParamValue + ")";
                if (KexProposalOption.S2CLANG.equals((Object)paramType) || KexProposalOption.C2SLANG.equals((Object)paramType)) {
                    if (!this.log.isTraceEnabled()) continue;
                    this.log.trace(message);
                    continue;
                }
                throw new IllegalStateException(message);
            }
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace("Kex: negotiate(" + paramType.getDescription() + ") guess=" + value + " (client: " + clientParamValue + " / server: " + serverParamValue + ")");
        }
        return this.setNegotiationResult(guess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<KexProposalOption, String> setNegotiationResult(Map<KexProposalOption, String> guess) {
        Map<KexProposalOption, String> map = this.negotiationResult;
        synchronized (map) {
            if (!this.negotiationResult.isEmpty()) {
                this.negotiationResult.clear();
            }
            this.negotiationResult.putAll(guess);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Kex: server->client {} {} {}", new Object[]{guess.get((Object)KexProposalOption.S2CENC), guess.get((Object)KexProposalOption.S2CMAC), guess.get((Object)KexProposalOption.S2CCOMP)});
            this.log.debug("Kex: client->server {} {} {}", new Object[]{guess.get((Object)KexProposalOption.C2SENC), guess.get((Object)KexProposalOption.C2SMAC), guess.get((Object)KexProposalOption.C2SCOMP)});
        }
        return guess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestSuccess(Buffer buffer) throws Exception {
        AtomicReference<Buffer> atomicReference = this.requestResult;
        synchronized (atomicReference) {
            this.requestResult.set(new ByteArrayBuffer(buffer.getCompactData()));
            this.resetIdleTimeout();
            this.requestResult.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestFailure(Buffer buffer) throws Exception {
        AtomicReference<Buffer> atomicReference = this.requestResult;
        synchronized (atomicReference) {
            this.requestResult.set(null);
            this.resetIdleTimeout();
            this.requestResult.notify();
        }
    }

    @Override
    public int getIntProperty(String name, int defaultValue) {
        try {
            return FactoryManagerUtils.getIntProperty(this.factoryManager, name, defaultValue);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("getIntProperty(" + name + ") failed (" + e.getClass().getSimpleName() + ") to retrieve: " + e.getMessage());
            }
            return defaultValue;
        }
    }

    public long getLongProperty(String name, long defaultValue) {
        try {
            return FactoryManagerUtils.getLongProperty(this.factoryManager, name, defaultValue);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("getLongProperty(" + name + ") failed (" + e.getClass().getSimpleName() + ") to retrieve: " + e.getMessage());
            }
            return defaultValue;
        }
    }

    @Override
    public <T> T getAttribute(Session.AttributeKey<T> key) {
        return (T)this.attributes.get(key);
    }

    @Override
    public <T, E extends T> T setAttribute(Session.AttributeKey<T> key, E value) {
        return (T)this.attributes.put(key, value);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    public Object getLock() {
        return this.lock;
    }

    @Override
    public void addListener(SessionListener listener) {
        ValidateUtils.checkNotNull(listener, "addListener(%s) null instance", (Object)this);
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(SessionListener listener) {
        this.listeners.remove(listener);
    }

    protected void sendEvent(SessionListener.Event event) throws IOException {
        this.sessionListenerProxy.sessionEvent(this, event);
    }

    @Override
    public SshFuture reExchangeKeys() throws IOException {
        if (this.kexState.compareAndSet(KexState.DONE, KexState.INIT)) {
            this.log.info("Initiating key re-exchange");
            this.sendKexInit();
            this.reexchangeFuture = new DefaultSshFuture((Object)null);
        }
        return this.reexchangeFuture;
    }

    protected void checkRekey() throws IOException {
    }

    protected byte[] sendKexInit() throws IOException {
        String resolvedAlgorithms = this.resolveAvailableSignaturesProposal();
        if (GenericUtils.isEmpty(resolvedAlgorithms)) {
            throw new SshException(9, "sendKexInit() no resolved signatures available");
        }
        Map<KexProposalOption, String> proposal = this.createProposal(resolvedAlgorithms);
        byte[] seed = this.sendKexInit(proposal);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendKexInit(" + proposal + ") seed: " + BufferUtils.printHex(':', seed));
        }
        this.setKexSeed(seed);
        return seed;
    }

    protected abstract void setKexSeed(byte ... var1);

    protected String resolveAvailableSignaturesProposal() {
        return this.resolveAvailableSignaturesProposal(this.getFactoryManager());
    }

    protected abstract String resolveAvailableSignaturesProposal(FactoryManager var1);

    protected abstract void checkKeys() throws IOException;

    protected void receiveKexInit(Buffer buffer) throws IOException {
        EnumMap<KexProposalOption, String> proposal = new EnumMap<KexProposalOption, String>(KexProposalOption.class);
        byte[] seed = this.receiveKexInit(buffer, proposal);
        this.receiveKexInit(proposal, seed);
    }

    protected abstract void receiveKexInit(Map<KexProposalOption, String> var1, byte[] var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<KexProposalOption, String> mergeProposals(Map<KexProposalOption, String> current, Map<KexProposalOption, String> proposal) {
        if (current == proposal) {
            return proposal;
        }
        Map<KexProposalOption, String> map = current;
        synchronized (map) {
            if (!current.isEmpty()) {
                current.clear();
            }
            if (GenericUtils.isEmpty(proposal)) {
                return proposal;
            }
            current.putAll(proposal);
        }
        return proposal;
    }

    protected void serviceAccept() throws IOException {
    }

    protected void checkForTimeouts() throws IOException {
        if (!this.isClosing()) {
            long now = System.currentTimeMillis();
            if (!this.authed && this.authTimeoutMs > 0L && now > this.authTimeoutTimestamp) {
                this.timeoutStatus.set(Session.TimeoutStatus.AuthTimeout);
                this.disconnect(2, "Session has timed out waiting for authentication after " + this.authTimeoutMs + " ms.");
            }
            if (this.idleTimeoutMs > 0L && this.idleTimeoutTimestamp > 0L && now > this.idleTimeoutTimestamp) {
                this.timeoutStatus.set(Session.TimeoutStatus.AuthTimeout);
                this.disconnect(2, "User session has timed out idling after " + this.idleTimeoutMs + " ms.");
            }
        }
    }

    @Override
    public void resetIdleTimeout() {
        this.idleTimeoutTimestamp = System.currentTimeMillis() + this.idleTimeoutMs;
    }

    @Override
    public Session.TimeoutStatus getTimeoutStatus() {
        return this.timeoutStatus.get();
    }

    @Override
    public long getAuthTimeout() {
        return this.authTimeoutMs;
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeoutMs;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getUsername() + "@" + this.getIoSession().getRemoteAddress() + "]";
    }
}

