/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.compression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.compression.Compression;
import org.apache.sshd.common.compression.CompressionDelayedZlib;
import org.apache.sshd.common.compression.CompressionFactory;
import org.apache.sshd.common.compression.CompressionZlib;
import org.apache.sshd.common.config.NamedFactoriesListParseResult;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public enum BuiltinCompressions implements CompressionFactory
{
    none("none"){

        @Override
        public Compression create() {
            return null;
        }
    }
    ,
    zlib("zlib"){

        @Override
        public Compression create() {
            return new CompressionZlib();
        }
    }
    ,
    delayedZlib("zlib@openssh.com"){

        @Override
        public Compression create() {
            return new CompressionDelayedZlib();
        }
    };

    public static final Set<BuiltinCompressions> VALUES;
    private static final Map<String, CompressionFactory> EXTENSIONS;
    private final String name;

    private BuiltinCompressions(String n2) {
        this.name = n2;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final String toString() {
        return this.getName();
    }

    @Override
    public final boolean isSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerExtension(CompressionFactory extension) {
        String name = ValidateUtils.checkNotNull(extension, "No extension provided").getName();
        ValidateUtils.checkTrue(BuiltinCompressions.fromFactoryName(name) == null, "Extension overrides built-in: %s", (Object)name);
        Map<String, CompressionFactory> map = EXTENSIONS;
        synchronized (map) {
            ValidateUtils.checkTrue(!EXTENSIONS.containsKey(name), "Extension overrides existing: %s", (Object)name);
            EXTENSIONS.put(name, extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SortedSet<CompressionFactory> getRegisteredExtensions() {
        Map<String, CompressionFactory> map = EXTENSIONS;
        synchronized (map) {
            return GenericUtils.asSortedSet(NamedResource.BY_NAME_COMPARATOR, EXTENSIONS.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompressionFactory unregisterExtension(String name) {
        if (GenericUtils.isEmpty(name)) {
            return null;
        }
        Map<String, CompressionFactory> map = EXTENSIONS;
        synchronized (map) {
            return EXTENSIONS.remove(name);
        }
    }

    public static BuiltinCompressions fromFactoryName(String name) {
        return NamedResource.Utils.findByName(name, String.CASE_INSENSITIVE_ORDER, VALUES);
    }

    public static ParseResult parseCompressionsList(String compressions) {
        return BuiltinCompressions.parseCompressionsList(GenericUtils.split(compressions, ','));
    }

    public static ParseResult parseCompressionsList(String ... compressions) {
        return BuiltinCompressions.parseCompressionsList(GenericUtils.isEmpty((Object[])compressions) ? Collections.emptyList() : Arrays.asList(compressions));
    }

    public static ParseResult parseCompressionsList(Collection<String> compressions) {
        if (GenericUtils.isEmpty(compressions)) {
            return ParseResult.EMPTY;
        }
        ArrayList<CompressionFactory> factories = new ArrayList<CompressionFactory>(compressions.size());
        List<String> unknown = Collections.emptyList();
        for (String name : compressions) {
            CompressionFactory c = BuiltinCompressions.resolveFactory(name);
            if (c != null) {
                factories.add(c);
                continue;
            }
            if (unknown.isEmpty()) {
                unknown = new ArrayList<String>();
            }
            unknown.add(name);
        }
        return new ParseResult((List<CompressionFactory>)factories, unknown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompressionFactory resolveFactory(String name) {
        if (GenericUtils.isEmpty(name)) {
            return null;
        }
        BuiltinCompressions c = BuiltinCompressions.fromFactoryName(name);
        if (c != null) {
            return c;
        }
        Map<String, CompressionFactory> map = EXTENSIONS;
        synchronized (map) {
            return EXTENSIONS.get(name);
        }
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(BuiltinCompressions.class));
        EXTENSIONS = new TreeMap<String, CompressionFactory>(String.CASE_INSENSITIVE_ORDER);
    }

    public static class Constants {
        public static final String NONE = "none";
        public static final String ZLIB = "zlib";
        public static final String DELAYED_ZLIB = "zlib@openssh.com";
    }

    public static class ParseResult
    extends NamedFactoriesListParseResult<Compression, CompressionFactory> {
        public static final ParseResult EMPTY = new ParseResult(Collections.emptyList(), Collections.emptyList());

        public ParseResult(List<CompressionFactory> parsed, List<String> unsupported) {
            super(parsed, unsupported);
        }
    }
}

