/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import org.apache.sshd.common.util.io.IoUtils;

public interface FileInfoExtractor<T> {
    public static final FileInfoExtractor<Boolean> EXISTS = new FileInfoExtractor<Boolean>(){

        @Override
        public Boolean infoOf(Path file, LinkOption ... options) throws IOException {
            return Files.exists(file, options);
        }
    };
    public static final FileInfoExtractor<Boolean> ISDIR = new FileInfoExtractor<Boolean>(){

        @Override
        public Boolean infoOf(Path file, LinkOption ... options) throws IOException {
            return Files.isDirectory(file, options);
        }
    };
    public static final FileInfoExtractor<Boolean> ISREG = new FileInfoExtractor<Boolean>(){

        @Override
        public Boolean infoOf(Path file, LinkOption ... options) throws IOException {
            return Files.isRegularFile(file, options);
        }
    };
    public static final FileInfoExtractor<Boolean> ISSYMLINK = new FileInfoExtractor<Boolean>(){

        @Override
        public Boolean infoOf(Path file, LinkOption ... options) throws IOException {
            return Files.isSymbolicLink(file);
        }
    };
    public static final FileInfoExtractor<Long> SIZE = new FileInfoExtractor<Long>(){

        @Override
        public Long infoOf(Path file, LinkOption ... options) throws IOException {
            return Files.size(file);
        }
    };
    public static final FileInfoExtractor<Set<PosixFilePermission>> PERMISSIONS = new FileInfoExtractor<Set<PosixFilePermission>>(){

        @Override
        public Set<PosixFilePermission> infoOf(Path file, LinkOption ... options) throws IOException {
            return IoUtils.getPermissions(file, options);
        }
    };
    public static final FileInfoExtractor<FileTime> LASTMODIFIED = new FileInfoExtractor<FileTime>(){

        @Override
        public FileTime infoOf(Path file, LinkOption ... options) throws IOException {
            return Files.getLastModifiedTime(file, options);
        }
    };

    public T infoOf(Path var1, LinkOption ... var2) throws IOException;
}

