/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class ModifiableFileWatcher
extends AbstractLoggingBean {
    protected final LinkOption[] options;
    private final Path file;
    private final AtomicBoolean lastExisted = new AtomicBoolean(false);
    private final AtomicLong lastSize = new AtomicLong(Long.MIN_VALUE);
    private final AtomicLong lastModified = new AtomicLong(-1L);

    public ModifiableFileWatcher(File file) {
        this(ValidateUtils.checkNotNull(file, "No file to watch").toPath());
    }

    public ModifiableFileWatcher(Path file) {
        this(file, IoUtils.getLinkOptions(false));
    }

    public ModifiableFileWatcher(Path file, LinkOption ... options) {
        this.file = ValidateUtils.checkNotNull(file, "No path to watch");
        this.options = options == null ? IoUtils.EMPTY_LINK_OPTIONS : (LinkOption[])options.clone();
    }

    public final Path getPath() {
        return this.file;
    }

    public final boolean exists() throws IOException {
        return Files.exists(this.getPath(), this.options);
    }

    public final long size() throws IOException {
        if (this.exists()) {
            return Files.size(this.getPath());
        }
        return -1L;
    }

    public final FileTime lastModified() throws IOException {
        if (this.exists()) {
            BasicFileAttributes attrs = Files.readAttributes(this.getPath(), BasicFileAttributes.class, this.options);
            return attrs.lastModifiedTime();
        }
        return null;
    }

    public boolean checkReloadRequired() throws IOException {
        boolean exists = this.exists();
        if (exists != this.lastExisted.getAndSet(exists)) {
            return true;
        }
        if (!exists) {
            this.resetReloadAttributes();
            return false;
        }
        long size = this.size();
        if (size < 0L) {
            this.resetReloadAttributes();
            return true;
        }
        if (size != this.lastSize.getAndSet(size)) {
            return true;
        }
        FileTime modifiedTime = this.lastModified();
        if (modifiedTime == null) {
            this.resetReloadAttributes();
            return true;
        }
        long timestamp = modifiedTime.toMillis();
        return timestamp != this.lastModified.getAndSet(timestamp);
    }

    public void resetReloadAttributes() {
        this.lastExisted.set(false);
        this.lastSize.set(Long.MIN_VALUE);
        this.lastModified.set(-1L);
    }

    public void updateReloadAttributes() throws IOException {
        if (this.exists()) {
            long size = this.size();
            FileTime modifiedTime = this.lastModified();
            if (size >= 0L && modifiedTime != null) {
                this.lastExisted.set(true);
                this.lastSize.set(size);
                this.lastModified.set(modifiedTime.toMillis());
                return;
            }
        }
        this.resetReloadAttributes();
    }
}

