/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.file.FileSystem;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.ServerKeyVerifier;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.auth.UserInteraction;
import org.apache.sshd.client.channel.ChannelDirectTcpip;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.channel.ChannelSubsystem;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.DefaultAuthFuture;
import org.apache.sshd.client.scp.DefaultScpClient;
import org.apache.sshd.client.scp.ScpClient;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientUserAuthService;
import org.apache.sshd.client.subsystem.sftp.DefaultSftpClient;
import org.apache.sshd.client.subsystem.sftp.SftpClient;
import org.apache.sshd.client.subsystem.sftp.SftpFileSystem;
import org.apache.sshd.client.subsystem.sftp.SftpFileSystemProvider;
import org.apache.sshd.client.subsystem.sftp.SftpVersionSelector;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.ServiceFactory;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.SshdSocketAddress;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.cipher.CipherNone;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.KexState;
import org.apache.sshd.common.scp.ScpTransferEventListener;
import org.apache.sshd.common.session.AbstractConnectionService;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;

public class ClientSessionImpl
extends AbstractSession
implements ClientSession {
    public static final Comparator<Object> PASSWORD_IDENTITY_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof String) || !(o2 instanceof String)) {
                return -1;
            }
            return ((String)o1).compareTo((String)o2);
        }
    };
    public static final Comparator<Object> KEYPAIR_IDENTITY_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof KeyPair) || !(o2 instanceof KeyPair)) {
                return -1;
            }
            if (KeyUtils.compareKeyPairs((KeyPair)o1, (KeyPair)o2)) {
                return 0;
            }
            return 1;
        }
    };
    protected AuthFuture authFuture;
    private Map<Object, Object> metadataMap = new HashMap<Object, Object>();
    private boolean initialServiceRequestSent;
    private ServiceFactory currentServiceFactory;
    private Service nextService;
    private ServiceFactory nextServiceFactory;
    private final List<Object> identities = new ArrayList<Object>();
    private UserInteraction userInteraction;
    private ScpTransferEventListener scpListener;

    public ClientSessionImpl(ClientFactoryManager client, IoSession session) throws Exception {
        super(false, client, session);
        this.log.debug("Client session created: {}", (Object)session);
        List<ServiceFactory> factories = client.getServiceFactories();
        if (GenericUtils.isEmpty(factories) || factories.size() > 2) {
            throw new IllegalArgumentException("One or two services must be configured");
        }
        this.currentServiceFactory = factories.get(0);
        this.currentService = this.currentServiceFactory.create(this);
        if (factories.size() > 1) {
            this.nextServiceFactory = factories.get(1);
            this.nextService = this.nextServiceFactory.create(this);
        } else {
            this.nextServiceFactory = null;
        }
        this.authFuture = new DefaultAuthFuture(this.lock);
        this.authFuture.setAuthed(false);
        this.sendClientIdentification();
        this.kexState.set(KexState.INIT);
        this.sendKexInit();
    }

    @Override
    protected Service[] getServices() {
        Service[] services = this.nextService != null ? new Service[]{this.currentService, this.nextService} : (this.currentService != null ? new Service[]{this.currentService} : new Service[]{});
        return services;
    }

    @Override
    public ClientFactoryManager getFactoryManager() {
        return (ClientFactoryManager)this.factoryManager;
    }

    @Override
    public void addPasswordIdentity(String password) {
        this.identities.add(ValidateUtils.checkNotNullAndNotEmpty(password, "No password provided"));
        if (this.log.isDebugEnabled()) {
            this.log.debug("addPasswordIdentity(" + KeyUtils.getFingerPrint(password) + ")");
        }
    }

    @Override
    public String removePasswordIdentity(String password) {
        if (GenericUtils.isEmpty(password)) {
            return null;
        }
        int index = this.findIdentityIndex(PASSWORD_IDENTITY_COMPARATOR, password);
        if (index >= 0) {
            return (String)this.identities.remove(index);
        }
        return null;
    }

    @Override
    public void addPublicKeyIdentity(KeyPair kp) {
        ValidateUtils.checkNotNull(kp, "No key-pair to add");
        ValidateUtils.checkNotNull(kp.getPublic(), "No public key");
        ValidateUtils.checkNotNull(kp.getPrivate(), "No private key");
        this.identities.add(kp);
        if (this.log.isDebugEnabled()) {
            this.log.debug("addPublicKeyIdentity(" + KeyUtils.getFingerPrint(kp.getPublic()) + ")");
        }
    }

    @Override
    public KeyPair removePublicKeyIdentity(KeyPair kp) {
        if (kp == null) {
            return null;
        }
        int index = this.findIdentityIndex(KEYPAIR_IDENTITY_COMPARATOR, kp);
        if (index >= 0) {
            return (KeyPair)this.identities.remove(index);
        }
        return null;
    }

    protected int findIdentityIndex(Comparator<? super Object> comp, Object target) {
        for (int index = 0; index < this.identities.size(); ++index) {
            Object value = this.identities.get(index);
            if (comp.compare(value, target) != 0) continue;
            return index;
        }
        return -1;
    }

    @Override
    public UserInteraction getUserInteraction() {
        return this.userInteraction;
    }

    @Override
    public void setUserInteraction(UserInteraction userInteraction) {
        this.userInteraction = userInteraction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthFuture auth() throws IOException {
        if (this.username == null) {
            throw new IllegalStateException("No username specified when the session was created");
        }
        ClientUserAuthService authService = this.getUserAuthService();
        Object object = this.lock;
        synchronized (object) {
            this.authFuture = authService.auth(this.identities, this.nextServiceName());
            return this.authFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String nextServiceName() {
        Object object = this.lock;
        synchronized (object) {
            return this.nextServiceFactory.getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchToNextService() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.nextService == null) {
                throw new IllegalStateException("No service available");
            }
            this.currentServiceFactory = this.nextServiceFactory;
            this.currentService = this.nextService;
            this.nextServiceFactory = null;
            this.nextService = null;
            this.currentService.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SshFuture switchToNoneCipher() throws IOException {
        if (!(this.currentService instanceof AbstractConnectionService) || !((AbstractConnectionService)this.currentService).getChannels().isEmpty()) {
            throw new IllegalStateException("The switch to the none cipher must be done immediately after authentication");
        }
        if (this.kexState.compareAndSet(KexState.DONE, KexState.INIT)) {
            String s2cEncClient;
            String c2sEncClient;
            String s2cEncServer;
            String c2sEncServer;
            this.reexchangeFuture = new DefaultSshFuture((Object)null);
            Map map = this.serverProposal;
            synchronized (map) {
                c2sEncServer = (String)this.serverProposal.get((Object)KexProposalOption.C2SENC);
                s2cEncServer = (String)this.serverProposal.get((Object)KexProposalOption.S2CENC);
            }
            boolean c2sEncServerNone = BuiltinCiphers.Constants.isNoneCipherIncluded(c2sEncServer);
            boolean s2cEncServerNone = BuiltinCiphers.Constants.isNoneCipherIncluded(s2cEncServer);
            Map map2 = this.clientProposal;
            synchronized (map2) {
                c2sEncClient = (String)this.clientProposal.get((Object)KexProposalOption.C2SENC);
                s2cEncClient = (String)this.clientProposal.get((Object)KexProposalOption.S2CENC);
            }
            boolean c2sEncClientNone = BuiltinCiphers.Constants.isNoneCipherIncluded(c2sEncClient);
            boolean s2cEncClientNone = BuiltinCiphers.Constants.isNoneCipherIncluded(s2cEncClient);
            if (!c2sEncServerNone || !s2cEncServerNone) {
                this.reexchangeFuture.setValue(new SshException("Server does not support none cipher"));
            } else if (!c2sEncClientNone || !s2cEncClientNone) {
                this.reexchangeFuture.setValue(new SshException("Client does not support none cipher"));
            } else {
                this.log.info("Switching to none cipher");
                EnumMap<KexProposalOption, String> proposal = new EnumMap<KexProposalOption, String>(KexProposalOption.class);
                Map map3 = this.clientProposal;
                synchronized (map3) {
                    proposal.putAll(this.clientProposal);
                }
                proposal.put(KexProposalOption.C2SENC, "none");
                proposal.put(KexProposalOption.S2CENC, "none");
                byte[] seed = this.sendKexInit(proposal);
                this.setKexSeed(seed);
            }
            return this.reexchangeFuture;
        }
        throw new SshException("In flight key exchange");
    }

    @Override
    public ClientChannel createChannel(String type) throws IOException {
        return this.createChannel(type, null);
    }

    @Override
    public ClientChannel createChannel(String type, String subType) throws IOException {
        if ("shell".equals(type)) {
            return this.createShellChannel();
        }
        if ("exec".equals(type)) {
            return this.createExecChannel(subType);
        }
        if ("subsystem".equals(type)) {
            return this.createSubsystemChannel(subType);
        }
        throw new IllegalArgumentException("Unsupported channel type " + type);
    }

    @Override
    public ChannelShell createShellChannel() throws IOException {
        if (this.inCipher instanceof CipherNone || this.outCipher instanceof CipherNone) {
            throw new IllegalStateException("Interactive channels are not supported with none cipher");
        }
        ChannelShell channel = new ChannelShell();
        ConnectionService service = this.getConnectionService();
        int id = service.registerChannel(channel);
        if (this.log.isDebugEnabled()) {
            this.log.debug("createShellChannel(id={}) created", (Object)id);
        }
        return channel;
    }

    @Override
    public ChannelExec createExecChannel(String command) throws IOException {
        ChannelExec channel = new ChannelExec(command);
        ConnectionService service = this.getConnectionService();
        int id = service.registerChannel(channel);
        if (this.log.isDebugEnabled()) {
            this.log.debug("createExecChannel(id={})[{}] created", (Object)id, (Object)command);
        }
        return channel;
    }

    @Override
    public ChannelSubsystem createSubsystemChannel(String subsystem) throws IOException {
        ChannelSubsystem channel = new ChannelSubsystem(subsystem);
        ConnectionService service = this.getConnectionService();
        int id = service.registerChannel(channel);
        if (this.log.isDebugEnabled()) {
            this.log.debug("createSubsystemChannel(id={})[{}] created", (Object)id, (Object)subsystem);
        }
        return channel;
    }

    @Override
    public ChannelDirectTcpip createDirectTcpipChannel(SshdSocketAddress local, SshdSocketAddress remote) throws IOException {
        ChannelDirectTcpip channel = new ChannelDirectTcpip(local, remote);
        ConnectionService service = this.getConnectionService();
        int id = service.registerChannel(channel);
        if (this.log.isDebugEnabled()) {
            this.log.debug("createDirectTcpipChannel(id={})[{} => {}] created", new Object[]{id, local, remote});
        }
        return channel;
    }

    private ClientUserAuthService getUserAuthService() {
        return this.getService(ClientUserAuthService.class);
    }

    private ConnectionService getConnectionService() {
        return this.getService(ConnectionService.class);
    }

    @Override
    public ScpTransferEventListener getScpTransferEventListener() {
        return this.scpListener;
    }

    @Override
    public void setScpTransferEventListener(ScpTransferEventListener listener) {
        this.scpListener = listener;
    }

    @Override
    public ScpClient createScpClient() {
        return this.createScpClient(this.getScpTransferEventListener());
    }

    @Override
    public ScpClient createScpClient(ScpTransferEventListener listener) {
        return new DefaultScpClient(this, listener);
    }

    @Override
    public SftpClient createSftpClient() throws IOException {
        return this.createSftpClient(SftpVersionSelector.CURRENT);
    }

    @Override
    public SftpClient createSftpClient(SftpVersionSelector selector) throws IOException {
        DefaultSftpClient client = new DefaultSftpClient(this);
        client.negotiateVersion(selector);
        return client;
    }

    @Override
    public FileSystem createSftpFileSystem() throws IOException {
        return this.createSftpFileSystem(SftpVersionSelector.CURRENT);
    }

    @Override
    public FileSystem createSftpFileSystem(SftpVersionSelector selector) throws IOException {
        return this.createSftpFileSystem(selector, 32768, 32768);
    }

    @Override
    public FileSystem createSftpFileSystem(int readBufferSize, int writeBufferSize) throws IOException {
        return this.createSftpFileSystem(SftpVersionSelector.CURRENT, readBufferSize, writeBufferSize);
    }

    @Override
    public FileSystem createSftpFileSystem(SftpVersionSelector selector, int readBufferSize, int writeBufferSize) throws IOException {
        SftpFileSystemProvider provider = new SftpFileSystemProvider((SshClient)this.factoryManager, selector);
        SftpFileSystem fs = provider.newFileSystem(this);
        fs.setReadBufferSize(readBufferSize);
        fs.setWriteBufferSize(writeBufferSize);
        return fs;
    }

    @Override
    public SshdSocketAddress startLocalPortForwarding(SshdSocketAddress local, SshdSocketAddress remote) throws IOException {
        return this.getConnectionService().getTcpipForwarder().startLocalPortForwarding(local, remote);
    }

    @Override
    public void stopLocalPortForwarding(SshdSocketAddress local) throws IOException {
        this.getConnectionService().getTcpipForwarder().stopLocalPortForwarding(local);
    }

    @Override
    public SshdSocketAddress startRemotePortForwarding(SshdSocketAddress remote, SshdSocketAddress local) throws IOException {
        return this.getConnectionService().getTcpipForwarder().startRemotePortForwarding(remote, local);
    }

    @Override
    public void stopRemotePortForwarding(SshdSocketAddress remote) throws IOException {
        this.getConnectionService().getTcpipForwarder().stopRemotePortForwarding(remote);
    }

    @Override
    public SshdSocketAddress startDynamicPortForwarding(SshdSocketAddress local) throws IOException {
        return this.getConnectionService().getTcpipForwarder().startDynamicPortForwarding(local);
    }

    @Override
    public void stopDynamicPortForwarding(SshdSocketAddress local) throws IOException {
        this.getConnectionService().getTcpipForwarder().stopDynamicPortForwarding(local);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleMessage(Buffer buffer) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            super.handleMessage(buffer);
        }
    }

    @Override
    public int waitFor(int mask, long timeout) {
        long t = 0L;
        Object object = this.lock;
        synchronized (object) {
            block5: while (true) {
                while (true) {
                    int cond = 0;
                    if (this.closeFuture.isClosed()) {
                        cond |= 2;
                    }
                    if (this.authed) {
                        cond |= 8;
                    }
                    if (KexState.DONE.equals(this.kexState.get()) && this.authFuture.isFailure()) {
                        cond |= 4;
                    }
                    if ((cond & mask) != 0) {
                        return cond;
                    }
                    if (timeout > 0L) {
                        if (t == 0L) {
                            t = System.currentTimeMillis() + timeout;
                        } else {
                            timeout = t - System.currentTimeMillis();
                            if (timeout <= 0L) {
                                return cond |= 1;
                            }
                        }
                    }
                    try {
                        if (timeout > 0L) {
                            this.lock.wait(timeout);
                            continue block5;
                        }
                        this.lock.wait();
                        continue block5;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    @Override
    protected boolean readIdentification(Buffer buffer) throws IOException {
        this.serverVersion = this.doReadIdentification(buffer, false);
        if (this.serverVersion == null) {
            return false;
        }
        this.log.debug("Server version string: {}", (Object)this.serverVersion);
        if (!this.serverVersion.startsWith("SSH-2.0-") && !this.serverVersion.startsWith("SSH-1.99-")) {
            throw new SshException(8, "Unsupported protocol version: " + this.serverVersion);
        }
        return true;
    }

    protected void sendClientIdentification() {
        ClientFactoryManager manager = this.getFactoryManager();
        this.clientVersion = "SSH-2.0-" + manager.getVersion();
        this.sendIdentification(this.clientVersion);
    }

    @Override
    protected byte[] sendKexInit(Map<KexProposalOption, String> proposal) throws IOException {
        this.mergeProposals(this.clientProposal, proposal);
        return super.sendKexInit(proposal);
    }

    @Override
    protected void setKexSeed(byte ... seed) {
        this.i_c = ValidateUtils.checkNotNullAndNotEmpty(seed, "No KEX seed", new Object[0]);
    }

    @Override
    protected String resolveAvailableSignaturesProposal(FactoryManager manager) {
        return NamedResource.Utils.getNames(manager.getSignatureFactories());
    }

    @Override
    protected void receiveKexInit(Map<KexProposalOption, String> proposal, byte[] seed) throws IOException {
        this.mergeProposals(this.serverProposal, proposal);
        this.i_s = seed;
    }

    @Override
    protected void checkKeys() throws SshException {
        SocketAddress remoteAddress;
        ClientFactoryManager manager = this.getFactoryManager();
        ServerKeyVerifier serverKeyVerifier = manager.getServerKeyVerifier();
        if (!serverKeyVerifier.verifyServerKey(this, remoteAddress = this.ioSession.getRemoteAddress(), this.kex.getServerKey())) {
            throw new SshException("Server key did not validate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendEvent(SessionListener.Event event) throws IOException {
        if (event == SessionListener.Event.KeyEstablished) {
            this.sendInitialServiceRequest();
        }
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
        super.sendEvent(event);
    }

    protected void sendInitialServiceRequest() throws IOException {
        if (this.initialServiceRequestSent) {
            return;
        }
        this.initialServiceRequestSent = true;
        this.log.debug("Send SSH_MSG_SERVICE_REQUEST for {}", (Object)this.currentServiceFactory.getName());
        Buffer request = this.createBuffer((byte)5);
        request.putString(this.currentServiceFactory.getName());
        this.writePacket(request);
        this.currentService.start();
    }

    @Override
    public void startService(String name) throws Exception {
        throw new IllegalStateException("Starting services is not supported on the client side: " + name);
    }

    @Override
    public Map<Object, Object> getMetadataMap() {
        return this.metadataMap;
    }
}

