/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.filesystem.nativefs.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.ftpserver.filesystem.nativefs.impl.NameEqualsFileFilter;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.usermanager.impl.WriteRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeFtpFile
implements FtpFile {
    private final Logger LOG = LoggerFactory.getLogger(NativeFtpFile.class);
    private String fileName;
    private File file;
    private User user;

    protected NativeFtpFile(String fileName, File file, User user) {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName can not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("file can not be null");
        }
        if (fileName.length() == 0) {
            throw new IllegalArgumentException("fileName can not be empty");
        }
        if (fileName.charAt(0) != '/') {
            throw new IllegalArgumentException("fileName must be an absolut path");
        }
        this.fileName = fileName;
        this.file = file;
        this.user = user;
    }

    @Override
    public String getAbsolutePath() {
        String fullName = this.fileName;
        int filelen = fullName.length();
        if (filelen != 1 && fullName.charAt(filelen - 1) == '/') {
            fullName = fullName.substring(0, filelen - 1);
        }
        return fullName;
    }

    @Override
    public String getName() {
        int slashIndex;
        if (this.fileName.equals("/")) {
            return "/";
        }
        String shortName = this.fileName;
        int filelen = this.fileName.length();
        if (shortName.charAt(filelen - 1) == '/') {
            shortName = shortName.substring(0, filelen - 1);
        }
        if ((slashIndex = shortName.lastIndexOf(47)) != -1) {
            shortName = shortName.substring(slashIndex + 1);
        }
        return shortName;
    }

    @Override
    public boolean isHidden() {
        return this.file.isHidden();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.file.isFile();
    }

    @Override
    public boolean doesExist() {
        return this.file.exists();
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    @Override
    public String getOwnerName() {
        return "user";
    }

    @Override
    public String getGroupName() {
        return "group";
    }

    @Override
    public int getLinkCount() {
        return this.file.isDirectory() ? 3 : 1;
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public boolean setLastModified(long time) {
        return this.file.setLastModified(time);
    }

    @Override
    public boolean isReadable() {
        return this.file.canRead();
    }

    @Override
    public boolean isWritable() {
        this.LOG.debug("Checking authorization for " + this.getAbsolutePath());
        if (this.user.authorize(new WriteRequest(this.getAbsolutePath())) == null) {
            this.LOG.debug("Not authorized");
            return false;
        }
        this.LOG.debug("Checking if file exists");
        if (this.file.exists()) {
            this.LOG.debug("Checking can write: " + this.file.canWrite());
            return this.file.canWrite();
        }
        this.LOG.debug("Authorized");
        return true;
    }

    @Override
    public boolean isRemovable() {
        if ("/".equals(this.fileName)) {
            return false;
        }
        String fullName = this.getAbsolutePath();
        if (this.user.authorize(new WriteRequest(fullName)) == null) {
            return false;
        }
        int indexOfSlash = fullName.lastIndexOf(47);
        String parentFullName = indexOfSlash == 0 ? "/" : fullName.substring(0, indexOfSlash);
        NativeFtpFile parentObject = new NativeFtpFile(parentFullName, this.file.getAbsoluteFile().getParentFile(), this.user);
        return parentObject.isWritable();
    }

    @Override
    public boolean delete() {
        boolean retVal = false;
        if (this.isRemovable()) {
            retVal = this.file.delete();
        }
        return retVal;
    }

    @Override
    public boolean move(FtpFile dest) {
        boolean retVal = false;
        if (dest.isWritable() && this.isReadable()) {
            File destFile = ((NativeFtpFile)dest).file;
            retVal = destFile.exists() ? false : this.file.renameTo(destFile);
        }
        return retVal;
    }

    @Override
    public boolean mkdir() {
        boolean retVal = false;
        if (this.isWritable()) {
            retVal = this.file.mkdir();
        }
        return retVal;
    }

    public File getPhysicalFile() {
        return this.file;
    }

    @Override
    public List<FtpFile> listFiles() {
        if (!this.file.isDirectory()) {
            return null;
        }
        File[] files = this.file.listFiles();
        if (files == null) {
            return null;
        }
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return f1.getName().compareTo(f2.getName());
            }
        });
        String virtualFileStr = this.getAbsolutePath();
        if (virtualFileStr.charAt(virtualFileStr.length() - 1) != '/') {
            virtualFileStr = virtualFileStr + '/';
        }
        FtpFile[] virtualFiles = new FtpFile[files.length];
        for (int i = 0; i < files.length; ++i) {
            File fileObj = files[i];
            String fileName = virtualFileStr + fileObj.getName();
            virtualFiles[i] = new NativeFtpFile(fileName, fileObj, this.user);
        }
        return Collections.unmodifiableList(Arrays.asList(virtualFiles));
    }

    @Override
    public OutputStream createOutputStream(long offset) throws IOException {
        if (!this.isWritable()) {
            throw new IOException("No write permission : " + this.file.getName());
        }
        final RandomAccessFile raf = new RandomAccessFile(this.file, "rw");
        raf.setLength(offset);
        raf.seek(offset);
        return new FileOutputStream(raf.getFD()){

            public void close() throws IOException {
                super.close();
                raf.close();
            }
        };
    }

    @Override
    public InputStream createInputStream(long offset) throws IOException {
        if (!this.isReadable()) {
            throw new IOException("No read permission : " + this.file.getName());
        }
        final RandomAccessFile raf = new RandomAccessFile(this.file, "r");
        raf.seek(offset);
        return new FileInputStream(raf.getFD()){

            public void close() throws IOException {
                super.close();
                raf.close();
            }
        };
    }

    public static final String normalizeSeparateChar(String pathName) {
        String normalizedPathName = pathName.replace(File.separatorChar, '/');
        normalizedPathName = normalizedPathName.replace('\\', '/');
        return normalizedPathName;
    }

    public static final String getPhysicalName(String rootDir, String currDir, String fileName) {
        return NativeFtpFile.getPhysicalName(rootDir, currDir, fileName, false);
    }

    public static final String getPhysicalName(String rootDir, String currDir, String fileName, boolean caseInsensitive) {
        String resArg;
        String normalizedRootDir = NativeFtpFile.normalizeSeparateChar(rootDir);
        if (normalizedRootDir.charAt(normalizedRootDir.length() - 1) != '/') {
            normalizedRootDir = normalizedRootDir + '/';
        }
        String normalizedFileName = NativeFtpFile.normalizeSeparateChar(fileName);
        String normalizedCurrDir = currDir;
        if (normalizedFileName.charAt(0) != '/') {
            if (normalizedCurrDir == null) {
                normalizedCurrDir = "/";
            }
            if (normalizedCurrDir.length() == 0) {
                normalizedCurrDir = "/";
            }
            if ((normalizedCurrDir = NativeFtpFile.normalizeSeparateChar(normalizedCurrDir)).charAt(0) != '/') {
                normalizedCurrDir = '/' + normalizedCurrDir;
            }
            if (normalizedCurrDir.charAt(normalizedCurrDir.length() - 1) != '/') {
                normalizedCurrDir = normalizedCurrDir + '/';
            }
            resArg = normalizedRootDir + normalizedCurrDir.substring(1);
        } else {
            resArg = normalizedRootDir;
        }
        if (resArg.charAt(resArg.length() - 1) == '/') {
            resArg = resArg.substring(0, resArg.length() - 1);
        }
        StringTokenizer st = new StringTokenizer(normalizedFileName, "/");
        while (st.hasMoreTokens()) {
            File[] matches;
            String tok = st.nextToken();
            if (tok.equals(".")) continue;
            if (tok.equals("..")) {
                int slashIndex;
                if (!resArg.startsWith(normalizedRootDir) || (slashIndex = resArg.lastIndexOf(47)) == -1) continue;
                resArg = resArg.substring(0, slashIndex);
                continue;
            }
            if (tok.equals("~")) {
                resArg = normalizedRootDir.substring(0, normalizedRootDir.length() - 1);
                continue;
            }
            if (caseInsensitive && (matches = new File(resArg).listFiles(new NameEqualsFileFilter(tok, true))) != null && matches.length > 0) {
                tok = matches[0].getName();
            }
            resArg = resArg + '/' + tok;
        }
        if (resArg.length() + 1 == normalizedRootDir.length()) {
            resArg = resArg + '/';
        }
        if (!resArg.regionMatches(0, normalizedRootDir, 0, normalizedRootDir.length())) {
            resArg = normalizedRootDir;
        }
        return resArg;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof NativeFtpFile) {
            File otherCanonicalFile;
            File thisCanonicalFile;
            try {
                thisCanonicalFile = this.file.getCanonicalFile();
                otherCanonicalFile = ((NativeFtpFile)obj).file.getCanonicalFile();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to get the canonical path", e);
            }
            return thisCanonicalFile.equals(otherCanonicalFile);
        }
        return false;
    }
}

