/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.subsystem.sftp.extensions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.sshd.common.subsystem.sftp.extensions.ExtensionParser;
import org.apache.sshd.common.subsystem.sftp.extensions.NewlineParser;
import org.apache.sshd.common.subsystem.sftp.extensions.Supported2Parser;
import org.apache.sshd.common.subsystem.sftp.extensions.SupportedParser;
import org.apache.sshd.common.subsystem.sftp.extensions.VendorIdParser;
import org.apache.sshd.common.subsystem.sftp.extensions.VersionsParser;
import org.apache.sshd.common.subsystem.sftp.extensions.openssh.FstatVfsExtensionParser;
import org.apache.sshd.common.subsystem.sftp.extensions.openssh.FsyncExtensionParser;
import org.apache.sshd.common.subsystem.sftp.extensions.openssh.HardLinkExtensionParser;
import org.apache.sshd.common.subsystem.sftp.extensions.openssh.PosixRenameExtensionParser;
import org.apache.sshd.common.subsystem.sftp.extensions.openssh.StatVfsExtensionParser;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public final class ParserUtils {
    public static final Collection<ExtensionParser<?>> BUILT_IN_PARSERS = Collections.unmodifiableList(Arrays.asList(VendorIdParser.INSTANCE, NewlineParser.INSTANCE, VersionsParser.INSTANCE, SupportedParser.INSTANCE, Supported2Parser.INSTANCE, PosixRenameExtensionParser.INSTANCE, StatVfsExtensionParser.INSTANCE, FstatVfsExtensionParser.INSTANCE, HardLinkExtensionParser.INSTANCE, FsyncExtensionParser.INSTANCE));
    private static final Map<String, ExtensionParser<?>> PARSERS_MAP = new TreeMap(String.CASE_INSENSITIVE_ORDER);

    private ParserUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExtensionParser<?> registerParser(ExtensionParser<?> parser) {
        ValidateUtils.checkNotNull(parser, "No parser instance");
        Map<String, ExtensionParser<?>> map = PARSERS_MAP;
        synchronized (map) {
            return PARSERS_MAP.put(parser.getName(), parser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExtensionParser<?> unregisterParser(String name) {
        if (GenericUtils.isEmpty(name)) {
            return null;
        }
        Map<String, ExtensionParser<?>> map = PARSERS_MAP;
        synchronized (map) {
            return PARSERS_MAP.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExtensionParser<?> getRegisteredParser(String name) {
        if (GenericUtils.isEmpty(name)) {
            return null;
        }
        Map<String, ExtensionParser<?>> map = PARSERS_MAP;
        synchronized (map) {
            return PARSERS_MAP.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getRegisteredParsersNames() {
        Map<String, ExtensionParser<?>> map = PARSERS_MAP;
        synchronized (map) {
            if (PARSERS_MAP.isEmpty()) {
                return Collections.emptySet();
            }
            return GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, PARSERS_MAP.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ExtensionParser<?>> getRegisteredParsers() {
        Map<String, ExtensionParser<?>> map = PARSERS_MAP;
        synchronized (map) {
            if (PARSERS_MAP.isEmpty()) {
                return Collections.emptyList();
            }
            return new ArrayList(PARSERS_MAP.values());
        }
    }

    public static Set<String> supportedExtensions(Map<String, ?> parsed) {
        Collection<String> extra2;
        if (GenericUtils.isEmpty(parsed)) {
            return Collections.emptySet();
        }
        SupportedParser.Supported sup = (SupportedParser.Supported)parsed.get(SupportedParser.INSTANCE.getName());
        Collection<String> extra = sup == null ? null : sup.extensionNames;
        Supported2Parser.Supported2 sup2 = (Supported2Parser.Supported2)parsed.get(Supported2Parser.INSTANCE.getName());
        Collection<String> collection = extra2 = sup2 == null ? null : sup2.extensionNames;
        if (GenericUtils.isEmpty(extra)) {
            return GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, extra2);
        }
        if (GenericUtils.isEmpty(extra2)) {
            return GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, extra);
        }
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.addAll(extra);
        result.addAll(extra2);
        return result;
    }

    public static Map<String, Object> parse(Map<String, byte[]> extensions) {
        if (GenericUtils.isEmpty(extensions)) {
            return Collections.emptyMap();
        }
        TreeMap<String, Object> data = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, byte[]> ee : extensions.entrySet()) {
            String name = ee.getKey();
            Object result = ParserUtils.parse(name, ee.getValue());
            if (result == null) continue;
            data.put(name, result);
        }
        return data;
    }

    public static Object parse(String name, byte ... encoded) {
        ExtensionParser<?> parser = ParserUtils.getRegisteredParser(name);
        if (parser == null) {
            return null;
        }
        return parser.transform(encoded);
    }

    static {
        for (ExtensionParser<?> p : BUILT_IN_PARSERS) {
            PARSERS_MAP.put(p.getName(), p);
        }
    }
}

