/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.sshd.common.config.keys.BuiltinIdentities;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.keyprovider.MappedKeyPairProvider;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.common.util.ValidateUtils;

public final class IdentityUtils {
    private IdentityUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static String getIdentityFileName(String prefix, String type, String suffix) {
        if (GenericUtils.isEmpty(type)) {
            return null;
        }
        return GenericUtils.trimToEmpty(prefix) + type.toLowerCase() + GenericUtils.trimToEmpty(suffix);
    }

    public static KeyPairProvider createKeyPairProvider(Map<String, KeyPair> ids, boolean supportedOnly) {
        if (GenericUtils.isEmpty(ids)) {
            return null;
        }
        TreeMap<String, KeyPair> pairsMap = new TreeMap<String, KeyPair>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, KeyPair> ide : ids.entrySet()) {
            KeyPair prev;
            String keyType;
            String type = ide.getKey();
            KeyPair kp = ide.getValue();
            BuiltinIdentities id = BuiltinIdentities.fromName(type);
            if (id == null) {
                id = BuiltinIdentities.fromKeyPair(kp);
            }
            if ((!supportedOnly || id != null && id.isSupported()) && !GenericUtils.isEmpty(keyType = KeyUtils.getKeyType(kp)) && (prev = pairsMap.put(keyType, kp)) == null) continue;
        }
        if (GenericUtils.isEmpty(pairsMap)) {
            return null;
        }
        return new MappedKeyPairProvider(pairsMap);
    }

    public static Map<String, KeyPair> loadIdentities(Map<String, ? extends Path> paths, FilePasswordProvider provider, OpenOption ... options) throws IOException, GeneralSecurityException {
        if (GenericUtils.isEmpty(paths)) {
            return Collections.emptyMap();
        }
        TreeMap<String, KeyPair> ids = new TreeMap<String, KeyPair>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, ? extends Path> pe : paths.entrySet()) {
            String type = pe.getKey();
            Path path = pe.getValue();
            InputStream inputStream = Files.newInputStream(path, options);
            Throwable throwable = null;
            try {
                KeyPair kp = SecurityUtils.loadKeyPairIdentity(path.toString(), inputStream, provider);
                KeyPair prev = ids.put(type, kp);
                ValidateUtils.checkTrue(prev == null, "Multiple keys for type=%s", (Object)type);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                inputStream.close();
            }
        }
        return ids;
    }
}

