/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.file.util;

import java.util.AbstractList;

public class ImmutableList<T>
extends AbstractList<T> {
    private final T[] data;
    private final int from;
    private final int to;

    public ImmutableList(T[] data) {
        this(data, 0, data.length);
    }

    public ImmutableList(T[] data, int from, int to) {
        this.data = data;
        this.from = from;
        this.to = to;
    }

    @Override
    public T get(int index) {
        return this.data[this.from + index];
    }

    @Override
    public int size() {
        return this.to - this.from;
    }

    @Override
    public ImmutableList<T> subList(int fromIndex, int toIndex) {
        if (fromIndex == this.from && toIndex == this.to) {
            return this;
        }
        return new ImmutableList<T>(this.data, this.from + fromIndex, this.from + toIndex);
    }
}

