/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.subsystem.sftp;

import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.client.subsystem.sftp.SftpClient;
import org.apache.sshd.client.subsystem.sftp.SftpFileSystem;
import org.apache.sshd.client.subsystem.sftp.SftpFileSystemProvider;

public class SftpPosixFileAttributes
implements PosixFileAttributes {
    private final Path path;
    private final SftpClient.Attributes attributes;

    public SftpPosixFileAttributes(Path path, SftpClient.Attributes attributes) {
        this.path = path;
        this.attributes = attributes;
    }

    public final Path getPath() {
        return this.path;
    }

    @Override
    public UserPrincipal owner() {
        return this.attributes.owner != null ? new SftpFileSystem.DefaultGroupPrincipal(this.attributes.owner) : null;
    }

    @Override
    public GroupPrincipal group() {
        return this.attributes.group != null ? new SftpFileSystem.DefaultGroupPrincipal(this.attributes.group) : null;
    }

    @Override
    public Set<PosixFilePermission> permissions() {
        return SftpFileSystemProvider.permissionsToAttributes(this.attributes.perms);
    }

    @Override
    public FileTime lastModifiedTime() {
        return FileTime.from(this.attributes.mtime, TimeUnit.SECONDS);
    }

    @Override
    public FileTime lastAccessTime() {
        return FileTime.from(this.attributes.atime, TimeUnit.SECONDS);
    }

    @Override
    public FileTime creationTime() {
        return FileTime.from(this.attributes.ctime, TimeUnit.SECONDS);
    }

    @Override
    public boolean isRegularFile() {
        return this.attributes.isRegularFile();
    }

    @Override
    public boolean isDirectory() {
        return this.attributes.isDirectory();
    }

    @Override
    public boolean isSymbolicLink() {
        return this.attributes.isSymbolicLink();
    }

    @Override
    public boolean isOther() {
        return this.attributes.isOther();
    }

    @Override
    public long size() {
        return this.attributes.size;
    }

    @Override
    public Object fileKey() {
        return null;
    }
}

