/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.future;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.util.ValidateUtils;

public class DefaultAuthFuture
extends DefaultSshFuture<AuthFuture>
implements AuthFuture {
    public DefaultAuthFuture(Object lock) {
        super(lock);
    }

    @Override
    public void verify() throws IOException {
        this.verify(Long.MAX_VALUE);
    }

    @Override
    public void verify(long timeout, TimeUnit unit) throws IOException {
        this.verify(unit.toMillis(timeout));
    }

    @Override
    public void verify(long timeoutMillis) throws IOException {
        Boolean result = this.verifyResult(Boolean.class, timeoutMillis);
        if (!result.booleanValue()) {
            throw new SshException("Authentication failed");
        }
    }

    @Override
    public Throwable getException() {
        Object v = this.getValue();
        if (v instanceof Throwable) {
            return (Throwable)v;
        }
        return null;
    }

    @Override
    public boolean isSuccess() {
        Object v = this.getValue();
        return v instanceof Boolean && (Boolean)v != false;
    }

    @Override
    public boolean isFailure() {
        Object v = this.getValue();
        return v instanceof Boolean && (Boolean)v == false;
    }

    @Override
    public void setAuthed(boolean authed) {
        this.setValue(authed);
    }

    @Override
    public void setException(Throwable exception) {
        ValidateUtils.checkNotNull(exception, "No exception provided");
        this.setValue(exception);
    }
}

