/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.config.NamedResourceListParseResult;
import org.apache.sshd.common.digest.BuiltinDigests;
import org.apache.sshd.common.kex.AbstractDH;
import org.apache.sshd.common.kex.DHFactory;
import org.apache.sshd.common.kex.DHG;
import org.apache.sshd.common.kex.DHGroupData;
import org.apache.sshd.common.kex.ECDH;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.common.util.ValidateUtils;

public enum BuiltinDHFactories implements DHFactory
{
    dhg1("diffie-hellman-group1-sha1"){

        @Override
        public DHG create(Object ... params) throws Exception {
            if (!GenericUtils.isEmpty(params)) {
                throw new IllegalArgumentException("No accepted parameters for " + this.getName());
            }
            return new DHG(BuiltinDigests.sha1, new BigInteger(DHGroupData.getP1()), new BigInteger(DHGroupData.getG()));
        }
    }
    ,
    dhg14("diffie-hellman-group14-sha1"){

        @Override
        public DHG create(Object ... params) throws Exception {
            if (!GenericUtils.isEmpty(params)) {
                throw new IllegalArgumentException("No accepted parameters for " + this.getName());
            }
            return new DHG(BuiltinDigests.sha1, new BigInteger(DHGroupData.getP14()), new BigInteger(DHGroupData.getG()));
        }

        @Override
        public boolean isSupported() {
            return SecurityUtils.isBouncyCastleRegistered();
        }
    }
    ,
    dhgex("diffie-hellman-group-exchange-sha1"){

        @Override
        public DHG create(Object ... params) throws Exception {
            if (GenericUtils.length(params) != 2 || !(params[0] instanceof BigInteger) || !(params[1] instanceof BigInteger)) {
                throw new IllegalArgumentException("Bad parameters for " + this.getName());
            }
            return new DHG(BuiltinDigests.sha1, (BigInteger)params[0], (BigInteger)params[1]);
        }

        @Override
        public boolean isGroupExchange() {
            return true;
        }
    }
    ,
    dhgex256("diffie-hellman-group-exchange-sha256"){

        @Override
        public AbstractDH create(Object ... params) throws Exception {
            if (GenericUtils.length(params) != 2 || !(params[0] instanceof BigInteger) || !(params[1] instanceof BigInteger)) {
                throw new IllegalArgumentException("Bad parameters for " + this.getName());
            }
            return new DHG(BuiltinDigests.sha256, (BigInteger)params[0], (BigInteger)params[1]);
        }

        @Override
        public boolean isSupported() {
            return SecurityUtils.isBouncyCastleRegistered();
        }

        @Override
        public boolean isGroupExchange() {
            return true;
        }
    }
    ,
    ecdhp256("ecdh-sha2-nistp256"){

        @Override
        public ECDH create(Object ... params) throws Exception {
            if (!GenericUtils.isEmpty(params)) {
                throw new IllegalArgumentException("No accepted parameters for " + this.getName());
            }
            return new ECDH(ECCurves.nistp256);
        }

        @Override
        public boolean isSupported() {
            return SecurityUtils.hasEcc();
        }
    }
    ,
    ecdhp384("ecdh-sha2-nistp384"){

        @Override
        public ECDH create(Object ... params) throws Exception {
            if (!GenericUtils.isEmpty(params)) {
                throw new IllegalArgumentException("No accepted parameters for " + this.getName());
            }
            return new ECDH(ECCurves.nistp384);
        }

        @Override
        public boolean isSupported() {
            return SecurityUtils.hasEcc();
        }
    }
    ,
    ecdhp521("ecdh-sha2-nistp521"){

        @Override
        public ECDH create(Object ... params) throws Exception {
            if (!GenericUtils.isEmpty(params)) {
                throw new IllegalArgumentException("No accepted parameters for " + this.getName());
            }
            return new ECDH(ECCurves.nistp521);
        }

        @Override
        public boolean isSupported() {
            return SecurityUtils.hasEcc();
        }
    };

    public static final Set<BuiltinDHFactories> VALUES;
    private static final Map<String, DHFactory> EXTENSIONS;
    private final String factoryName;

    private BuiltinDHFactories(String name) {
        this.factoryName = name;
    }

    @Override
    public final String getName() {
        return this.factoryName;
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    public final String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerExtension(DHFactory extension) {
        String name = ValidateUtils.checkNotNull(extension, "No extension provided").getName();
        ValidateUtils.checkTrue(BuiltinDHFactories.fromFactoryName(name) == null, "Extension overrides built-in: %s", (Object)name);
        Map<String, DHFactory> map = EXTENSIONS;
        synchronized (map) {
            ValidateUtils.checkTrue(!EXTENSIONS.containsKey(name), "Extension overrides existing: %s", (Object)name);
            EXTENSIONS.put(name, extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SortedSet<DHFactory> getRegisteredExtensions() {
        Map<String, DHFactory> map = EXTENSIONS;
        synchronized (map) {
            return GenericUtils.asSortedSet(NamedResource.BY_NAME_COMPARATOR, EXTENSIONS.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DHFactory unregisterExtension(String name) {
        if (GenericUtils.isEmpty(name)) {
            return null;
        }
        Map<String, DHFactory> map = EXTENSIONS;
        synchronized (map) {
            return EXTENSIONS.remove(name);
        }
    }

    public static BuiltinDHFactories fromFactoryName(String name) {
        return NamedResource.Utils.findByName(name, String.CASE_INSENSITIVE_ORDER, VALUES);
    }

    @Override
    public boolean isGroupExchange() {
        return false;
    }

    public static ParseResult parseDHFactoriesList(String dhList) {
        return BuiltinDHFactories.parseDHFactoriesList(GenericUtils.split(dhList, ','));
    }

    public static ParseResult parseDHFactoriesList(String ... dhList) {
        return BuiltinDHFactories.parseDHFactoriesList(GenericUtils.isEmpty((Object[])dhList) ? Collections.emptyList() : Arrays.asList(dhList));
    }

    public static ParseResult parseDHFactoriesList(Collection<String> dhList) {
        if (GenericUtils.isEmpty(dhList)) {
            return ParseResult.EMPTY;
        }
        ArrayList<DHFactory> factories = new ArrayList<DHFactory>(dhList.size());
        List<String> unknown = Collections.emptyList();
        for (String name : dhList) {
            DHFactory f = BuiltinDHFactories.resolveFactory(name);
            if (f != null) {
                factories.add(f);
                continue;
            }
            if (unknown.isEmpty()) {
                unknown = new ArrayList<String>();
            }
            unknown.add(name);
        }
        return new ParseResult((List<DHFactory>)factories, unknown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DHFactory resolveFactory(String name) {
        if (GenericUtils.isEmpty(name)) {
            return null;
        }
        BuiltinDHFactories s = BuiltinDHFactories.fromFactoryName(name);
        if (s != null) {
            return s;
        }
        Map<String, DHFactory> map = EXTENSIONS;
        synchronized (map) {
            return EXTENSIONS.get(name);
        }
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(BuiltinDHFactories.class));
        EXTENSIONS = new TreeMap<String, DHFactory>(String.CASE_INSENSITIVE_ORDER);
    }

    public static final class Constants {
        public static final String DIFFIE_HELLMAN_GROUP1_SHA1 = "diffie-hellman-group1-sha1";
        public static final String DIFFIE_HELLMAN_GROUP14_SHA1 = "diffie-hellman-group14-sha1";
        public static final String DIFFIE_HELLMAN_GROUP_EXCHANGE_SHA1 = "diffie-hellman-group-exchange-sha1";
        public static final String DIFFIE_HELLMAN_GROUP_EXCHANGE_SHA256 = "diffie-hellman-group-exchange-sha256";
        public static final String ECDH_SHA2_NISTP256 = "ecdh-sha2-nistp256";
        public static final String ECDH_SHA2_NISTP384 = "ecdh-sha2-nistp384";
        public static final String ECDH_SHA2_NISTP521 = "ecdh-sha2-nistp521";
    }

    public static final class ParseResult
    extends NamedResourceListParseResult<DHFactory> {
        public static final ParseResult EMPTY = new ParseResult(Collections.emptyList(), Collections.emptyList());

        public ParseResult(List<DHFactory> parsed, List<String> unsupported) {
            super(parsed, unsupported);
        }

        public List<DHFactory> getParsedFactories() {
            return this.getParsedResources();
        }

        public List<String> getUnsupportedFactories() {
            return this.getUnsupportedResources();
        }
    }
}

