/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.global;

import org.apache.sshd.common.SshdSocketAddress;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.forward.TcpipForwarder;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.ConnectionServiceRequestHandler;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.Int2IntFunction;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class TcpipForwardHandler
extends AbstractLoggingBean
implements ConnectionServiceRequestHandler {
    public static final String REQUEST = "tcpip-forward";
    public static final Int2IntFunction RESPONSE_BUFFER_GROWTH_FACTOR = Int2IntFunction.Utils.add(8);
    public static final TcpipForwardHandler INSTANCE = new TcpipForwardHandler();

    @Override
    public RequestHandler.Result process(ConnectionService connectionService, String request, boolean wantReply, Buffer buffer) throws Exception {
        if (REQUEST.equals(request)) {
            String address = buffer.getString();
            int port = buffer.getInt();
            SshdSocketAddress socketAddress = new SshdSocketAddress(address, port);
            TcpipForwarder forwarder = connectionService.getTcpipForwarder();
            SshdSocketAddress bound = forwarder.localPortForwardingRequested(socketAddress);
            if (this.log.isDebugEnabled()) {
                this.log.debug("process(" + connectionService + ")[" + request + "] " + socketAddress + " => " + bound + ", reply=" + wantReply);
            }
            port = bound.getPort();
            if (wantReply) {
                buffer.clear();
                buffer.ensureCapacity(10, RESPONSE_BUFFER_GROWTH_FACTOR);
                buffer.rpos(5);
                buffer.wpos(5);
                buffer.putByte((byte)81);
                buffer.putInt(port);
                Session session = connectionService.getSession();
                session.writePacket(buffer);
            }
            return RequestHandler.Result.Replied;
        }
        return RequestHandler.Result.Unsupported;
    }
}

