/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public class SshdSocketAddress
extends SocketAddress {
    public static final SshdSocketAddress LOCALHOST_ADDRESS = new SshdSocketAddress("localhost", 0);
    private static final long serialVersionUID = 6461645947151952729L;
    private final String hostName;
    private final int port;

    public SshdSocketAddress(String hostName, int port) {
        ValidateUtils.checkNotNull(hostName, "Host name may not be null");
        this.hostName = GenericUtils.isEmpty(hostName) ? "0.0.0.0" : hostName;
        ValidateUtils.checkTrue(port >= 0, "Port must be >= 0", (Object)port);
        this.port = port;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public InetSocketAddress toInetSocketAddress() {
        return new InetSocketAddress(this.getHostName(), this.getPort());
    }

    public String toString() {
        return this.getHostName() + ":" + this.getPort();
    }

    protected boolean isEquivalent(SshdSocketAddress that) {
        if (that == null) {
            return false;
        }
        if (that == this) {
            return true;
        }
        return this.getPort() == that.getPort() && Objects.equals(this.getHostName(), that.getHostName());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        return this.isEquivalent((SshdSocketAddress)o);
    }

    public int hashCode() {
        return Objects.hashCode(this.getHostName()) + this.getPort();
    }
}

