/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.subsystem.sftp.extensions;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.sshd.common.subsystem.sftp.extensions.AbstractParser;
import org.apache.sshd.common.util.GenericUtils;

public class VersionsParser
extends AbstractParser<Versions> {
    public static final VersionsParser INSTANCE = new VersionsParser();

    public VersionsParser() {
        super("versions");
    }

    @Override
    public Versions parse(byte[] input, int offset, int len) {
        return this.parse(new String(input, offset, len, StandardCharsets.UTF_8));
    }

    public Versions parse(String value) {
        String[] comps = GenericUtils.split(value, ',');
        Versions v = new Versions();
        v.versions = GenericUtils.isEmpty(comps) ? Collections.emptyList() : Arrays.asList(comps);
        return v;
    }

    public static class Versions {
        public static final char SEP = ',';
        public Collection<String> versions;

        public String toString() {
            return GenericUtils.join(this.versions, ',');
        }
    }
}

