/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.subsystem.sftp;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.InvalidPathException;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryFlag;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.server.subsystem.sftp.DefaultGroupPrincipal;
import org.apache.sshd.server.subsystem.sftp.InvalidHandleException;

public final class SftpHelper {
    private SftpHelper() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static void writeAttrs(int version, Buffer buffer, Map<String, ?> attributes) throws IOException {
        if (version == 3) {
            SftpHelper.writeAttrsV3(buffer, attributes);
        } else if (version >= 4) {
            SftpHelper.writeAttrsV4(buffer, attributes);
        } else {
            throw new IllegalStateException("Unsupported SFTP version: " + version);
        }
    }

    public static void writeAttrsV3(Buffer buffer, Map<String, ?> attributes) throws IOException {
        boolean isReg = SftpHelper.getBool((Boolean)attributes.get("isRegularFile"));
        boolean isDir = SftpHelper.getBool((Boolean)attributes.get("isDirectory"));
        boolean isLnk = SftpHelper.getBool((Boolean)attributes.get("isSymbolicLink"));
        Collection perms = (Collection)attributes.get("permissions");
        Number size = (Number)attributes.get("size");
        FileTime lastModifiedTime = (FileTime)attributes.get("lastModifiedTime");
        FileTime lastAccessTime = (FileTime)attributes.get("lastAccessTime");
        int flags = ((isReg || isLnk) && size != null ? 1 : 0) | (attributes.containsKey("uid") && attributes.containsKey("gid") ? 2 : 0) | (perms != null ? 4 : 0) | (lastModifiedTime != null && lastAccessTime != null ? 8 : 0);
        buffer.putInt(flags);
        if ((flags & 1) != 0) {
            buffer.putLong(size.longValue());
        }
        if ((flags & 2) != 0) {
            buffer.putInt(((Number)attributes.get("uid")).intValue());
            buffer.putInt(((Number)attributes.get("gid")).intValue());
        }
        if ((flags & 4) != 0) {
            buffer.putInt(SftpHelper.attributesToPermissions(isReg, isDir, isLnk, perms));
        }
        if ((flags & 8) != 0) {
            buffer.putInt(lastAccessTime.to(TimeUnit.SECONDS));
            buffer.putInt(lastModifiedTime.to(TimeUnit.SECONDS));
        }
    }

    public static void writeAttrsV4(Buffer buffer, Map<String, ?> attributes) throws IOException {
        boolean isReg = SftpHelper.getBool((Boolean)attributes.get("isRegularFile"));
        boolean isDir = SftpHelper.getBool((Boolean)attributes.get("isDirectory"));
        boolean isLnk = SftpHelper.getBool((Boolean)attributes.get("isSymbolicLink"));
        Collection perms = (Collection)attributes.get("permissions");
        Number size = (Number)attributes.get("size");
        FileTime lastModifiedTime = (FileTime)attributes.get("lastModifiedTime");
        FileTime lastAccessTime = (FileTime)attributes.get("lastAccessTime");
        FileTime creationTime = (FileTime)attributes.get("creationTime");
        int flags = ((isReg || isLnk) && size != null ? 1 : 0) | (attributes.containsKey("owner") && attributes.containsKey("group") ? 128 : 0) | (perms != null ? 4 : 0) | (lastModifiedTime != null ? 32 : 0) | (creationTime != null ? 16 : 0) | (lastAccessTime != null ? 8 : 0);
        buffer.putInt(flags);
        buffer.putByte((byte)(isReg ? 1 : (isDir ? 2 : (isLnk ? 3 : 5))));
        if ((flags & 1) != 0) {
            buffer.putLong(size.longValue());
        }
        if ((flags & 0x80) != 0) {
            buffer.putString(Objects.toString(attributes.get("owner"), null));
            buffer.putString(Objects.toString(attributes.get("group"), null));
        }
        if ((flags & 4) != 0) {
            buffer.putInt(SftpHelper.attributesToPermissions(isReg, isDir, isLnk, perms));
        }
        if ((flags & 8) != 0) {
            SftpHelper.putFileTime(buffer, flags, lastAccessTime);
        }
        if ((flags & 0x10) != 0) {
            SftpHelper.putFileTime(buffer, flags, lastAccessTime);
        }
        if ((flags & 0x20) != 0) {
            SftpHelper.putFileTime(buffer, flags, lastModifiedTime);
        }
    }

    public static void putFileTime(Buffer buffer, int flags, FileTime time) {
        buffer.putLong(time.to(TimeUnit.SECONDS));
        if ((flags & 0x100) != 0) {
            long nanos = time.to(TimeUnit.NANOSECONDS);
            buffer.putInt((int)(nanos %= TimeUnit.SECONDS.toNanos(1L)));
        }
    }

    protected static boolean getBool(Boolean bool) {
        return bool != null && bool != false;
    }

    public static int attributesToPermissions(boolean isReg, boolean isDir, boolean isLnk, Collection<PosixFilePermission> perms) {
        int pf = 0;
        if (perms != null) {
            for (PosixFilePermission p : perms) {
                switch (p) {
                    case OWNER_READ: {
                        pf |= 0x100;
                        break;
                    }
                    case OWNER_WRITE: {
                        pf |= 0x80;
                        break;
                    }
                    case OWNER_EXECUTE: {
                        pf |= 0x40;
                        break;
                    }
                    case GROUP_READ: {
                        pf |= 0x20;
                        break;
                    }
                    case GROUP_WRITE: {
                        pf |= 0x10;
                        break;
                    }
                    case GROUP_EXECUTE: {
                        pf |= 8;
                        break;
                    }
                    case OTHERS_READ: {
                        pf |= 4;
                        break;
                    }
                    case OTHERS_WRITE: {
                        pf |= 2;
                        break;
                    }
                    case OTHERS_EXECUTE: {
                        pf |= 1;
                        break;
                    }
                }
            }
        }
        pf |= isReg ? 32768 : 0;
        pf |= isDir ? 16384 : 0;
        return pf |= isLnk ? 40960 : 0;
    }

    public static Set<PosixFilePermission> permissionsToAttributes(int perms) {
        HashSet<PosixFilePermission> p = new HashSet<PosixFilePermission>();
        if ((perms & 0x100) != 0) {
            p.add(PosixFilePermission.OWNER_READ);
        }
        if ((perms & 0x80) != 0) {
            p.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((perms & 0x40) != 0) {
            p.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((perms & 0x20) != 0) {
            p.add(PosixFilePermission.GROUP_READ);
        }
        if ((perms & 0x10) != 0) {
            p.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((perms & 8) != 0) {
            p.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((perms & 4) != 0) {
            p.add(PosixFilePermission.OTHERS_READ);
        }
        if ((perms & 2) != 0) {
            p.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((perms & 1) != 0) {
            p.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return p;
    }

    public static int resolveSubstatus(Exception e) {
        if (e instanceof NoSuchFileException || e instanceof FileNotFoundException) {
            return 2;
        }
        if (e instanceof InvalidHandleException) {
            return 9;
        }
        if (e instanceof FileAlreadyExistsException) {
            return 11;
        }
        if (e instanceof DirectoryNotEmptyException) {
            return 18;
        }
        if (e instanceof NotDirectoryException) {
            return 19;
        }
        if (e instanceof AccessDeniedException) {
            return 3;
        }
        if (e instanceof EOFException) {
            return 1;
        }
        if (e instanceof OverlappingFileLockException) {
            return 17;
        }
        if (e instanceof UnsupportedOperationException) {
            return 8;
        }
        if (e instanceof InvalidPathException) {
            return 20;
        }
        if (e instanceof IllegalArgumentException) {
            return 23;
        }
        return 4;
    }

    public static AclEntry buildAclEntry(int aclType, int aclFlag, int aclMask, String aclWho) {
        AclEntryType type;
        switch (aclType) {
            case 0: {
                type = AclEntryType.ALLOW;
                break;
            }
            case 1: {
                type = AclEntryType.DENY;
                break;
            }
            case 2: {
                type = AclEntryType.AUDIT;
                break;
            }
            case 3: {
                type = AclEntryType.AUDIT;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown acl type: " + aclType);
            }
        }
        HashSet<AclEntryFlag> flags = new HashSet<AclEntryFlag>();
        if ((aclFlag & 1) != 0) {
            flags.add(AclEntryFlag.FILE_INHERIT);
        }
        if ((aclFlag & 2) != 0) {
            flags.add(AclEntryFlag.DIRECTORY_INHERIT);
        }
        if ((aclFlag & 4) != 0) {
            flags.add(AclEntryFlag.NO_PROPAGATE_INHERIT);
        }
        if ((aclFlag & 8) != 0) {
            flags.add(AclEntryFlag.INHERIT_ONLY);
        }
        HashSet<AclEntryPermission> mask = new HashSet<AclEntryPermission>();
        if ((aclMask & 1) != 0) {
            mask.add(AclEntryPermission.READ_DATA);
        }
        if ((aclMask & 1) != 0) {
            mask.add(AclEntryPermission.LIST_DIRECTORY);
        }
        if ((aclMask & 2) != 0) {
            mask.add(AclEntryPermission.WRITE_DATA);
        }
        if ((aclMask & 2) != 0) {
            mask.add(AclEntryPermission.ADD_FILE);
        }
        if ((aclMask & 4) != 0) {
            mask.add(AclEntryPermission.APPEND_DATA);
        }
        if ((aclMask & 4) != 0) {
            mask.add(AclEntryPermission.ADD_SUBDIRECTORY);
        }
        if ((aclMask & 8) != 0) {
            mask.add(AclEntryPermission.READ_NAMED_ATTRS);
        }
        if ((aclMask & 0x10) != 0) {
            mask.add(AclEntryPermission.WRITE_NAMED_ATTRS);
        }
        if ((aclMask & 0x20) != 0) {
            mask.add(AclEntryPermission.EXECUTE);
        }
        if ((aclMask & 0x40) != 0) {
            mask.add(AclEntryPermission.DELETE_CHILD);
        }
        if ((aclMask & 0x80) != 0) {
            mask.add(AclEntryPermission.READ_ATTRIBUTES);
        }
        if ((aclMask & 0x100) != 0) {
            mask.add(AclEntryPermission.WRITE_ATTRIBUTES);
        }
        if ((aclMask & 0x10000) != 0) {
            mask.add(AclEntryPermission.DELETE);
        }
        if ((aclMask & 0x20000) != 0) {
            mask.add(AclEntryPermission.READ_ACL);
        }
        if ((aclMask & 0x40000) != 0) {
            mask.add(AclEntryPermission.WRITE_ACL);
        }
        if ((aclMask & 0x80000) != 0) {
            mask.add(AclEntryPermission.WRITE_OWNER);
        }
        if ((aclMask & 0x100000) != 0) {
            mask.add(AclEntryPermission.SYNCHRONIZE);
        }
        DefaultGroupPrincipal who = new DefaultGroupPrincipal(aclWho);
        return AclEntry.newBuilder().setType(type).setFlags(flags).setPermissions(mask).setPrincipal(who).build();
    }

    protected static Map<String, Object> readAttrs(int version, Buffer buffer) throws IOException {
        int bits2;
        int i;
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        int flags = buffer.getInt();
        if (version >= 4) {
            int type = buffer.getUByte();
            switch (type) {
                case 1: {
                    attrs.put("isRegular", Boolean.TRUE);
                    break;
                }
                case 2: {
                    attrs.put("isDirectory", Boolean.TRUE);
                    break;
                }
                case 3: {
                    attrs.put("isSymbolicLink", Boolean.TRUE);
                    break;
                }
                case 5: {
                    attrs.put("isOther", Boolean.TRUE);
                    break;
                }
            }
        }
        if ((flags & 1) != 0) {
            attrs.put("size", buffer.getLong());
        }
        if ((flags & 0x400) != 0) {
            attrs.put("allocationSize", buffer.getLong());
        }
        if ((flags & 2) != 0) {
            attrs.put("uid", buffer.getInt());
            attrs.put("gid", buffer.getInt());
        }
        if ((flags & 0x80) != 0) {
            attrs.put("owner", new DefaultGroupPrincipal(buffer.getString()));
            attrs.put("group", new DefaultGroupPrincipal(buffer.getString()));
        }
        if ((flags & 4) != 0) {
            attrs.put("permissions", SftpHelper.permissionsToAttributes(buffer.getInt()));
        }
        if (version == 3) {
            if ((flags & 8) != 0) {
                attrs.put("lastAccessTime", SftpHelper.readTime(buffer, flags));
                attrs.put("lastModifiedTime", SftpHelper.readTime(buffer, flags));
            }
        } else if (version >= 4) {
            if ((flags & 8) != 0) {
                attrs.put("lastAccessTime", SftpHelper.readTime(buffer, flags));
            }
            if ((flags & 0x10) != 0) {
                attrs.put("creationTime", SftpHelper.readTime(buffer, flags));
            }
            if ((flags & 0x20) != 0) {
                attrs.put("lastModifiedTime", SftpHelper.readTime(buffer, flags));
            }
            if ((flags & 0x8000) != 0) {
                attrs.put("ctime", SftpHelper.readTime(buffer, flags));
            }
        }
        if ((flags & 0x40) != 0) {
            int count = buffer.getInt();
            ArrayList<AclEntry> acls = new ArrayList<AclEntry>();
            for (i = 0; i < count; ++i) {
                int aclType = buffer.getInt();
                int aclFlag = buffer.getInt();
                int aclMask = buffer.getInt();
                String aclWho = buffer.getString();
                acls.add(SftpHelper.buildAclEntry(aclType, aclFlag, aclMask, aclWho));
            }
            attrs.put("acl", acls);
        }
        if ((flags & 0x200) != 0) {
            bits2 = buffer.getInt();
            int valid = -1;
            if (version >= 6) {
                valid = buffer.getInt();
            }
        }
        if ((flags & 0x800) != 0) {
            bits2 = buffer.getBoolean() ? 1 : 0;
        }
        if ((flags & 0x1000) != 0) {
            String bits2 = buffer.getString();
        }
        if ((flags & 0x2000) != 0) {
            int bits2 = buffer.getInt();
        }
        if ((flags & 0x4000) != 0) {
            String bits2 = buffer.getString();
        }
        if ((flags & Integer.MIN_VALUE) != 0) {
            int count = buffer.getInt();
            HashMap<String, String> extended = new HashMap<String, String>();
            for (i = 0; i < count; ++i) {
                String key = buffer.getString();
                String val = buffer.getString();
                extended.put(key, val);
            }
            attrs.put("extended", extended);
        }
        return attrs;
    }

    private static FileTime readTime(Buffer buffer, int flags) {
        long secs = buffer.getLong();
        long millis = secs * 1000L;
        if ((flags & 0x100) != 0) {
            millis += (long)buffer.getInt() / 1000000L;
        }
        return FileTime.from(millis, TimeUnit.MILLISECONDS);
    }
}

