/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.sshd.common.AbstractFactoryManager;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.FactoryManagerUtils;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.ServiceFactory;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.mina.MinaServiceFactory;
import org.apache.sshd.common.io.nio2.Nio2ServiceFactory;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.ServerBuilder;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.auth.UserAuth;
import org.apache.sshd.server.auth.UserAuthKeyboardInteractiveFactory;
import org.apache.sshd.server.auth.UserAuthPasswordFactory;
import org.apache.sshd.server.auth.UserAuthPublicKeyFactory;
import org.apache.sshd.server.auth.gss.GSSAuthenticator;
import org.apache.sshd.server.auth.gss.UserAuthGSSFactory;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.pubkey.AcceptAllPublickeyAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.command.ScpCommandFactory;
import org.apache.sshd.server.forward.AcceptAllForwardingFilter;
import org.apache.sshd.server.forward.ForwardingFilter;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.session.ServerConnectionServiceFactory;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.session.ServerUserAuthServiceFactory;
import org.apache.sshd.server.session.SessionFactory;
import org.apache.sshd.server.shell.InteractiveProcessShellFactory;
import org.apache.sshd.server.shell.ProcessShellFactory;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystemFactory;

public class SshServer
extends AbstractFactoryManager
implements ServerFactoryManager,
Closeable {
    public static final Factory<SshServer> DEFAULT_SSH_SERVER_FACTORY = new Factory<SshServer>(){

        @Override
        public SshServer create() {
            return new SshServer();
        }
    };
    public static final List<ServiceFactory> DEFAULT_SERVICE_FACTORIES = Collections.unmodifiableList(Arrays.asList(ServerUserAuthServiceFactory.INSTANCE, ServerConnectionServiceFactory.INSTANCE));
    public static final UserAuthPublicKeyFactory DEFAULT_USER_AUTH_PUBLIC_KEY_FACTORY = UserAuthPublicKeyFactory.INSTANCE;
    public static final UserAuthGSSFactory DEFAULT_USER_AUTH_GSS_FACTORY = UserAuthGSSFactory.INSTANCE;
    public static final UserAuthPasswordFactory DEFAULT_USER_AUTH_PASSWORD_FACTORY = UserAuthPasswordFactory.INSTANCE;
    public static final UserAuthKeyboardInteractiveFactory DEFAULT_USER_AUTH_KB_INTERACTIVE_FACTORY = UserAuthKeyboardInteractiveFactory.INSTANCE;
    protected IoAcceptor acceptor;
    protected String host;
    protected int port;
    protected List<NamedFactory<UserAuth>> userAuthFactories;
    protected Factory<Command> shellFactory;
    protected SessionFactory sessionFactory;
    protected CommandFactory commandFactory;
    protected List<NamedFactory<Command>> subsystemFactories;
    protected PasswordAuthenticator passwordAuthenticator;
    protected PublickeyAuthenticator publickeyAuthenticator;
    protected GSSAuthenticator gssAuthenticator;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public List<NamedFactory<UserAuth>> getUserAuthFactories() {
        return this.userAuthFactories;
    }

    public void setUserAuthFactories(List<NamedFactory<UserAuth>> userAuthFactories) {
        this.userAuthFactories = userAuthFactories;
    }

    @Override
    public Factory<Command> getShellFactory() {
        return this.shellFactory;
    }

    public void setShellFactory(Factory<Command> shellFactory) {
        this.shellFactory = shellFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public CommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    public void setCommandFactory(CommandFactory commandFactory) {
        this.commandFactory = commandFactory;
    }

    @Override
    public List<NamedFactory<Command>> getSubsystemFactories() {
        return this.subsystemFactories;
    }

    public void setSubsystemFactories(List<NamedFactory<Command>> subsystemFactories) {
        this.subsystemFactories = subsystemFactories;
    }

    @Override
    public PasswordAuthenticator getPasswordAuthenticator() {
        return this.passwordAuthenticator;
    }

    public void setPasswordAuthenticator(PasswordAuthenticator passwordAuthenticator) {
        this.passwordAuthenticator = passwordAuthenticator;
    }

    @Override
    public PublickeyAuthenticator getPublickeyAuthenticator() {
        return this.publickeyAuthenticator;
    }

    public void setPublickeyAuthenticator(PublickeyAuthenticator publickeyAuthenticator) {
        this.publickeyAuthenticator = publickeyAuthenticator;
    }

    @Override
    public GSSAuthenticator getGSSAuthenticator() {
        return this.gssAuthenticator;
    }

    public void setGSSAuthenticator(GSSAuthenticator gssAuthenticator) {
        this.gssAuthenticator = gssAuthenticator;
    }

    @Override
    public void setTcpipForwardingFilter(ForwardingFilter forwardingFilter) {
        this.tcpipForwardingFilter = forwardingFilter;
    }

    @Override
    protected void checkConfig() {
        super.checkConfig();
        ValidateUtils.checkTrue(this.getPort() >= 0, "Bad port number: %d", (Object)this.getPort());
        if (GenericUtils.isEmpty(this.getUserAuthFactories())) {
            ArrayList<NamedFactory<UserAuth>> factories = new ArrayList<NamedFactory<UserAuth>>();
            if (this.getPasswordAuthenticator() != null) {
                factories.add(DEFAULT_USER_AUTH_PASSWORD_FACTORY);
                factories.add(DEFAULT_USER_AUTH_KB_INTERACTIVE_FACTORY);
            }
            if (this.getPublickeyAuthenticator() != null) {
                factories.add(DEFAULT_USER_AUTH_PUBLIC_KEY_FACTORY);
            }
            if (this.getGSSAuthenticator() != null) {
                factories.add(DEFAULT_USER_AUTH_GSS_FACTORY);
            }
            ValidateUtils.checkTrue(factories.size() > 0, "UserAuthFactories not set");
            this.setUserAuthFactories(factories);
        }
        ValidateUtils.checkNotNullAndNotEmpty(this.getChannelFactories(), "ChannelFactories not set", new Object[0]);
        ValidateUtils.checkNotNull(this.getKeyPairProvider(), "HostKeyProvider not set");
        ValidateUtils.checkNotNull(this.getFileSystemFactory(), "FileSystemFactory not set");
        if (GenericUtils.isEmpty(this.getServiceFactories())) {
            this.setServiceFactories(DEFAULT_SERVICE_FACTORIES);
        }
    }

    public void start() throws IOException {
        this.checkConfig();
        if (this.sessionFactory == null) {
            this.sessionFactory = this.createSessionFactory();
        }
        this.sessionFactory.setServer(this);
        this.acceptor = this.createAcceptor();
        this.setupSessionTimeout(this.sessionFactory);
        String hostsList = this.getHost();
        if (!GenericUtils.isEmpty(hostsList)) {
            String[] hosts;
            for (String host : hosts = GenericUtils.split(hostsList, ',')) {
                InetAddress[] inetAddresses;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("start() - resolve bind host={}", (Object)host);
                }
                for (InetAddress inetAddress : inetAddresses = InetAddress.getAllByName(host)) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("start() - bind host={} / {}", (Object)host, (Object)inetAddress);
                    }
                    this.acceptor.bind(new InetSocketAddress(inetAddress, this.port));
                    if (this.port != 0) continue;
                    this.port = ((InetSocketAddress)this.acceptor.getBoundAddresses().iterator().next()).getPort();
                    this.log.info("start() listen on auto-allocated port=" + this.port);
                }
            }
        } else {
            this.acceptor.bind(new InetSocketAddress(this.port));
            if (this.port == 0) {
                this.port = ((InetSocketAddress)this.acceptor.getBoundAddresses().iterator().next()).getPort();
                this.log.info("start() listen on auto-allocated port=" + this.port);
            }
        }
    }

    public void stop() throws IOException {
        this.stop(false);
    }

    public void stop(boolean immediately) throws IOException {
        this.close(immediately).await();
    }

    public void open() throws IOException {
        this.start();
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().run(new Runnable(){

            @Override
            public void run() {
                SshServer.this.removeSessionTimeout(SshServer.this.sessionFactory);
            }
        }).sequential(this.acceptor, this.ioServiceFactory).run(new Runnable(){

            @Override
            public void run() {
                SshServer.this.acceptor = null;
                SshServer.this.ioServiceFactory = null;
                if (SshServer.this.shutdownExecutor && SshServer.this.executor != null && !SshServer.this.executor.isShutdown()) {
                    try {
                        SshServer.this.executor.shutdownNow();
                    }
                    finally {
                        SshServer.this.executor = null;
                    }
                }
            }
        }).build();
    }

    public List<AbstractSession> getActiveSessions() {
        ArrayList<AbstractSession> sessions = new ArrayList<AbstractSession>();
        for (IoSession ioSession : this.acceptor.getManagedSessions().values()) {
            AbstractSession session = AbstractSession.getSession(ioSession, true);
            if (session == null) continue;
            sessions.add(session);
        }
        return sessions;
    }

    protected IoAcceptor createAcceptor() {
        return this.getIoServiceFactory().createAcceptor(this.getSessionFactory());
    }

    protected SessionFactory createSessionFactory() {
        return new SessionFactory();
    }

    public String toString() {
        return "SshServer[" + Integer.toHexString(this.hashCode()) + "]";
    }

    public static SshServer setUpDefaultServer() {
        return (SshServer)ServerBuilder.builder().build();
    }

    public static void main(String[] args) throws Exception {
        int port = 8000;
        boolean error = false;
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        int numArgs = GenericUtils.length(args);
        for (int i = 0; i < numArgs; ++i) {
            String argName = args[i];
            if ("-p".equals(argName)) {
                if (i + 1 >= numArgs) {
                    System.err.println("option requires an argument: " + argName);
                    break;
                }
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-io".equals(argName)) {
                String provider;
                if (i + 1 >= numArgs) {
                    System.err.println("option requires an argument: " + argName);
                    break;
                }
                if ("mina".equals(provider = args[++i])) {
                    System.setProperty(IoServiceFactory.class.getName(), MinaServiceFactory.class.getName());
                    continue;
                }
                if ("nio2".endsWith(provider)) {
                    System.setProperty(IoServiceFactory.class.getName(), Nio2ServiceFactory.class.getName());
                    continue;
                }
                System.err.println("provider should be mina or nio2: " + argName);
                break;
            }
            if ("-o".equals(argName)) {
                String opt;
                int idx;
                if (i + 1 >= numArgs) {
                    System.err.println("option requires and argument: " + argName);
                    error = true;
                    break;
                }
                if ((idx = (opt = args[++i]).indexOf(61)) <= 0) {
                    System.err.println("bad syntax for option: " + opt);
                    error = true;
                    break;
                }
                options.put(opt.substring(0, idx), opt.substring(idx + 1));
                continue;
            }
            if (argName.startsWith("-")) {
                System.err.println("illegal option: " + argName);
                error = true;
                break;
            }
            System.err.println("extra argument: " + argName);
            error = true;
            break;
        }
        if (error) {
            System.err.println("usage: sshd [-p port] [-io mina|nio2] [-o option=value]");
            System.exit(-1);
        }
        System.err.println("Starting SSHD on port " + port);
        SshServer sshd = SshServer.setUpDefaultServer();
        Map<String, Object> props = sshd.getProperties();
        FactoryManagerUtils.updateProperty(props, "welcome-banner", (Object)"Welcome to SSHD\n");
        props.putAll(options);
        sshd.setPort(port);
        if (SecurityUtils.isBouncyCastleRegistered()) {
            sshd.setKeyPairProvider(SecurityUtils.createGeneratorHostKeyProvider(new File("key.pem").toPath()));
        } else {
            sshd.setKeyPairProvider(new SimpleGeneratorHostKeyProvider(new File("key.ser")));
        }
        sshd.setShellFactory(new InteractiveProcessShellFactory());
        sshd.setPasswordAuthenticator(new PasswordAuthenticator(){

            @Override
            public boolean authenticate(String username, String password, ServerSession session) {
                return username != null && username.equals(password);
            }
        });
        sshd.setPublickeyAuthenticator(AcceptAllPublickeyAuthenticator.INSTANCE);
        sshd.setTcpipForwardingFilter(AcceptAllForwardingFilter.INSTANCE);
        sshd.setCommandFactory(new ScpCommandFactory.Builder().withDelegate(new CommandFactory(){

            @Override
            public Command createCommand(String command) {
                return new ProcessShellFactory(GenericUtils.split(command, ' ')).create();
            }
        }).build());
        sshd.setSubsystemFactories(Arrays.asList(new SftpSubsystemFactory()));
        sshd.start();
        Thread.sleep(Long.MAX_VALUE);
    }
}

