/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.common;

import java.io.IOException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.List;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.util.Pair;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public abstract class AbstractAgentClient
extends AbstractLoggingBean {
    private final Buffer buffer = new ByteArrayBuffer();
    private final SshAgent agent;

    protected AbstractAgentClient(SshAgent agent) {
        this.agent = agent;
    }

    public synchronized void messageReceived(Buffer message) throws IOException {
        this.buffer.putBuffer(message);
        int avail = this.buffer.available();
        if (avail < 4) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Received message total length ({}) below minuimum ({})", (Object)avail, (Object)4);
            }
            return;
        }
        int rpos = this.buffer.rpos();
        int len = this.buffer.getInt();
        this.buffer.rpos(rpos);
        avail = this.buffer.available();
        if (avail < len + 4) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Received request length ({}) below minuimum ({})", (Object)avail, (Object)(len + 4));
            }
            return;
        }
        Buffer rep = BufferUtils.clear(message);
        rep.putInt(0L);
        rep.rpos(rep.wpos());
        ByteArrayBuffer req = new ByteArrayBuffer(this.buffer.getBytes());
        int cmd = -1;
        try {
            cmd = req.getUByte();
            this.process(cmd, req, rep);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed ({}) to handle command={}: {}", new Object[]{e.getClass().getSimpleName(), cmd, e.getMessage()});
            }
            rep.clear();
            rep.putInt(0L);
            rep.rpos(rep.wpos());
            rep.putInt(1L);
            rep.putByte((byte)30);
        }
        this.reply(this.prepare(rep));
    }

    protected void process(int cmd, Buffer req, Buffer rep) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("process(cmd={})", (Object)cmd);
        }
        switch (cmd) {
            case 11: {
                List<Pair<PublicKey, String>> keys = this.agent.getIdentities();
                rep.putByte((byte)12);
                rep.putInt(keys.size());
                for (Pair<PublicKey, String> key : keys) {
                    rep.putPublicKey(key.getFirst());
                    rep.putString(key.getSecond());
                }
                break;
            }
            case 13: {
                PublicKey signingKey = req.getPublicKey();
                byte[] data = req.getBytes();
                int flags = req.getInt();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("SSH2_AGENTC_SIGN_REQUEST key={}, flags=0x{}, data={}", new Object[]{signingKey.getAlgorithm(), Integer.toHexString(flags), BufferUtils.printHex(':', data)});
                }
                String keyType = ValidateUtils.checkNotNullAndNotEmpty(KeyUtils.getKeyType(signingKey), "Cannot resolve key type of %s", (Object)signingKey.getClass().getSimpleName());
                ByteArrayBuffer sig = new ByteArrayBuffer();
                sig.putString(keyType);
                sig.putBytes(this.agent.sign(signingKey, data));
                rep.putByte((byte)14);
                rep.putBytes(((Buffer)sig).array(), ((Buffer)sig).rpos(), sig.available());
                break;
            }
            case 17: {
                KeyPair keyToAdd = req.getKeyPair();
                String comment = req.getString();
                this.log.debug("SSH2_AGENTC_ADD_IDENTITY comment={}", (Object)comment);
                this.agent.addIdentity(keyToAdd, comment);
                rep.putByte((byte)6);
                break;
            }
            case 18: {
                PublicKey keyToRemove = req.getPublicKey();
                this.log.debug("SSH2_AGENTC_REMOVE_IDENTITY {}", (Object)keyToRemove.getClass().getSimpleName());
                this.agent.removeIdentity(keyToRemove);
                rep.putByte((byte)6);
                break;
            }
            case 19: {
                this.agent.removeAllIdentities();
                rep.putByte((byte)6);
                break;
            }
            default: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Unknown command: {}", (Object)cmd);
                }
                rep.putByte((byte)30);
            }
        }
    }

    protected Buffer prepare(Buffer buf) {
        int len = buf.available();
        int rpos = buf.rpos();
        int wpos = buf.wpos();
        buf.rpos(rpos - 4);
        buf.wpos(rpos - 4);
        buf.putInt(len);
        buf.wpos(wpos);
        return buf;
    }

    protected abstract void reply(Buffer var1) throws IOException;
}

