/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit;

import org.apache.commons.lang.StringUtils;
import org.apache.ftpserver.ftplet.Authentication;
import org.apache.ftpserver.ftplet.AuthenticationFailedException;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.usermanager.AnonymousAuthentication;
import org.apache.ftpserver.usermanager.UsernamePasswordAuthentication;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.mule.munit.MockUser;

public class MockUserManagerAuthenticator
implements UserManager,
PasswordAuthenticator {
    private static final String ADMIN_NAME = "mock";
    private static final String ANONYMOUS_USERNAME = "anonymous";
    private static final String EMPTY_STRING = "";
    private MockUser user;
    private MockUser anonymousUser = new MockUser("anonymous", "");
    private MockUser emptyUser = new MockUser("", "");
    private boolean anonymous;

    public MockUserManagerAuthenticator(String username, String password, boolean anonymous, String homeDir) {
        this.anonymous = anonymous;
        this.enforceMinimumConfigurationIsSetUp(username, password, anonymous);
        this.user = this.isUsernameOrPasswordNull(username, password) ? this.emptyUser : new MockUser(username, password);
        this.setHomeDirectoryToUsers(homeDir);
    }

    private void enforceMinimumConfigurationIsSetUp(String username, String password, boolean anonymous) {
        if (!anonymous && this.isUsernameOrPasswordNullOrEmpty(username, password)) {
            throw new RuntimeException("Username and password must be defined on the FTP server configuration");
        }
    }

    private boolean isUsernameOrPasswordNullOrEmpty(String username, String password) {
        return this.isUsernameOrPasswordNull(username, password) || this.isUsernameOrPasswordEmpty(username, password);
    }

    private boolean isUsernameOrPasswordEmpty(String username, String password) {
        return StringUtils.isBlank((String)username) || password.equals(EMPTY_STRING);
    }

    private boolean isUsernameOrPasswordNull(String username, String password) {
        return username == null || password == null;
    }

    public User getUserByName(String name) throws FtpException {
        if (StringUtils.equals((String)name, (String)ANONYMOUS_USERNAME)) {
            return this.anonymousUser;
        }
        if (this.doesExist(name)) {
            return this.user;
        }
        return this.emptyUser;
    }

    public String[] getAllUserNames() throws FtpException {
        return new String[]{this.user.getName()};
    }

    public void delete(String s) throws FtpException {
    }

    public void save(User user) throws FtpException {
    }

    public boolean doesExist(String name) throws FtpException {
        return StringUtils.equals((String)name, (String)this.user.getName());
    }

    public User authenticate(Authentication authentication) throws AuthenticationFailedException {
        if (this.anonymous) {
            return this.getAnonymousOrEmptyUserBasedOnAuthentication(authentication);
        }
        return this.getUserBasedOnUsernamePasswordAuthentication(authentication);
    }

    private User getUserBasedOnUsernamePasswordAuthentication(Authentication authentication) {
        if (!this.isUserTryingToLoginAsAnonymous(authentication) && this.isUserNameAndPasswordAuthentication(authentication) && this.doesUsernameAndPasswordMatch(authentication)) {
            return this.user;
        }
        return null;
    }

    private User getAnonymousOrEmptyUserBasedOnAuthentication(Authentication authentication) {
        return this.isUserTryingToLoginAsAnonymous(authentication) ? this.anonymousUser : this.emptyUser;
    }

    private boolean isUserTryingToLoginAsAnonymous(Authentication authentication) {
        return authentication instanceof AnonymousAuthentication;
    }

    private boolean doesUsernameAndPasswordMatch(Authentication authentication) {
        UsernamePasswordAuthentication usernamePasswordAuth = (UsernamePasswordAuthentication)authentication;
        return usernamePasswordAuth.getUsername().equals(this.user.getName()) && usernamePasswordAuth.getPassword().equals(this.user.getPassword());
    }

    private boolean isUserNameAndPasswordAuthentication(Authentication authentication) {
        return authentication instanceof UsernamePasswordAuthentication;
    }

    public String getAdminName() throws FtpException {
        return ADMIN_NAME;
    }

    public boolean isAdmin(String s) throws FtpException {
        return true;
    }

    public void setHomeDirectoryToUsers(String homeDir) {
        this.user.setHomeDirectory(homeDir);
        this.anonymousUser.setHomeDirectory(homeDir);
        this.emptyUser.setHomeDirectory(homeDir);
    }

    public boolean authenticate(String username, String password, ServerSession session) {
        return this.anonymous || this.nameAndPasswordMatch(username, password);
    }

    private boolean nameAndPasswordMatch(String name, String password) {
        return this.user.getName().equals(name) && this.user.getPassword().equals(password);
    }
}

