/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.command;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.sshd.common.file.FileSystemAware;
import org.apache.sshd.common.scp.ScpHelper;
import org.apache.sshd.common.scp.ScpTransferEventListener;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;

public class ScpCommand
extends AbstractLoggingBean
implements Command,
Runnable,
FileSystemAware {
    protected String name;
    protected boolean optR;
    protected boolean optT;
    protected boolean optF;
    protected boolean optD;
    protected boolean optP;
    protected FileSystem fileSystem;
    protected String path;
    protected InputStream in;
    protected OutputStream out;
    protected OutputStream err;
    protected ExitCallback callback;
    protected IOException error;
    protected ExecutorService executors;
    protected boolean shutdownExecutor;
    protected Future<?> pendingFuture;
    protected int sendBufferSize;
    protected int receiveBufferSize;
    protected ScpTransferEventListener listener;

    public ScpCommand(String command, ExecutorService executorService, boolean shutdownOnExit, int sendSize, int receiveSize, ScpTransferEventListener eventListener) {
        this.name = command;
        if (executorService == null) {
            String poolName = command.replace(' ', '_').replace('/', ':');
            this.executors = ThreadUtils.newSingleThreadExecutor(poolName);
            this.shutdownExecutor = true;
        } else {
            this.executors = executorService;
            this.shutdownExecutor = shutdownOnExit;
        }
        if (sendSize < 127) {
            throw new IllegalArgumentException("<ScpCommmand>(" + command + ") send buffer size " + "(" + sendSize + ") below minimum required " + "(" + 127 + ")");
        }
        this.sendBufferSize = sendSize;
        if (receiveSize < 127) {
            throw new IllegalArgumentException("<ScpCommmand>(" + command + ") receive buffer size " + "(" + sendSize + ") below minimum required " + "(" + 127 + ")");
        }
        this.receiveBufferSize = receiveSize;
        this.listener = eventListener == null ? ScpTransferEventListener.EMPTY : eventListener;
        this.log.debug("Executing command {}", (Object)command);
        String[] args = command.split(" ");
        for (int i = 1; i < args.length; ++i) {
            String argVal = args[i];
            if (argVal.charAt(0) == '-') {
                block8: for (int j = 1; j < argVal.length(); ++j) {
                    char option = argVal.charAt(j);
                    switch (option) {
                        case 'f': {
                            this.optF = true;
                            continue block8;
                        }
                        case 'p': {
                            this.optP = true;
                            continue block8;
                        }
                        case 'r': {
                            this.optR = true;
                            continue block8;
                        }
                        case 't': {
                            this.optT = true;
                            continue block8;
                        }
                        case 'd': {
                            this.optD = true;
                            continue block8;
                        }
                    }
                }
                continue;
            }
            String prevArg = args[i - 1];
            this.path = command.substring(command.indexOf(prevArg) + prevArg.length() + 1);
            if ((!this.path.startsWith("\"") || !this.path.endsWith("\"")) && (!this.path.startsWith("'") || !this.path.endsWith("'"))) break;
            this.path = this.path.substring(1, this.path.length() - 1);
            break;
        }
        if (!this.optF && !this.optT) {
            this.error = new IOException("Either -f or -t option should be set for " + command);
        }
    }

    @Override
    public void setInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    @Override
    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    @Override
    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    @Override
    public void setFileSystem(FileSystem fs) {
        this.fileSystem = fs;
    }

    @Override
    public void start(Environment env) throws IOException {
        if (this.error != null) {
            throw this.error;
        }
        try {
            this.pendingFuture = this.executors.submit(this);
        }
        catch (RuntimeException e) {
            this.log.error("Failed (" + e.getClass().getSimpleName() + ") to start command=" + this.name + ": " + e.getMessage(), (Throwable)e);
            throw new IOException(e);
        }
    }

    @Override
    public void destroy() {
        if (this.pendingFuture != null && !this.pendingFuture.isDone()) {
            boolean result = this.pendingFuture.cancel(true);
            if (this.log.isDebugEnabled()) {
                this.log.debug("destroy() - cancel pending future=" + result);
            }
        }
        this.pendingFuture = null;
        if (this.executors != null && !this.executors.isShutdown() && this.shutdownExecutor) {
            List<Runnable> runners = this.executors.shutdownNow();
            if (this.log.isDebugEnabled()) {
                this.log.debug("destroy() - shutdown executor service - runners count=" + runners.size());
            }
        }
        this.executors = null;
        try {
            this.fileSystem.close();
        }
        catch (UnsupportedOperationException runners) {
        }
        catch (IOException e) {
            this.log.debug("Error closing FileSystem", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block10: {
            int exitValue = 0;
            String exitMessage = null;
            ScpHelper helper = new ScpHelper(this.in, this.out, this.fileSystem, this.listener);
            try {
                if (this.optT) {
                    helper.receive(helper.resolveLocalPath(this.path), this.optR, this.optD, this.optP, this.receiveBufferSize);
                    break block10;
                }
                if (this.optF) {
                    helper.send(Collections.singletonList(this.path), this.optR, this.optP, this.sendBufferSize);
                    break block10;
                }
                throw new IOException("Unsupported mode");
            }
            catch (IOException e) {
                try {
                    exitValue = 2;
                    exitMessage = GenericUtils.trimToEmpty(e.getMessage());
                    this.out.write(exitValue);
                    this.out.write(exitMessage.getBytes(StandardCharsets.UTF_8));
                    this.out.write(10);
                    this.out.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.log.info("Error in scp command=" + this.name, (Throwable)e);
            }
            finally {
                if (this.callback != null) {
                    this.callback.onExit(exitValue, GenericUtils.trimToEmpty(exitMessage));
                }
            }
        }
    }

    public String toString() {
        return this.name;
    }
}

