/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.listener.nio;

import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import org.apache.ftpserver.DataConnectionConfiguration;
import org.apache.ftpserver.listener.Listener;
import org.apache.ftpserver.ssl.SslConfiguration;
import org.apache.mina.filter.firewall.Subnet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListener
implements Listener {
    private String serverAddress;
    private int port = 21;
    private SslConfiguration ssl;
    private boolean implicitSsl = false;
    private int idleTimeout;
    private List<InetAddress> blockedAddresses;
    private List<Subnet> blockedSubnets;
    private DataConnectionConfiguration dataConnectionConfig;

    public AbstractListener(String serverAddress, int port, boolean implicitSsl, SslConfiguration sslConfiguration, DataConnectionConfiguration dataConnectionConfig, int idleTimeout, List<InetAddress> blockedAddresses, List<Subnet> blockedSubnets) {
        this.serverAddress = serverAddress;
        this.port = port;
        this.implicitSsl = implicitSsl;
        this.dataConnectionConfig = dataConnectionConfig;
        this.ssl = sslConfiguration;
        this.idleTimeout = idleTimeout;
        if (blockedAddresses != null) {
            this.blockedAddresses = Collections.unmodifiableList(blockedAddresses);
        }
        if (blockedSubnets != null) {
            this.blockedSubnets = Collections.unmodifiableList(blockedSubnets);
        }
    }

    @Override
    public boolean isImplicitSsl() {
        return this.implicitSsl;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    protected void setPort(int port) {
        this.port = port;
    }

    @Override
    public String getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public SslConfiguration getSslConfiguration() {
        return this.ssl;
    }

    @Override
    public DataConnectionConfiguration getDataConnectionConfiguration() {
        return this.dataConnectionConfig;
    }

    @Override
    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public List<InetAddress> getBlockedAddresses() {
        return this.blockedAddresses;
    }

    @Override
    public List<Subnet> getBlockedSubnets() {
        return this.blockedSubnets;
    }
}

