/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.channel;

import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelRequestHandler;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class PuttyRequestHandler
extends AbstractLoggingBean
implements ChannelRequestHandler {
    public static final String REQUEST_SUFFIX = "@putty.projects.tartarus.org";

    @Override
    public RequestHandler.Result process(Channel channel, String request, boolean wantReply, Buffer buffer) throws Exception {
        if (GenericUtils.length(request) <= REQUEST_SUFFIX.length() || !request.endsWith(REQUEST_SUFFIX)) {
            return RequestHandler.Result.Unsupported;
        }
        String opcode = request.substring(0, request.length() - REQUEST_SUFFIX.length());
        return this.processPuttyOpcode(channel, request, opcode, wantReply, buffer);
    }

    protected RequestHandler.Result processPuttyOpcode(Channel channel, String request, String opcode, boolean wantReply, Buffer buffer) throws Exception {
        if ("simple".equalsIgnoreCase(opcode)) {
            return RequestHandler.Result.ReplySuccess;
        }
        if ("winadj".equalsIgnoreCase(opcode)) {
            return RequestHandler.Result.ReplyFailure;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("processPuttyOpcode(" + opcode + ")" + "[buffer size=" + buffer.available() + "]" + "[reply=" + wantReply + "]" + " Unknown request: " + request);
        }
        return RequestHandler.Result.ReplyFailure;
    }
}

