/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.local;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.common.AbstractAgentProxy;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;

public class AgentForwardedChannel
extends AbstractClientChannel {
    private final Queue<Buffer> messages = new ArrayBlockingQueue<Buffer>(10);
    private final Buffer receiveBuffer = new ByteArrayBuffer();

    public AgentForwardedChannel() {
        super("auth-agent@openssh.com");
    }

    public SshAgent getAgent() {
        return new AbstractAgentProxy(){
            private final AtomicBoolean open = new AtomicBoolean(true);

            @Override
            public boolean isOpen() {
                return this.open.get();
            }

            @Override
            protected Buffer request(Buffer buffer) throws IOException {
                return AgentForwardedChannel.this.request(buffer);
            }

            @Override
            public void close() throws IOException {
                if (this.open.getAndSet(false)) {
                    AgentForwardedChannel.this.close(false);
                    super.close();
                }
            }
        };
    }

    protected Buffer request(Buffer buffer) throws IOException {
        Queue<Buffer> queue = this.messages;
        synchronized (queue) {
            try {
                OutputStream outputStream = this.getInvertedIn();
                outputStream.write(buffer.array(), buffer.rpos(), buffer.available());
                outputStream.flush();
                this.localWindow.consumeAndCheck(buffer.available());
                if (this.messages.isEmpty()) {
                    this.messages.wait();
                }
                return this.messages.poll();
            }
            catch (InterruptedException e) {
                throw (IOException)new InterruptedIOException("Interrupted while polling for messages").initCause(e);
            }
        }
    }

    @Override
    protected void doOpen() throws IOException {
        if (this.streaming == ClientChannel.Streaming.Async) {
            throw new IllegalArgumentException("Asynchronous streaming isn't supported yet on this channel");
        }
        this.invertedIn = new ChannelOutputStream(this, this.remoteWindow, this.log, 94);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doWriteData(byte[] data, int off, int len) throws IOException {
        ByteArrayBuffer message = null;
        Object object = this.receiveBuffer;
        synchronized (object) {
            this.receiveBuffer.putBuffer(new ByteArrayBuffer(data, off, len));
            if (this.receiveBuffer.available() >= 4) {
                off = this.receiveBuffer.rpos();
                len = this.receiveBuffer.getInt();
                this.receiveBuffer.rpos(off);
                if (this.receiveBuffer.available() >= 4 + len) {
                    message = new ByteArrayBuffer(this.receiveBuffer.getBytes());
                    this.receiveBuffer.compact();
                }
            }
        }
        if (message != null) {
            object = this.messages;
            synchronized (object) {
                this.messages.offer(message);
                this.messages.notifyAll();
            }
        }
    }
}

