/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.future;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class DefaultSshFuture<T extends SshFuture>
extends AbstractLoggingBean
implements SshFuture<T> {
    private static final Object CANCELED = new Object();
    private static final Object NULL = new Object();
    private final Object lock;
    private Object listeners;
    private Object result;

    public DefaultSshFuture(Object lock) {
        this.lock = lock != null ? lock : this;
    }

    @Override
    public T await() throws IOException {
        if (this.await(Long.MAX_VALUE)) {
            return this.asT();
        }
        throw new SshException("No result while await completion");
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws IOException {
        return this.await(unit.toMillis(timeout));
    }

    @Override
    public boolean await(long timeoutMillis) throws IOException {
        return this.await0(timeoutMillis, true) != null;
    }

    @Override
    public T awaitUninterruptibly() {
        try {
            this.await0(Long.MAX_VALUE, false);
        }
        catch (InterruptedIOException interruptedIOException) {
            // empty catch block
        }
        return this.asT();
    }

    @Override
    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        return this.awaitUninterruptibly(unit.toMillis(timeout));
    }

    @Override
    public boolean awaitUninterruptibly(long timeoutMillis) {
        try {
            return this.await0(timeoutMillis, false) != null;
        }
        catch (InterruptedIOException e) {
            throw (InternalError)new InternalError("Unexpected interrupted exception wile awaitUninterruptibly " + timeoutMillis + " msec.: " + e.getMessage()).initCause(e);
        }
    }

    protected <R> R verifyResult(Class<? extends R> expectedType, long timeout) throws IOException {
        Object value = this.await0(timeout, true);
        if (value == null) {
            throw new SshException("Failed to get operation result within specified timeout: " + timeout);
        }
        Class<?> actualType = value.getClass();
        if (expectedType.isAssignableFrom(actualType)) {
            return expectedType.cast(value);
        }
        if (IOException.class.isAssignableFrom(actualType)) {
            throw (IOException)value;
        }
        if (Throwable.class.isAssignableFrom(actualType)) {
            Throwable t = (Throwable)value;
            throw new SshException("Failed (" + t.getClass().getSimpleName() + ") to execute: " + t.getMessage(), GenericUtils.resolveExceptionCause(t));
        }
        throw new StreamCorruptedException("Unknown result type: " + actualType.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object await0(long timeoutMillis, boolean interruptable) throws InterruptedIOException {
        long startTime;
        ValidateUtils.checkTrue(timeoutMillis >= 0L, "Negative timeout N/A: %d", (Object)timeoutMillis);
        long curTime = startTime = System.currentTimeMillis();
        long endTime = Long.MAX_VALUE - timeoutMillis < curTime ? Long.MAX_VALUE : curTime + timeoutMillis;
        Object object = this.lock;
        synchronized (object) {
            if (this.result != null || timeoutMillis <= 0L) {
                return this.result;
            }
            do {
                block7: {
                    try {
                        this.lock.wait(endTime - curTime);
                    }
                    catch (InterruptedException e) {
                        if (!interruptable) break block7;
                        curTime = System.currentTimeMillis();
                        throw (InterruptedIOException)new InterruptedIOException("Interrupted after " + (curTime - startTime) + " msec.").initCause(e);
                    }
                }
                curTime = System.currentTimeMillis();
            } while (this.result == null && curTime < endTime);
            return this.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.lock;
        synchronized (object) {
            return this.result != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Object newValue) {
        Object object = this.lock;
        synchronized (object) {
            if (this.result != null) {
                return;
            }
            this.result = newValue != null ? newValue : NULL;
            this.lock.notifyAll();
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getValue() {
        Object object = this.lock;
        synchronized (object) {
            return this.result == NULL ? null : this.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T addListener(SshFutureListener<T> listener) {
        ValidateUtils.checkNotNull(listener, "Missing listener argument");
        boolean notifyNow = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.result != null) {
                notifyNow = true;
            } else if (this.listeners == null) {
                this.listeners = listener;
            } else if (this.listeners instanceof SshFutureListener) {
                this.listeners = new Object[]{this.listeners, listener};
            } else {
                Object[] ol = (Object[])this.listeners;
                int l = ol.length;
                Object[] nl = new Object[l + 1];
                System.arraycopy(ol, 0, nl, 0, l);
                nl[l] = listener;
                this.listeners = nl;
            }
        }
        if (notifyNow) {
            this.notifyListener(listener);
        }
        return this.asT();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T removeListener(SshFutureListener<T> listener) {
        ValidateUtils.checkNotNull(listener, "No listener provided");
        Object object = this.lock;
        synchronized (object) {
            if (this.result == null && this.listeners != null) {
                if (this.listeners == listener) {
                    this.listeners = null;
                } else {
                    int l = Array.getLength(this.listeners);
                    for (int i = 0; i < l; ++i) {
                        if (Array.get(this.listeners, i) != listener) continue;
                        Array.set(this.listeners, i, null);
                        break;
                    }
                }
            }
        }
        return this.asT();
    }

    private void notifyListeners() {
        if (this.listeners != null) {
            if (this.listeners instanceof SshFutureListener) {
                this.notifyListener(this.asListener(this.listeners));
            } else {
                int l = Array.getLength(this.listeners);
                for (int i = 0; i < l; ++i) {
                    SshFutureListener<T> listener = this.asListener(Array.get(this.listeners, i));
                    if (listener == null) continue;
                    this.notifyListener(listener);
                }
            }
        }
    }

    private void notifyListener(SshFutureListener<T> l) {
        try {
            l.operationComplete(this.asT());
        }
        catch (Throwable t) {
            this.log.warn("Listener threw an exception", t);
        }
    }

    public boolean isCanceled() {
        return this.getValue() == CANCELED;
    }

    public void cancel() {
        this.setValue(CANCELED);
    }

    private SshFutureListener<T> asListener(Object o) {
        return (SshFutureListener)o;
    }

    private T asT() {
        return (T)this;
    }
}

