/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit;

import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.munit.FTPServer;
import org.mule.munit.SFTPServer;
import org.mule.munit.Server;

public class FTPServerModule {
    private static transient Logger logger = LogManager.getLogger(FTPServerModule.class);
    private int port;
    private boolean secure;
    private boolean anonymous;
    private String username;
    private String password;
    private String homeDir;
    private Server server;

    public void startServer() {
        this.server.start();
    }

    public void containsFiles(String file, String path) {
        this.server.containsFiles(file, this.getAbsolutePath(path));
    }

    private String getAbsolutePath(String path) {
        return StringUtils.isNotBlank((String)this.homeDir) ? this.homeDir + path : path;
    }

    public void stopServer() {
        try {
            this.server.stop();
        }
        catch (Throwable t) {
            logger.error("The server has failed to stop", t);
        }
    }

    public void remove(String path) {
        this.server.remove(this.getAbsolutePath(path));
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setHomeDir(String homeDir) {
        if (homeDir != null && homeDir.startsWith("~")) {
            homeDir = System.getProperty("user.home") + StringUtils.substring((String)homeDir, (int)1);
        }
        this.homeDir = homeDir;
    }

    @PostConstruct
    public void buildServer() throws InitialisationException {
        this.server = this.secure ? new SFTPServer() : new FTPServer();
        this.server.initialize(this.port, this.username, this.password, this.anonymous, this.getHomeDir());
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHomeDir() {
        return this.homeDir;
    }
}

