/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.channel;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.FactoryManagerUtils;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.channel.AbstractChannel;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelAsyncOutputStream;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.channel.ChannelRequestHandler;
import org.apache.sshd.common.channel.PtyMode;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.file.FileSystemAware;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.DefaultCloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.CloseableUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.LoggingFilterOutputStream;
import org.apache.sshd.server.AsyncCommand;
import org.apache.sshd.server.ChannelSessionAware;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.Signal;
import org.apache.sshd.server.SignalListener;
import org.apache.sshd.server.channel.AbstractServerChannel;
import org.apache.sshd.server.channel.AsyncDataReceiver;
import org.apache.sshd.server.channel.ChannelDataReceiver;
import org.apache.sshd.server.channel.PipeDataReceiver;
import org.apache.sshd.server.channel.PuttyRequestHandler;
import org.apache.sshd.server.forward.ForwardingFilter;
import org.apache.sshd.server.session.ServerSession;

public class ChannelSession
extends AbstractServerChannel {
    public static final long DEFAULT_COMMAND_EXIT_TIMEOUT = 5000L;
    protected String type;
    protected ChannelAsyncOutputStream asyncOut;
    protected ChannelAsyncOutputStream asyncErr;
    protected OutputStream out;
    protected OutputStream err;
    protected Command command;
    protected ChannelDataReceiver receiver;
    protected StandardEnvironment env = new StandardEnvironment();
    protected Buffer tempBuffer;
    protected final CloseFuture commandExitFuture = new DefaultCloseFuture(this.lock);

    public ChannelSession() {
        this.addRequestHandler(new ChannelSessionRequestHandler());
        this.addRequestHandler(new PuttyRequestHandler());
    }

    @Override
    public void handleWindowAdjust(Buffer buffer) throws IOException {
        super.handleWindowAdjust(buffer);
        if (this.asyncOut != null) {
            this.asyncOut.onWindowExpanded();
        }
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().sequential(new CommandCloseable(), new AbstractChannel.GracefulChannelCloseable()).parallel(this.asyncOut, this.asyncErr).build();
    }

    @Override
    protected void doCloseImmediately() {
        if (this.command != null) {
            this.command.destroy();
            this.command = null;
        }
        this.remoteWindow.notifyClosed();
        IoUtils.closeQuietly(this.out, this.err, this.receiver);
        super.doCloseImmediately();
    }

    @Override
    public void handleEof() throws IOException {
        super.handleEof();
        IoUtils.closeQuietly(this.receiver);
    }

    @Override
    protected void doWriteData(byte[] data, int off, int len) throws IOException {
        if (this.isClosing()) {
            return;
        }
        if (this.receiver != null) {
            int r = this.receiver.data(this, data, off, len);
            if (r > 0) {
                this.localWindow.consumeAndCheck(r);
            }
        } else {
            if (this.tempBuffer == null) {
                this.tempBuffer = new ByteArrayBuffer(len);
            }
            this.tempBuffer.putRawBytes(data, off, len);
        }
    }

    @Override
    protected void doWriteExtendedData(byte[] data, int off, int len) throws IOException {
        throw new UnsupportedOperationException("Server channel does not support extended data");
    }

    public Boolean handleRequest(String type, Buffer buffer) throws IOException {
        switch (type) {
            case "env": {
                return this.handleEnv(buffer);
            }
            case "pty-req": {
                return this.handlePtyReq(buffer);
            }
            case "window-change": {
                return this.handleWindowChange(buffer);
            }
            case "signal": {
                return this.handleSignal(buffer);
            }
            case "break": {
                return this.handleBreak(buffer);
            }
            case "shell": {
                if (this.type == null && this.handleShell(buffer)) {
                    this.type = type;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case "exec": {
                if (this.type == null && this.handleExec(buffer)) {
                    this.type = type;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case "subsystem": {
                if (this.type == null && this.handleSubsystem(buffer)) {
                    this.type = type;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case "auth-agent-req@openssh.com": {
                return this.handleAgentForwarding(buffer);
            }
            case "x11-req": {
                return this.handleX11Forwarding(buffer);
            }
        }
        return null;
    }

    protected boolean handleEnv(Buffer buffer) throws IOException {
        String name = buffer.getString();
        String value = buffer.getString();
        this.addEnvVariable(name, value);
        if (this.log.isDebugEnabled()) {
            this.log.debug("env for channel {}: {} = {}", new Object[]{this.id, name, value});
        }
        return true;
    }

    protected boolean handlePtyReq(Buffer buffer) throws IOException {
        String term = buffer.getString();
        int tColumns = buffer.getInt();
        int tRows = buffer.getInt();
        int tWidth = buffer.getInt();
        int tHeight = buffer.getInt();
        byte[] modes = buffer.getBytes();
        StandardEnvironment environment = this.getEnvironment();
        Map<PtyMode, Integer> ptyModes = environment.getPtyModes();
        int i = 0;
        while (i < modes.length && modes[i] != 0) {
            int opcode;
            PtyMode mode;
            if ((mode = PtyMode.fromInt(opcode = modes[i++] & 0xFF)) == null) {
                this.log.warn("Unknown pty opcode value: " + opcode);
                break;
            }
            int val = modes[i++] << 24 & 0xFF000000 | modes[i++] << 16 & 0xFF0000 | modes[i++] << 8 & 0xFF00 | modes[i++] & 0xFF;
            ptyModes.put(mode, val);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("pty for channel {}: term={}, size=({} - {}), pixels=({}, {}), modes=[{}]", new Object[]{this.id, term, tColumns, tRows, tWidth, tHeight, ptyModes});
        }
        this.addEnvVariable("TERM", term);
        this.addEnvVariable("COLUMNS", Integer.toString(tColumns));
        this.addEnvVariable("LINES", Integer.toString(tRows));
        return true;
    }

    protected boolean handleWindowChange(Buffer buffer) throws IOException {
        int tColumns = buffer.getInt();
        int tRows = buffer.getInt();
        int tWidth = buffer.getInt();
        int tHeight = buffer.getInt();
        if (this.log.isDebugEnabled()) {
            this.log.debug("window-change for channel {}: ({} - {}), ({}, {})", new Object[]{this.id, tColumns, tRows, tWidth, tHeight});
        }
        StandardEnvironment e = this.getEnvironment();
        e.set("COLUMNS", Integer.toString(tColumns));
        e.set("LINES", Integer.toString(tRows));
        e.signal(Signal.WINCH);
        return true;
    }

    protected boolean handleSignal(Buffer buffer) throws IOException {
        Signal signal;
        String name = buffer.getString();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Signal received on channel {}: {}", (Object)this.id, (Object)name);
        }
        if ((signal = Signal.get(name)) != null) {
            this.getEnvironment().signal(signal);
        } else {
            this.log.warn("Unknown signal received: " + name);
        }
        return true;
    }

    protected boolean handleBreak(Buffer buffer) throws IOException {
        String name = buffer.getString();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Break received on channel {}: {}", (Object)this.id, (Object)name);
        }
        this.getEnvironment().signal(Signal.INT);
        return true;
    }

    protected boolean handleShell(Buffer buffer) throws IOException {
        if (this.isClosing()) {
            this.log.debug("handleShell - closing");
            return false;
        }
        ServerFactoryManager manager = ((ServerSession)this.session).getFactoryManager();
        Factory<Command> factory = manager.getShellFactory();
        if (factory == null) {
            this.log.debug("handleShell - no shell factory");
            return false;
        }
        this.command = factory.create();
        if (this.command == null) {
            this.log.debug("handleShell - no shell command");
            return false;
        }
        this.prepareCommand();
        this.command.start(this.getEnvironment());
        return true;
    }

    protected boolean handleExec(Buffer buffer) throws IOException {
        if (this.isClosing()) {
            return false;
        }
        String commandLine = buffer.getString();
        ServerFactoryManager manager = ((ServerSession)this.session).getFactoryManager();
        CommandFactory factory = manager.getCommandFactory();
        if (factory == null) {
            this.log.warn("No command factory for command: {}", (Object)commandLine);
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Executing command: {}", (Object)commandLine);
        }
        try {
            this.command = factory.createCommand(commandLine);
        }
        catch (RuntimeException iae) {
            this.log.warn("Failed (" + iae.getClass().getSimpleName() + ") to create command for " + commandLine + ": " + iae.getMessage());
            return false;
        }
        this.prepareCommand();
        this.command.start(this.getEnvironment());
        return true;
    }

    protected boolean handleSubsystem(Buffer buffer) throws IOException {
        String subsystem = buffer.getString();
        ServerFactoryManager manager = ((ServerSession)this.session).getFactoryManager();
        List<NamedFactory<Command>> factories = manager.getSubsystemFactories();
        if (GenericUtils.isEmpty(factories)) {
            this.log.warn("No factories for subsystem: {}", (Object)subsystem);
            return false;
        }
        this.command = NamedFactory.Utils.create(factories, subsystem);
        if (this.command == null) {
            this.log.warn("Unsupported subsystem: {}", (Object)subsystem);
            return false;
        }
        this.prepareCommand();
        this.command.start(this.getEnvironment());
        return true;
    }

    public void setDataReceiver(ChannelDataReceiver receiver) {
        this.receiver = receiver;
    }

    protected void prepareCommand() throws IOException {
        this.addEnvVariable("USER", this.session.getUsername());
        if (this.command instanceof SessionAware) {
            ((SessionAware)((Object)this.command)).setSession((ServerSession)this.session);
        }
        if (this.command instanceof ChannelSessionAware) {
            ((ChannelSessionAware)((Object)this.command)).setChannelSession(this);
        }
        if (this.command instanceof FileSystemAware) {
            FileSystemFactory factory = ((ServerSession)this.session).getFactoryManager().getFileSystemFactory();
            ((FileSystemAware)((Object)this.command)).setFileSystem(factory.createFileSystem(this.session));
        }
        if (this.command instanceof AsyncCommand) {
            this.asyncOut = new ChannelAsyncOutputStream(this, 94);
            this.asyncErr = new ChannelAsyncOutputStream(this, 95);
            ((AsyncCommand)this.command).setIoOutputStream(this.asyncOut);
            ((AsyncCommand)this.command).setIoErrorStream(this.asyncErr);
        } else {
            this.out = new ChannelOutputStream(this, this.remoteWindow, this.log, 94);
            this.err = new ChannelOutputStream(this, this.remoteWindow, this.log, 95);
            if (this.log.isTraceEnabled()) {
                this.out = new LoggingFilterOutputStream(this.out, "OUT:", this.log);
                this.err = new LoggingFilterOutputStream(this.err, "ERR:", this.log);
            }
            this.command.setOutputStream(this.out);
            this.command.setErrorStream(this.err);
        }
        if (this.receiver == null) {
            ChannelDataReceiver recv;
            if (this.command instanceof AsyncCommand) {
                recv = new AsyncDataReceiver(this);
                this.setDataReceiver(recv);
                ((AsyncCommand)this.command).setIoInputStream(((AsyncDataReceiver)recv).getIn());
            } else {
                recv = new PipeDataReceiver(this.localWindow);
                this.setDataReceiver(recv);
                this.command.setInputStream(((PipeDataReceiver)recv).getIn());
            }
        }
        if (this.tempBuffer != null) {
            Buffer buffer = this.tempBuffer;
            this.tempBuffer = null;
            this.doWriteData(buffer.array(), buffer.rpos(), buffer.available());
        }
        this.command.setExitCallback(new ExitCallback(){

            @Override
            public void onExit(int exitValue) {
                this.onExit(exitValue, "");
            }

            @Override
            public void onExit(int exitValue, String exitMessage) {
                try {
                    ChannelSession.this.closeShell(exitValue);
                    if (ChannelSession.this.log.isDebugEnabled()) {
                        ChannelSession.this.log.debug("onExit(" + exitValue + ")[" + exitMessage + ") shell closed");
                    }
                }
                catch (IOException e) {
                    ChannelSession.this.log.warn("onExit(" + exitValue + ")[" + exitMessage + ") Error closing shell", (Throwable)e);
                }
            }
        });
    }

    protected int getPtyModeValue(PtyMode mode) {
        Number v = this.getEnvironment().getPtyModes().get((Object)mode);
        return v != null ? v.intValue() : 0;
    }

    protected boolean handleAgentForwarding(Buffer buffer) throws IOException {
        ValidateUtils.checkTrue(this.session instanceof ServerSession, "Session not a server one");
        FactoryManager manager = this.session.getFactoryManager();
        ForwardingFilter filter = manager.getTcpipForwardingFilter();
        SshAgentFactory factory = manager.getAgentFactory();
        if (factory == null || filter == null || !filter.canForwardAgent(this.session)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleAgentForwarding(" + this.session + ")[haveFactory=" + (factory != null) + ",haveFilter=" + (filter != null) + "] filtered out");
            }
            return false;
        }
        String authSocket = this.service.initAgentForward();
        this.addEnvVariable("SSH_AUTH_SOCK", authSocket);
        return true;
    }

    protected boolean handleX11Forwarding(Buffer buffer) throws IOException {
        int screenId;
        String authCookie;
        String authProtocol;
        ValidateUtils.checkTrue(this.session instanceof ServerSession, "Session not a server one");
        FactoryManager manager = this.session.getFactoryManager();
        ForwardingFilter filter = manager.getTcpipForwardingFilter();
        if (filter == null || !filter.canForwardX11(this.session)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleX11Forwarding(" + this.session + ")[haveFilter=" + (filter != null) + "] filtered out");
            }
            return false;
        }
        boolean singleConnection = buffer.getBoolean();
        String display = this.service.createX11Display(singleConnection, authProtocol = buffer.getString(), authCookie = buffer.getString(), screenId = buffer.getInt());
        if (GenericUtils.isEmpty(display)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleX11Forwarding(" + this.session + ") no X.11 display created");
            }
            return false;
        }
        this.addEnvVariable("DISPLAY", display);
        return true;
    }

    protected void addEnvVariable(String name, String value) {
        this.getEnvironment().set(name, value);
    }

    protected StandardEnvironment getEnvironment() {
        return this.env;
    }

    protected void closeShell(int exitValue) throws IOException {
        if (!this.isClosing()) {
            this.sendEof();
            this.sendExitStatus(exitValue);
            this.commandExitFuture.setClosed();
            this.close(false);
        } else {
            this.commandExitFuture.setClosed();
        }
    }

    private class ChannelSessionRequestHandler
    implements ChannelRequestHandler {
        @Override
        public RequestHandler.Result process(Channel channel, String request, boolean wantReply, Buffer buffer) throws Exception {
            Boolean r = ChannelSession.this.handleRequest(request, buffer);
            if (r == null) {
                return RequestHandler.Result.Unsupported;
            }
            return r != false ? RequestHandler.Result.ReplySuccess : RequestHandler.Result.ReplyFailure;
        }
    }

    public class CommandCloseable
    extends CloseableUtils.IoBaseCloseable {
        @Override
        public boolean isClosed() {
            return ChannelSession.this.commandExitFuture.isClosed();
        }

        @Override
        public boolean isClosing() {
            return this.isClosed();
        }

        @Override
        public CloseFuture close(boolean immediately) {
            if (immediately || ChannelSession.this.command == null) {
                ChannelSession.this.commandExitFuture.setClosed();
            } else if (!ChannelSession.this.commandExitFuture.isClosed()) {
                IoUtils.closeQuietly(ChannelSession.this.receiver);
                final TimerTask task = new TimerTask(){

                    @Override
                    public void run() {
                        ChannelSession.this.commandExitFuture.setClosed();
                    }
                };
                FactoryManager manager = ChannelSession.this.getSession().getFactoryManager();
                long timeout = FactoryManagerUtils.getLongProperty(manager, "command-exit-timeout", 5000L);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Wait {} ms for shell to exit cleanly", (Object)timeout);
                }
                manager.getScheduledExecutorService().schedule(task, timeout, TimeUnit.MILLISECONDS);
                ChannelSession.this.commandExitFuture.addListener(new SshFutureListener<CloseFuture>(){

                    @Override
                    public void operationComplete(CloseFuture future) {
                        task.cancel();
                    }
                });
            }
            return ChannelSession.this.commandExitFuture;
        }
    }

    protected static class StandardEnvironment
    implements Environment {
        private final Map<Signal, Set<SignalListener>> listeners = new ConcurrentHashMap<Signal, Set<SignalListener>>(3);
        private final Map<String, String> env = new ConcurrentHashMap<String, String>();
        private final Map<PtyMode, Integer> ptyModes = new ConcurrentHashMap<PtyMode, Integer>();

        @Override
        public void addSignalListener(SignalListener listener, Signal ... signals) {
            if (signals == null) {
                throw new IllegalArgumentException("signals may not be null");
            }
            this.addSignalListener(listener, Arrays.asList(signals));
        }

        @Override
        public void addSignalListener(SignalListener listener) {
            this.addSignalListener(listener, Signal.SIGNALS);
        }

        @Override
        public void addSignalListener(SignalListener listener, Collection<Signal> signals) {
            if (listener == null) {
                throw new IllegalArgumentException("listener may not be null");
            }
            if (signals == null) {
                throw new IllegalArgumentException("signals may not be null");
            }
            for (Signal s : signals) {
                this.getSignalListeners(s, true).add(listener);
            }
        }

        @Override
        public Map<String, String> getEnv() {
            return this.env;
        }

        @Override
        public Map<PtyMode, Integer> getPtyModes() {
            return this.ptyModes;
        }

        @Override
        public void removeSignalListener(SignalListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("listener may not be null");
            }
            for (Signal s : Signal.SIGNALS) {
                Set<SignalListener> ls = this.getSignalListeners(s, false);
                if (ls == null) continue;
                ls.remove(listener);
            }
        }

        public void signal(Signal signal) {
            Set<SignalListener> ls = this.getSignalListeners(signal, false);
            if (ls != null) {
                for (SignalListener l : ls) {
                    l.signal(signal);
                }
            }
        }

        public void set(String key, String value) {
            this.getEnv().put(key, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Set<SignalListener> getSignalListeners(Signal signal, boolean create) {
            Set<SignalListener> ls = this.listeners.get((Object)signal);
            if (ls == null && create) {
                Map<Signal, Set<SignalListener>> map = this.listeners;
                synchronized (map) {
                    ls = this.listeners.get((Object)signal);
                    if (ls == null) {
                        ls = new CopyOnWriteArraySet<SignalListener>();
                        this.listeners.put(signal, ls);
                    }
                }
            }
            return ls;
        }
    }
}

