/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.munit.core.ftp;

import org.mule.munit.core.AbstractFTPServer;
import org.mule.munit.core.MockUserManagerAuthenticator;

import org.apache.commons.lang3.StringUtils;
import org.apache.ftpserver.ConnectionConfig;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.ftplet.*;
import org.apache.ftpserver.listener.ListenerFactory;

/**
 * <p>Wrapper of the FTP Server</p>
 *
 * @author Mulesoft Inc.
 */
public class FTPServer extends AbstractFTPServer {

  private FtpServer server;

  public FTPServer(int port, String username, String password, boolean anonymous, String homeDir) {
    super(homeDir);

    ListenerFactory listenerFactory = new ListenerFactory();
    listenerFactory.setPort(port);

    FtpServerFactory serverFactory = new FtpServerFactory();
    serverFactory.setConnectionConfig(new MockConnectionConfig(anonymous));
    serverFactory.setUserManager(getUserManager(username, password, anonymous));

    serverFactory.addListener("default", listenerFactory.createListener());

    server = serverFactory.createServer();

  }

  @Override
  public void start() {
    try {
      server.start();
    } catch (FtpException e) {
      throw new RuntimeException("Could not start FTP server", e);
    }
  }

  @Override
  public void stop() {
    server.stop();
  }

  private class MockConnectionConfig implements ConnectionConfig {

    private boolean anonymous;

    public MockConnectionConfig(boolean anonymous) {
      this.anonymous = anonymous;
    }

    public int getMaxThreads() {
      return 0;
    }

    public int getMaxLoginFailures() {
      return 0;
    }

    public int getLoginFailureDelay() {
      return 0;
    }

    public int getMaxAnonymousLogins() {
      return 100;
    }

    public int getMaxLogins() {
      return 0;
    }

    public boolean isAnonymousLoginEnabled() {
      return anonymous;
    }
  }
}
