/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.munit.extension;

import org.mule.munit.core.AbstractFTPServer;
import org.mule.runtime.extension.api.annotation.param.Connection;


/**
 * <p>
 * Operations of the DBServer
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class FTPServerOperations {

  /**
   * <p>check if a file exists.</p
   * <p/>
   * {@sample.xml ../../../doc/SFTPServer-connector.xml.sample sftpserver:containsFiles}
   *
   * @param file The file name that you want to check if is in the ftp.
   * @param path Relative path where it is going to be the file relatively to the home directory.
   */
  public void containsFiles(String file, String path, @Connection AbstractFTPServer server) {
    server.containsFiles(file, path);
  }

  /**
   * <p>Remove created files</p>
   * <p/>
   * {@sample.xml ../../../doc/SFTPServer-connector.xml.sample sftpserver:remove}
   *
   * @param path Path to be removed.
   */
  public void remove(String path, @Connection AbstractFTPServer server) {
    server.remove(path);
  }
}
