/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.munit.core;

import org.apache.ftpserver.ftplet.Authority;
import org.apache.ftpserver.ftplet.AuthorizationRequest;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.usermanager.impl.BaseUser;
import org.apache.ftpserver.usermanager.impl.TransferRateRequest;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>Mock User for testing</p>
 *
 * @author Mulesoft Inc.
 */
public class MockUser extends BaseUser {

  private String name;
  private String password;

  public MockUser(String name, String password) {
    this.name = name;
    this.password = password;
  }

  @Override
  public String getName() {
    return this.name;
  }

  @Override
  public String getPassword() {
    return this.password;
  }

  @Override
  public List<Authority> getAuthorities() {
    return new ArrayList<>();
  }

  @Override
  public List<Authority> getAuthorities(Class<? extends Authority> aClass) {
    return new ArrayList<>();
  }

  @Override
  public AuthorizationRequest authorize(AuthorizationRequest authorizationRequest) {
    return new TransferRateRequest() {};
  }

  @Override
  public int getMaxIdleTime() {
    return 5;
  }

  @Override
  public boolean getEnabled() {
    return true;
  }
}
