/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.munit.core.sftp;

import org.mule.munit.core.AbstractFTPServer;
import org.mule.munit.core.MockUserManagerAuthenticator;

import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.file.virtualfs.VirtualFileSystemFactory;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.command.ScpCommandFactory;
import org.apache.sshd.server.shell.ProcessShellFactory;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystemFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

import java.io.IOException;
import java.security.Security;
import java.util.Arrays;

/**
 * <p>SFTP Wrapper</p>
 *
 * @author Mulesoft Inc.
 */
public class SFTPServer extends AbstractFTPServer {

  private SshServer sshd;

  public SFTPServer(int port, String username, String password, boolean anonymous, String homeDir) {
    super(homeDir);
    Security.addProvider(new BouncyCastleProvider());
    sshd = SshServer.setUpDefaultServer();
    sshd.setPort(port);

    sshd.setFileSystemFactory(new VirtualFileSystemFactory(getAdaptedPath(getHomeDir())));

    StreamKeyPairProvider fileKeyPairProvider = new StreamKeyPairProvider();
    sshd.setKeyPairProvider(fileKeyPairProvider);

    SftpSubsystemFactory factory = new SftpSubsystemFactory();
    sshd.setSubsystemFactories(Arrays.asList(factory));

    sshd.setCommandFactory(new ScpCommandFactory());
    sshd.setShellFactory(new ProcessShellFactory());
    sshd.setPasswordAuthenticator(getUserManager(username, password, anonymous));
  }

  @Override
  public void start() {
    try {
      sshd.start();
    } catch (IOException e) {
      throw new RuntimeException("Could not start the server", e);
    }
  }

  @Override
  public void stop() {
    try {
      sshd.stop();
    } catch (IOException e) {
      throw new RuntimeException("Could not stop the server", e);
    }
    sshd = null;
  }


}
