/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.munit.core.sftp;

import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.util.SecurityUtils;
import org.python.bouncycastle.openssl.PEMDecryptorProvider;
import org.python.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.python.bouncycastle.openssl.PEMKeyPair;
import org.python.bouncycastle.openssl.PEMParser;
import org.python.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.python.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.InputStreamReader;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>Reads the resource from the jar</p>
 *
 * @author Mulesoft Inc.
 */
public class StreamKeyPairProvider extends AbstractKeyPairProvider {

  private static final Logger LOG = LoggerFactory.getLogger(StreamKeyPairProvider.class);

  public Iterable<KeyPair> loadKeys() {
    if (!SecurityUtils.isBouncyCastleRegistered()) {
      throw new IllegalStateException("BouncyCastle must be registered as a JCE provider");
    }
    List<KeyPair> keys = new ArrayList<KeyPair>();
    try {

      KeyPair kp = readPemFile();
      keys.add(kp);
    } catch (Exception e) {
      LOG.info("Unable to read key ", e);
    }
    return keys;
  }

  private KeyPair readPemFile() throws IOException {

    PEMParser pemParser = new PEMParser(new InputStreamReader(getClass().getResourceAsStream("/ftp-hostkey.pem")));
    try {
      Object object = pemParser.readObject();
      PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().build("".toCharArray());
      JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
      KeyPair kp;

      if (object instanceof PEMEncryptedKeyPair) {
        kp = converter.getKeyPair(((PEMEncryptedKeyPair) object).decryptKeyPair(decProv));
      } else {
        kp = converter.getKeyPair((PEMKeyPair) object);
      }
      return kp;
    } finally {
      pemParser.close();

    }
  }

}
